' Regulation de temperature pour Picboard et DS1820
' sortie pour commande de servo standard - avec inversion de sens.

'Ok le 30/08/2004 - 837 lignes sans EEPROM

' Define LCD registers and bits

Define	LCD_EBIT	1


'*****************************************************************************
'Affectation des Ports
'*****************************************************************************

Revs			Var PORTA.0
DQ				Var PORTA.1
SCL				Var	PORTA.2
SDA				Var	PORTA.3
WP				Var	PORTA.4


'Servo			Var PORTB.0		' Servo de commande - pour test

Batt			Var PORTB.1
'Revs			Var PORTB.2		' Inversion de servo - pour test
'DQ				Var PORTB.0
'DQ				Var	PORTB.4			' One-wire data pin - pour test
Servo			Var PORTB.4 
'Ok				Var PORTB.5			' Led Verte
Ledb			Var PORTB.5
'Waito			Var PORTB.6			' Led Orange
Leda			Var PORTB.6
'Error			Var PORTB.7			' Led Rouge
Commande		Var PORTB.7			' Entre de commande


'*****************************************************************************
'Affectation des variables
'*****************************************************************************

count_remain 	Var Byte			' Count remaining
count_per_c 	Var	Byte			' Count per degree C
Echantillon		Var Byte			' Compteur d'chantillons
Comval			Var Byte			' Valeur de commande


temperature 	Var	Word			' Temperature storage
'offset			Var Word			' 100 * offset rel DS 1820 !!!
Servopos		Var Word			' Position servo
Servoposold		Var Word
Servoposc		Var Word
Sign			Var Word
Err				Var Word
P				Var Word
I				Var Word

Drive			Var Word
Lasterr			Var Word
IntCount		Var Word
Countenr		Var Word
EI				Var Word



CLEAR


'*****************************************************************************
'Prpositionnement des Valeurs
'*****************************************************************************

offset 			con 293
SP				con 250				'Point de consigne en 1/10 C
Range 			con 100				'Intervalle de rgulation en 1/10 C
B				con 50				'Centrage de rgul ( +/- 50% )
Kp				con 10
Ki				con 2
Kd				con 0
Ti 				con 24 '( *5 )

Cont			con %10100000		'Adresse EEPROM


'*****************************************************************************
'Positionnement des volets  la mise sous tension
'*****************************************************************************

	IF Revs THEN
	
		Servoposold = 100
		
		ELSE
	
		Servoposold = 200
		
	ENDIF

'*****************************************************************************
'*****************************************************************************
'Dbut de Programme de rgulation
'*****************************************************************************
'*****************************************************************************

'*****************************************************************************
'Demande de Conversion de temperature
'*****************************************************************************

mesutemp: OWOut DQ, 1, [$CC, $44 ]


'*****************************************************************************
' Attente fin de conversion 
'*****************************************************************************

	INPUT DQ
		
Manuel:

	PULSIN Commande, 1, Comval

	IF ( Comval > 220 ) OR ( Comval < 80 ) THEN Suite

	IF (( Comval > 190 )AND REVS) OR ((Comval < 110) AND NOT Revs) THEN
	
		IF Revs THEN	'Positionnement des volets pleine ouverture
		
			Comval = 200
			
			ELSE
			
			Comval = 100
			
		ENDIF
		
		LOW Servo
					
		PULSOUT Servo, Comval

		PAUSE 20
		
		GOTO Manuel	

	ENDIF
		
Suite:

		If NOT DQ Then Manuel
		If NOT DQ Then Manuel
	
'*****************************************************************************
' Lecture de la temperature
'*****************************************************************************
	
	OWOut DQ, 1, [$CC, $BE ]		
	
    OWIn DQ, 0, [temperature.LOWBYTE, temperature.HIGHBYTE, Skip 4, count_remain, count_per_c]

'*****************************************************************************
' Calcul de temperature en degres C avec 2 decimales 
'*****************************************************************************
	
	temperature = (((temperature >> 1) * 100) - 25) + (((count_per_c - count_remain) * 100) / count_per_c)+ offset
	

'*****************************************************************************
'Enregistrement de la temprature
'*****************************************************************************

' 	IF NOT ( Countenr /50 ) THEN

'		I2CWRITE SDA, SCL, Cont, [( temperature / 100 )]

'	ENDIF
	
'	Countenr = Countenr + 1

'*****************************************************************************
'Calcul d'erreur
'*****************************************************************************

	Err = SP - ( Temperature / 10 )
	Sign = Err
	
	GOSUB Setsign
	
	Err = ABS Err*100/Range
	Err = Err*Sign

'*****************************************************************************	
'Calcul terme proportionnel
'*****************************************************************************

	Sign = Err
	
	GOSUB Setsign
	
	P = ABS ( Err * Kp + 5 ) / 10
	P = P * Sign
	
'*****************************************************************************
'Calcul terme Intgrale
'*****************************************************************************

	Ei = Ei + Err
	Intcount = Intcount + 1
	
	IF Intcount < Ti THEN Intdone
	
	Sign = Ei
	
	GOSUB Setsign
	
	Ei = ABS Ei / Ti
	Ei = ( Ei * Ki + 5 ) /10
	Ei = Ei * Sign
	I  = I + Ei
	Sign = I
	
	GOSUB Setsign
	
	I = ABS I MIN 100
	I = I * Sign
	Intcount = 0
	Ei = 0
	
Intdone:

'*****************************************************************************
'Calcul terme drive
'*****************************************************************************

'	D = ( Err - Lasterr ) * Kd
	
	Lasterr = Err
	
'*****************************************************************************
'Calcul de la commande
'*****************************************************************************

	Drive = ( B + P + I )' + D )
	Sign = Drive
	
	GOSUB Setsign
	
	Drive = ABS Drive MIN 100
	
	IF Sign = 1 THEN Drivdone
	
	Drive = 0
	
Drivdone:
	
'*****************************************************************************
'Positionnement servo
'*****************************************************************************

	IF Revs THEN
	
		Servopos = 200 - Drive
		
		ELSE
		
		Servopos = 100 + Drive
	
	ENDIF
	
'*****************************************************************************
'Lissage du mouvement
'*****************************************************************************

	Echantillon = 0
	Servoposc = Servopos

	IF  Servopos > ( Servoposold + 1 ) THEN
 
		Servopos = ( Servoposold + 1 ) MIN Servoposc

	
	ENDIF
	
	IF Servopos < ( Servoposold - 1 ) THEN
	
		Servopos = ( Servoposold - 1 ) MAX Servoposc
	
	ENDIF
	
Limit:

	LOW Servo
	PULSOUT Servo,Servopos
		
	Servoposold = Servopos
	
	IF NOT ( Echantillon / 10 ) THEN
	
	Echantillon = Echantillon + 1
	
	PAUSE 20 
	
	GOTO Limit
		
	ENDIF
	
'	PAUSE 7
'*****************************************************************************
' Position du servo
'*****************************************************************************
	
'	LCDOUT $Fe, $C0, "servo = ", #( Servopos*10 )," ", $E4, "s"
	
	GOTO Mesutemp

'*****************************************************************************
'Signe
'*****************************************************************************
	
Setsign:

		IF Sign.15 = 0 THEN Signpos
		Sign = -1
		
	RETURN
		
Signpos:
		Sign = 1

	RETURN	
	
	END
