
    ' Master PIC
    ' ==========
    '
    ' File name : MasterPic.bas
    ' Company : Mister E 
    ' Programmer : Steve Monfette
    ' Date : 04/02/2005
    ' Device : PIC16F628


    ' This program will send serial data at 2400 bauds on the PORTA.3 pin
    '
    ' The send data will come from the DIP Switches connected on the PORTB.
    '
    ' The send data will have a "header" that will include the 
    ' "SlaveSelect" setting build with the DIP switchs connected on PORTA<3:0>
    '
    ' This header will be send as follow.
    '      1. Send "SLAVE" in a string
    '      2. Send the SlaveSelect variable
               

    ' PIC programming mode
    ' ====================
    '
@ __config _INTRC_OSC_NOCLKOUT & _WDT_ON & _PWRTE_ON & _MCLRE_OFF & _LVP_OFF & _BODEN_ON 
    ' Internal Oscillator
    ' Enable watch dog timer
    ' Enable power up timer
    ' Disable MCLR pin
    ' Disable low voltage programming
    ' Enable brown out detect
    
    ' Hardware setting
    ' ================
    '
    TRISB = %11111111 ' Set PORTB as input on all pins
    TRISA = %11110111 ' Set PORTA as :
                      '                Output : a.3
                      '                Input  : all other pins
                      '
    OPTION_REG.7 = 0  ' Enable pull-up on PORTB
    CMCON = 7         ' Disable analog comparator
    
    ' Variable, Constant & Alias definition
    ' =====================================
    '
    DataToSend      var     PORTB
    SerialOutput    var     PORTA.3
    TransmitButton  var     PORTA.4
    SlaveSelect     var     BYTE
    
    T2400           con     0 ' Baudrate Variable for
                              ' 2400 Bauds
                              ' True driven mode

    ' Hardware initialisation
    ' =======================
    '
    SerialOutput = 1 ' to avoid the first serial comm to fart
    pause 50
    
    ' Main Program
    ' ============
    '
Start :

    While transmitbutton = 0 ' wait until "transmission" button
    wend                     ' is press
    
    SlaveSelect=PORTA & $07  ' Get the Slave Select by masking
                             ' PORTA<3:0>

    ' Send the data on the "network"
    ' ==============================
    '
    serout serialoutput, t2400, ["SLAVE",SlaveSelect,DATATOSEND]

    WHILE transmitbutton ' waiting untill Push Button is release
    wend

    pause 50 ' Cheap debounce time

    goto Start
