/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codeHEXFileHandler.cpp
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/



#pragma hdrstop
/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------
#include "codeHEXFileHandler.h"

//---------------------------------------------------------------------------

#pragma package(smart_init)
/** V A R I A B L E S ********************************************************/
//---------------------------------------------------------------------------

/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------
/******************************************************************************
 * Function:        int HEXFileHandler::ImportP18HEXFile(AnsiString FileName)
 *
 * PreCondition:    None
 *
 * Input:           FileName - HEX file name to be loaded along with complete path.
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Loads the given HEX file into the string variables
 *                  PMOut(Program Memory), EEOut(EEPROM Memory),
 *                  UIDOut(User ID Memory), CFGOut (CONFIG Memory)
 *
 * Note:            The data is formatted and loaded into these varibales.
 *                  The format is as following.
 *                  <\r\n>
 *                  <<6-digit HEX Address><Space><2-digit HEX Data1>...<Space><2-digit HEX Data16><\r\n>
 *****************************************************************************/
int HEXFileHandler::ImportP18HEXFile(AnsiString FileName)
{
        char FileLine[0xFF*2+1+2+4+2+2];
        int InData[256];
        int Checksum,LineDataCount,LineCode,DataByte;
        int DataCount,OutOffset,OutAddr,LineAddr,PrevAddr;
        int LineAddrHigh;
        AnsiString *HEXBuffer = NULL;

        int RetCode;
        int i;

        PMOut = "";
        EEOut = "";
        UIDOut = "";
        CFGOut = "";

        if ( (RetCode= ValidateHEXFile(FileName)) != 1) return RetCode;

        TFileStream *fp = new TFileStream(FileName,fmOpenRead);
        if (fp == NULL) return -1;
        int Size = fp->Size;
        int Count = 0;
        int c,Data;
        char *buf = new char[Size+1];
        if (buf == NULL) return -1;
        fp->Read(buf,Size);
        delete fp;


        DataCount = 0;
        while(Count < Size)
        {
            // Read The Line

            c = 0;
            while(Count < Size)
            {
                FileLine[c] = buf[Count];
                if (FileLine[c] == '\n') {FileLine[c] = 0; Count++;break;}
                c++;
                Count++;
            }

            // Check if it is a valid HEX File Line
            if (FileLine[0] == ':')
            {
                   sscanf(&FileLine[1],"%02X%04X%02X",&LineDataCount,&LineAddr,&LineCode);
                   LineAddr&=0xFFFF;
                   LineDataCount&=0xFF;
                   
                   // If additional FF need to be added so that the display matrix
                   // would be proper.

                   if (LineCode == 0) { // Memory Content

                            // Regular Program Memory
                            if (  LineAddrHigh >= 0x0 && LineAddrHigh <= 0x1F)
                            {
                                HEXBuffer = &PMOut;
                                OutAddr = (LineAddrHigh * 0x10000) + (LineAddr & 0xFFFF);
                            }
                            // User ID Memory
                            else if (LineAddrHigh == 0x20)
                            {
                                HEXBuffer = &UIDOut;
                                OutAddr = (LineAddrHigh * 0x10000) + (LineAddr & 0xFFFF);

                            }
                            // Config Memroy
                            else if (LineAddrHigh == 0x30)
                            {
                                HEXBuffer = &CFGOut;
                                OutAddr = (LineAddrHigh * 0x10000) + (LineAddr & 0xFFFF);
                            }
                            //EEDATA Memory
                            else if (LineAddrHigh == 0xF0)
                            {
                                HEXBuffer = &EEOut;
                                OutAddr = (LineAddr & 65520);
                            }

                            // Start filling the Appropriate Buffer
                            // Calculate the initial Buffer Start Address, that will be PrevAddr
                            if (PrevAddr == -1) {
                                PrevAddr = OutAddr - (OutAddr%0x10);
                            }

                            // If there is a gap between PrevAddr and CurrentAddr
                            // fill it with 0xFF

                            for ( ; PrevAddr < OutAddr; PrevAddr++)
                            {
                                if ((PrevAddr % 0x10) == 0) {
                                        //*HEXBuffer = *HEXBuffer + "\r\n"+IntToHex(PrevAddr,6)+" ";
                                        HEXBuffer->cat_sprintf("\r\n%06X ",PrevAddr);
                                    }
                                //*HEXBuffer = *HEXBuffer + "XX ";
                                HEXBuffer->cat_sprintf("XX ");

                            }

                            // Now start filling the data
                            for (i  = 0; i < LineDataCount; i++)
                            {
                                Data;
                                if ((PrevAddr % 0x10) == 0) {
                                        //*HEXBuffer = *HEXBuffer + "\r\n"+IntToHex(PrevAddr,6)+" ";
                                        HEXBuffer->cat_sprintf("\r\n%06X ",PrevAddr);
                                    }
                                sscanf(&FileLine[9+i*2],"%02x",&Data);
                                //*HEXBuffer = *HEXBuffer + IntToHex(Data,2)+ " ";
                                HEXBuffer->cat_sprintf("%02X ",Data);
                                PrevAddr++;
                            }
                   }   // LineCode == 0
                   else
                   {

                        if (LineCode == 1) { // End HEX file content break while loop
                                break;
                        }

                        if (LineCode == 4) { // Read the Start Address of the Block
                                // Reset all other details for new
                                // Memory Range
                                sscanf(&FileLine[9],"%04X",&LineAddrHigh);
                                DataCount = 0;
                                PrevAddr = -1;
                                HEXBuffer = NULL;
                        }
                   }

            } // End if ':'
        } // End while
}


/******************************************************************************
 * Function:        int HEXFileHandler::ValidateHEXFile(AnsiString FileName)
 *
 * PreCondition:    None
 *
 * Input:           FileName - HEX file name to be validated along with complete path.
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Validates the HEX file for it's contents and CRC
 *
 *
 *
 * Note:
 *****************************************************************************/

int HEXFileHandler::ValidateHEXFile(AnsiString FileName)
{
        int Checksum,DataCount,AddrCode,Address,DataByte;
        int i;
        AnsiString InFileLine;
        char FileLine[0xFF*2+1+2+4+2+2];
        FILE *fp;

        fp = fopen(FileName.c_str(),"r");
        if (fp == NULL) return -1;
        AddrCode = 0;
        while(!feof(fp))
        {
            int c = 0;

            while(!feof(fp))
            {
                FileLine[c] = fgetc(fp);
                if (FileLine[c] == '\n') {FileLine[c] = 0; break;}
                c++;
            }

            if (FileLine[0] == ':')
            {
               sscanf(&FileLine[1],"%02X%04X%02X",&DataCount,&Address,&AddrCode);
               Address&=0xFFFF;
               DataCount&=0xFF;
               Checksum = 0;

               for (i = 0; i <= DataCount+4; i++)
               {
                 sscanf(&FileLine[1+i*2],"%02X",&DataByte);
                 Checksum+=DataByte;
               }
               if (Checksum & 0xFF != 0) {
                        fclose(fp);
                        return -3;
               }
               if (AddrCode == 1) break;
               if (feof(fp)) {
                fclose(fp);return -5;
               }
            }
            else {
                fclose(fp);
                return 4;
            }

        } // while (!feof(fp))

        // Alignment related stuff as per APP NOTE 851if (
        fclose(fp);
        return 1;
}
/******************************************************************************
 * Function:        int HEXFileHandler::ImportP16HEXFile(AnsiString s)
 *
 * PreCondition:    None
 *
 * Input:           FileName - HEX file name to be loaded along with complete path.
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        None
 *
 *
 *
 * Note:            Not Implemented.
 *****************************************************************************/
int HEXFileHandler::ImportP16HEXFile(AnsiString s)
{

}
//---------------------------------------------------------------------------
/******************************************************************************
 * Function:        int HEXFileHandler::ImportP16HEXFile(AnsiString FileName)
 *
 * PreCondition:    None
 *
 * Input:           FileName - The filename along with complete path to be used
 *                  for storing the retrieve memory content. 
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Creates a file FileName as its name asd stores the contents
 *                  of the variables PMOut, EEOut, UIDOut and CFGOut into the
 *                  file in Intel HEX format.
 *
 * Note:            None
 *****************************************************************************/
int HEXFileHandler::ExportP18HEXFile(AnsiString FileName)
{
     int Checksum, Address, OldAddress,LineLength;
     AnsiString FileLine, OutFileLine;
     int Data,counter=0;
     char *DataPtr;
     AnsiString stringBuf;
     int DataCount = 0;

     // Generate the New Address
     // Generate the Checksum
     // Write the content to file

     if (!PMOut.IsEmpty()) {
        DataPtr = PMOut.c_str();
        Address = 0x7FFFFF;
        counter = 2; // Trim off the first \r\n from the buffer 

        while( counter < PMOut.Length())
        {
            DataCount  = 0;
            OldAddress = Address;
            sscanf(&DataPtr[counter],"%06X",&Address);
            counter += 6;
            Address &= 0xFFFFFF;
            if ( (Address & 0xFF0000) != (OldAddress & 0xFF0000) )
            {
                // Make the Header by taking correct address
                Checksum = (0x100 - (0x02+0x00+0x00+0x04+0x00+((Address&0xFF0000)/ 0x10000)&0xFF))&0xFF;
                stringBuf.cat_sprintf(":0200000400%02X%02X\r\n",((Address&0xFF0000)/ 0x10000)&0xFF,Checksum);
            }
            LineLength = counter+1;
            for (; DataPtr[LineLength] != '\n' && DataPtr[LineLength] != '\0'; LineLength++)
                    if (DataPtr[LineLength] == ' ') DataCount++;
            LineLength= DataCount;

            stringBuf.cat_sprintf(":%02X%04X00",LineLength,Address&0xFFFF);
            Checksum =  (LineLength&0xFF)+ ((Address >> 8 ) & 0xFF) +(Address & 0xFF)+ 0x00;

            for (int i = 0; i < LineLength; i ++)
            {
//                if (&DataPtr[counter] == 0)
//                    break;
                sscanf(&DataPtr[counter],"%02X",&Data);
                counter+=3;
                Checksum += (Data & 0xFF)  ;
                stringBuf.cat_sprintf("%02X",Data);
            }
            // Don't consider \r\n;
            counter+=3;
            Checksum =   (0x100 - Checksum) & 0xFF;
            stringBuf.cat_sprintf("%02X\r\n",Checksum);
        }
        //fprintf(fp,"%s",stringBuf.c_str());
     }


     DataCount = 0;
     if (!EEOut.IsEmpty()) {
        DataPtr = EEOut.c_str();
        counter = 2; // Trim off the first \r\n from the buffer
        while( counter < EEOut.Length())
        {
            DataCount  = 0;
            OldAddress = Address;
            sscanf(&DataPtr[counter],"%06X",&Address);
            Address += 0xF00000;
            counter += 6;
            Address &= 0xFFFFFF;
            if ( (Address & 0xFF0000) != (OldAddress & 0xFF0000) )
            {
                // Make the Header by taking correct address
                Checksum = (0x100 - (0x02+0x00+0x00+0x04+0x00+((Address&0xFF0000)/ 0x10000)&0xFF))&0xFF;
                stringBuf.cat_sprintf(":0200000400%02X%02X\r\n",((Address&0xFF0000)/ 0x10000)&0xFF,Checksum);
            }

            LineLength = counter+1;
            for (; DataPtr[LineLength] != '\n' && DataPtr[LineLength] != '\0'; LineLength++)
                    if (DataPtr[LineLength] == ' ') DataCount++;

            LineLength= DataCount;

            stringBuf.cat_sprintf(":%02X%04X00",LineLength,Address&0xFFFF);
            Checksum =  (LineLength&0xFF)+ ((Address >> 8 ) & 0xFF) +(Address & 0xFF)+ 0x00;

            for (int i = 0; i < LineLength; i ++)
            {
              //  if (&DataPtr[counter] == 0) break;
                sscanf(&DataPtr[counter],"%02X",&Data);
                counter+=3;
                Checksum += (Data & 0xFF)  ;
                stringBuf.cat_sprintf("%02X",Data);
            }
            // Don't consider \r\n;
            counter+=3;
            Checksum =   (0x100 - Checksum) & 0xFF;
            stringBuf.cat_sprintf("%02X\r\n",Checksum);
        }
     }


     DataCount  = 0;
     if (!CFGOut.IsEmpty()) {
        DataPtr = CFGOut.c_str();
        counter = 2; // Trim off the first \r\n from the buffer
        while( counter < CFGOut.Length())
        {
            DataCount  = 0;
            OldAddress = Address;
            sscanf(&DataPtr[counter],"%06X",&Address);
            counter += 6;
            Address &= 0xFFFFFF;
            if (Address == 0x3FFFFE || Address == 0x3FFFFF) {
                counter += 6;
                continue;
            }
            if ( (Address & 0xFF0000) != (OldAddress & 0xFF0000) )
            {
                // Make the Header by taking correct address
                Checksum = (0x100 - (0x02+0x00+0x00+0x04+0x00+((Address&0xFF0000)/ 0x10000)&0xFF))&0xFF;
                stringBuf.cat_sprintf(":0200000400%02X%02X\r\n",((Address&0xFF0000)/ 0x10000)&0xFF,Checksum);
            }

            LineLength = counter+1;
            for (; DataPtr[LineLength] != '\n' && DataPtr[LineLength] != '\0'; LineLength++)
                    if (DataPtr[LineLength] == ' ') DataCount++;

            LineLength= DataCount;

            stringBuf.cat_sprintf(":%02X%04X00",LineLength,Address&0xFFFF);
            Checksum =  (LineLength&0xFF)+ ((Address >> 8 ) & 0xFF) +(Address & 0xFF)+ 0x00;

            for (int i = 0; i < LineLength; i ++)
            {
           //     if (&DataPtr[counter] == '\0') break;
                sscanf(&DataPtr[counter],"%02X",&Data);
                counter+=3;
                Checksum += (Data & 0xFF)  ;
                stringBuf.cat_sprintf("%02X",Data);
            }
            // Don't consider \r\n;
            counter+=3;
            Checksum =   (0x100 - Checksum) & 0xFF;
            stringBuf.cat_sprintf("%02X\r\n",Checksum);
        }
     }

     DataCount  = 0;
     if (!UIDOut.IsEmpty()) {
        DataPtr = UIDOut.c_str();
        counter = 2; // Trim off the first \r\n from the buffer
        while( counter < UIDOut.Length())
        {
            DataCount  = 0;
            OldAddress = Address;
            sscanf(&DataPtr[counter],"%06X",&Address);
            counter += 6;
            Address &= 0xFFFFFF;
            if ( (Address & 0xFF0000) != (OldAddress & 0xFF0000) )
            {
                // Make the Header by taking correct address
                Checksum = (0x100 - (0x02+0x00+0x00+0x04+0x00+((Address&0xFF0000)/ 0x10000)&0xFF))&0xFF;
                stringBuf.cat_sprintf(":0200000400%02X%02X\r\n",((Address&0xFF0000)/ 0x10000)&0xFF,Checksum);
            }

            LineLength = counter+1;
            for (; DataPtr[LineLength] != '\n' && DataPtr[LineLength] != '\0'; LineLength++)
                    if (DataPtr[LineLength] == ' ') DataCount++;

            LineLength= DataCount;

            stringBuf.cat_sprintf(":%02X%04X00",LineLength,Address&0xFFFF);
            Checksum =  (LineLength&0xFF)+ ((Address >> 8 ) & 0xFF) +(Address & 0xFF)+ 0x00;

            for (int i = 0; i < LineLength; i ++)
            {
             //   if (&DataPtr[counter] == '\0') break;
                sscanf(&DataPtr[counter],"%02X",&Data);
                counter+=3;
                Checksum += (Data & 0xFF)  ;
                stringBuf.cat_sprintf("%02X",Data);
            }
            // Don't consider \r\n;
            counter+=3;
            Checksum =   (0x100 - Checksum) & 0xFF;
            stringBuf.cat_sprintf("%02X\r\n",Checksum);
        }
     }

     stringBuf.cat_sprintf(":00000001FF\r\n");

     TFileStream *fp = new TFileStream(FileName,fmCreate);
     fp->Write(stringBuf.c_str(),stringBuf.Length()  );
     delete fp;
}
/******************************************************************************
 * Function:        void HEXFileHandler::ClearAllMemoryBuff(void)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Resets all memory buffers.
 *
 * Note:            None
 *****************************************************************************/

void HEXFileHandler::ClearAllMemoryBuff(void)
{
    PMOut = "";
    EEOut = "";
    UIDOut = "";
    CFGOut = "";
}//end ClearAllMemoryBuff
