/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codeCommunication.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/


#ifndef codeCommunicationH
#define codeCommunicationH
/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>

#define picdemfs_boot       "vid_04d8&pid_000b"
#define picdemfs_demo       "vid_04d8&pid_000c"
#define bulk_out            "\\MCHP_EP1"
#define bulk_in             "\\MCHP_EP1"


#include "Driver\\_mpusbapi.h"

// The communication comrising of the following functions
// 1. SendPacket
// 2. GetPacket
// 3. OpenPIC
// 4. ClosePIC can be used for Demo Mode operation with COM Port
// Other functions are not required to be used.

#include "COMPortDriver\\PICBOOT.h"

/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------

/******************************************************************************
 * Class:    PICDEMOMODEFunctions
 *
 * Overview: The constructor of the class loads the PICBOOT.dll and sets the
 *           function pointers declared globally to PICBOOT.dll functions.
 *           The destructor will unload the library.
 *           A single global instance of this class will be created.
 * Note:
 *
 *****************************************************************************/

class PICDEMOMODEFunctions {
    HANDLE DEMOlibHandle;
public:
    PICDEMOMODEFunctions();
    ~PICDEMOMODEFunctions();
};

/******************************************************************************
 * Class:    CommunicationChannel
 *
 * Overview: Base class with pure virtual funtions. To be used
 *           as a base class for all kinds of communication classes.
 *
 * Note:
 * All functions in the following class need to be inherited.
 * The required data for a particular object is supplied by
 * it's "constructor". This means that whenever a new connection
 * is opened the old object need to be deleted. And new
 * object need to be created.
 * If needed the GET/SET functions need to be implemented.
 *
 *****************************************************************************/



class CommunicationChannel
{
    public:
       virtual int Open(int Mode=0)=0;
       virtual int Close()=0;
       virtual int SendData(char *Data, int Len)=0;
       virtual int SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay, UINT ReceiveDelay)=0;
       virtual int ReceiveData(char *Data, int Len)=0;
       virtual int CommunicationChannelType()=0;
};

/******************************************************************************
 * Class:    COMPort
 *
 * Overview: Derived from CommunicationChannel, and implements the required
 *           functionality to communicate over RS-232 port.
 *
 * Note: None
 *
 *****************************************************************************/


class COMPort: public CommunicationChannel
{
        static PICDEMOMODEFunctions globalPICDEMOMODEFunctions;
    public:
       virtual int Open(int Mode=0);
       virtual int Close();
       virtual int SendData(char *Data, int Len);
       virtual int ReceiveData(char *Data, int Len);
       virtual int CommunicationChannelType();
       virtual int SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay=500, UINT ReceiveDelay=1000);

};

/******************************************************************************
 * Class:    COMPort
 *
 * Overview: Derived from CommunicationChannel, and implements the required
 *           functionality to communicate with an USB device.
 *
 * Note: None
 *
 *****************************************************************************/

class USB: public CommunicationChannel
{

    static HANDLE myBulkOut,myBulkIn;
    int AssignedIndex;
    
    public:
       USB(int assignedIndex);
       ~USB();
       virtual int Open(int Mode=0);
       virtual int Close();
       virtual int SendData(char *Data, int Len);
       virtual int ReceiveData(char *Data, int Len);
       virtual int CommunicationChannelType();
       virtual int SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay=500, UINT ReceiveDelay=1000);
};
#endif
