/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codeCommunication.cpp
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/


#pragma hdrstop
/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------
#include "codeCommunication.h"

/** V A R I A B L E S ********************************************************/
//---------------------------------------------------------------------------
HANDLE (*OpenPIC)(LPSTR ComPort, DWORD BitRate, DWORD ReadTimeOut);
INT (*ClosePIC)(HANDLE hComPort);
INT (*GetPacket)(HANDLE hComPort, BYTE PacketData[], WORD ByteLimit);
INT (*SendPacket)(HANDLE hComPort, BYTE PacketData[], WORD NumOfBytes);
INT (*SendGetPacket)(HANDLE hComPort, BYTE PacketData[], WORD SendNumOfBytes, WORD RecvByteLimit, WORD NumOfRetrys);
INT (*ReadPIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);
INT (*WritePIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);
INT (*ErasePIC)(HANDLE hComPort, DWORD PICAddr, BYTE nBlock, BYTE nRetry);
INT (*VerifyPIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);

PICDEMOMODEFunctions COMPort::globalPICDEMOMODEFunctions;

HANDLE USB::myBulkOut = INVALID_HANDLE_VALUE;
HANDLE USB::myBulkIn = INVALID_HANDLE_VALUE;

/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------
/******************************************************************************
 * Function:        DOWRD ShowLastError(AnsiString str)
 *
 * PreCondition:    None
 *
 * Input:           A string that need to be used during formation
 *                  of the display message
 * Output:          A message box that shows windows error. 
 *
 * Side Effects:    After this function call the most recent
 *                  Windows OS error will be cleared
 * Overview:        This function displays the most recent Windows
 *                  error message prepending it with the given display
 *                  message.
 * Note:            None
 *****************************************************************************/
DWORD ShowLastError(AnsiString str)
{
    DWORD Error = GetLastError();
    LPVOID lpMsgBuf;

    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        Error,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
        (LPTSTR) &lpMsgBuf,0, NULL );
    str.cat_sprintf("\r\nFailed with error %d: %s",Error ,lpMsgBuf);
    MessageBox(NULL, str.c_str() , "Error", MB_OK|MB_SYSTEMMODAL);
    return Error;
}
/******************************************************************************
 * Function:        PICDEMOMODEFunctions::PICDEMOMODEFunctions()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    Loads the PICBOOT.DLL Library
 *
 * Overview:        Constructor for PICDEMOMODEFunctions class.
 *                  Initializes the function pointers for using
 *                  PICBOOT.dll.
 * Note:            None
 *****************************************************************************/
PICDEMOMODEFunctions::PICDEMOMODEFunctions()
{
        DEMOlibHandle = NULL;
        //DEMOlibHandle = LoadLibrary("COMPortDriver\\PICBOOT.dll");
        DEMOlibHandle = LoadLibrary("PICBOOT.dll");
        if(DEMOlibHandle == NULL)
            {
                    MessageBox(0,"Error loading PICBOOT.dll",0,0);
            }
        else
            {
                    OpenPIC = (HANDLE (*)(LPSTR , DWORD , DWORD ))\
                        GetProcAddress(DEMOlibHandle,"OpenPIC");
                    ClosePIC = (INT (*)(HANDLE ))\
                        GetProcAddress(DEMOlibHandle,"ClosePIC");
                    GetPacket = (INT (*)(HANDLE , BYTE [], WORD ))\
                        GetProcAddress(DEMOlibHandle,"GetPacket");
                    SendPacket = (INT (*)(HANDLE , BYTE [], WORD ))\
                        GetProcAddress(DEMOlibHandle,"SendPacket");
                    SendGetPacket = (INT (*)(HANDLE , BYTE [], WORD , WORD , WORD ))\
                        GetProcAddress(DEMOlibHandle,"SendGetPacket");
            }
        if((OpenPIC == NULL) || (ClosePIC == NULL) ||
           (GetPacket == NULL) || (SendPacket == NULL) ||
           (SendGetPacket == NULL))
            MessageBox(0,"GetProcAddress Error for PICBOOT.dll",0,0);
}

/******************************************************************************
 * Function:        PICDEMOMODEFunctions::~PICDEMOMODEFunctions()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Destructor for PICDEMOMODEFunctions class.
 *
 *
 * Note:            None
 *****************************************************************************/

PICDEMOMODEFunctions::~PICDEMOMODEFunctions()
{
        if (DEMOlibHandle) FreeLibrary(DEMOlibHandle);
}


/******************************************************************************
 * Function:        COMPort::Open(int Mode)
 *
 * PreCondition:    None
 *
 * Input:           Mode of operation 0 - BOOT, 1 - DEMO
 *
 * Output:          Error Code
 *
 * Side Effects:    None
 *
 * Overview:        Opens the RS-232 port for specific type of operation
 *
 *
 * Note:            None
 *****************************************************************************/

int COMPort::Open(int Mode)
{
}
/******************************************************************************
 * Function:        int COMPort::Close()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Error Code
 *
 * Side Effects:    None
 *
 * Overview:        Closes the RS-232 port
 *
 *
 * Note:            None
 *****************************************************************************/

int COMPort::Close()
{
}
/******************************************************************************
 * Function:        int COMPort::SendData(char *Data, int Len)
 *
 * PreCondition:    Open the RS-232 port using COMPort::Open.
 *
 * Input:           Data - Array of bytes
 *                  Len - Length of the the array
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Sends the Data of given length Len, over RS-232 port.
 *
 *
 * Note:            None
 *****************************************************************************/
int COMPort::SendData(char *Data, int Len)
{
}
/******************************************************************************
 * Function:        int COMPort::ReceiveData(char *Data, int Len)
 *
 * PreCondition:    Open the RS-232 port using COMPort::Open.
 *
 * Input:           Data - Array of bytes
 *                  Len - Length of the the array
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Receives Len bytes of data over RS-232 port and stores
 *                  it in the array Data 
 *
 * Note:            None
 *****************************************************************************/
int COMPort::ReceiveData(char *Data, int Len)
{
}
/******************************************************************************
 * Function:        int COMPort::SendReceivePacket(BYTE *SendData, DWORD SendLength,
 *                   BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay,
 *                   UINT ReceiveDelay)
 *
 * PreCondition:    Open the RS-232 port using COMPort::Open.
 *
 * Input:           SendData - Array of bytes to be sent over RS-232 port
 *                  SendLength - Send data Length
 *                  ReceiveData - Array of Bytes to be received.
 *                  ReceiveLength - Pointer intialized to Expected Length.
 *                                  After receiving the data it stores the received
 *                                  data length.
 *                  SendDelay - Delay used during Sending the data
 *                  ReceiveDelay - Delay used during receiving the data
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        This function sends data and receives data inresponse to the
 *                  data sent.
 *
 * Note:            None
 *****************************************************************************/
int COMPort::SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay, UINT ReceiveDelay)
{

}
/******************************************************************************
 * Function:        int COMPort::CommunicationChannelType()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Returns type of communication channel
 *
 *
 * Note:            None
 *****************************************************************************/

int COMPort::CommunicationChannelType()
{
    return 1;  // COM Port
}


/******************************************************************************
 * Function:        USB::USB(int assignedIndex)
 *
 * PreCondition:    None
 *
 * Input:           assignedIndex maintains the number of the board.
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Constructor for USB class
 *
 *
 * Note:            None
 *****************************************************************************/

USB::USB(int assignedIndex):AssignedIndex(assignedIndex)
{
    myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;
}
/******************************************************************************
 * Function:        USB::~USB(int assignedIndex)
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Destructor for USB class. Closes the USB Ports if they
 *					are open.
 *
 * Note:            None
 *****************************************************************************/
USB::~USB()
{
    if (myBulkOut != INVALID_HANDLE_VALUE) MPUSBClose(myBulkOut);
    if (myBulkIn != INVALID_HANDLE_VALUE) MPUSBClose(myBulkIn);
    myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;
}
/******************************************************************************
 * Function:        int USB::Open(int Mode)
 *
 * PreCondition:    None
 *
 * Input:           Mode of operation 0 - BOOT, 1 - DEMO
 *
 * Output:          Error Code
 *
 * Side Effects:    None
 *
 * Overview:        Opens the USB device identifies picdemfs_boot or picdemfs_demo
 *
 *
 * Note:            None
 *****************************************************************************/
int USB::Open(int Mode)
{
    if (myBulkOut != INVALID_HANDLE_VALUE)
        MPUSBClose(myBulkOut);
    if (myBulkIn != INVALID_HANDLE_VALUE)
        MPUSBClose(myBulkIn);
    myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;

    if (Mode == 0) // BOOT
    {
        myBulkOut = MPUSBOpen(AssignedIndex,picdemfs_boot,bulk_out,MP_WRITE,0);
        myBulkIn = MPUSBOpen(AssignedIndex,picdemfs_boot,bulk_in,MP_READ,0);
    }
    else
    {
        myBulkOut = MPUSBOpen(AssignedIndex,picdemfs_demo,bulk_out,MP_WRITE,0);
        myBulkIn = MPUSBOpen(AssignedIndex,picdemfs_demo,bulk_in,MP_READ,0);

    }
    if((myBulkOut == INVALID_HANDLE_VALUE) || (myBulkIn == INVALID_HANDLE_VALUE))
        {            
            return 1;
        }
   return 0;
}
/******************************************************************************
 * Function:        int USB::Close()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          Error Code
 *
 * Side Effects:    None
 *
 * Overview:        Closes the USB Device
 *
 *
 * Note:            None
 *****************************************************************************/
int USB::Close()
{
    if (myBulkOut != INVALID_HANDLE_VALUE) MPUSBClose(myBulkOut);
    if (myBulkIn != INVALID_HANDLE_VALUE) MPUSBClose(myBulkIn);
    myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;
    return 0;
}
/******************************************************************************
 * Function:        int USB::SendData(char *Data, int Len)
 *
 * PreCondition:    Open the USB Device using USB::Open.
 *
 * Input:           Data - Array of bytes
 *                  Len - Length of the the array
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Sends the Data of given length Len, over USB.
 *
 *
 * Note:            None
 *****************************************************************************/
int USB::SendData(char *Data, int Len)
{
}
/******************************************************************************
 * Function:        int USB::ReceiveData(char *Data, int Len)
 *
 * PreCondition:    Open the USB Device using USB::Open.
 *
 * Input:           Data - Array of bytes
 *                  Len - Length of the the array
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Receives Len bytes of data over US and stores
 *                  it in the array Data 
 *
 * Note:            None
 *****************************************************************************/
int USB::ReceiveData(char *Data, int Len)
{
}
/******************************************************************************
 * Function:        int USB::SendReceivePacket(BYTE *SendData, DWORD SendLength,
 *                   BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay,
 *                   UINT ReceiveDelay)
 *
 * PreCondition:    Open the USB device using COMPort::Open.
 *
 * Input:           SendData - Array of bytes to be sent to USB device.
 *                  SendLength - Send data Length
 *                  ReceiveData - Array of Bytes to be received.
 *                  ReceiveLength - Pointer intialized to Expected Length.
 *                                  After receiving the data it stores the received
 *                                  data length.
 *                  SendDelay - Delay used during Sending the data
 *                  ReceiveDelay - Delay used during receiving the data
 *
 * Output:          Error code.
 *
 * Side Effects:    None
 *
 * Overview:        This function sends data and receives data inresponse to the
 *                  data sent.
 *
 * Note:            None
 *****************************************************************************/
int USB::SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength, UINT SendDelay, UINT ReceiveDelay)
{
    DWORD SentDataLength;
    DWORD ExpectedReceiveLength = *ReceiveLength;

    if(myBulkOut != INVALID_HANDLE_VALUE && myBulkIn != INVALID_HANDLE_VALUE)
    {
        if(MPUSBWrite(myBulkOut,SendData,SendLength,&SentDataLength,SendDelay))
        {

            if(MPUSBRead(myBulkIn,ReceiveData, ExpectedReceiveLength, ReceiveLength,ReceiveDelay))
            {
                if(*ReceiveLength == ExpectedReceiveLength)
                {
                    return 1;
                }
                else if(*ReceiveLength < ExpectedReceiveLength)
                {
                    return 2;
                }
            }
            else
            {
                if(ShowLastError("USB Read Failed.") == ERROR_INVALID_HANDLE)
                {
                    if (myBulkOut != INVALID_HANDLE_VALUE)
                        MPUSBClose(myBulkOut);
                    if (myBulkIn != INVALID_HANDLE_VALUE)
                        MPUSBClose(myBulkIn);
                    myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;
                }
            }
        }
        else
        {
            if(ShowLastError("USB Write Failed.") == ERROR_INVALID_HANDLE)
            {
              if (myBulkOut != INVALID_HANDLE_VALUE)
                MPUSBClose(myBulkOut);
              if (myBulkIn != INVALID_HANDLE_VALUE)
                MPUSBClose(myBulkIn);
              myBulkOut = myBulkIn = INVALID_HANDLE_VALUE;
            }
        }
    }

    return 0;
}
/******************************************************************************
 * Function:        int USB::CommunicationChannelType()
 *
 * PreCondition:    None
 *
 * Input:           None
 *
 * Output:          None
 *
 * Side Effects:    None
 *
 * Overview:        Returns type of communication channel
 *
 *
 * Note:            None
 *****************************************************************************/
int USB::CommunicationChannelType()
{
    return 0; // USB
}
//---------------------------------------------------------------------------

#pragma package(smart_init)

