
/******************************************************************************\
*	PIC16/18 Bootloader Communications Handler (header file)
*	by Ross M. Fosler
*	Microchip Technology Incorporated
*
*	Regenerated to use with Borland C++ Builder
*   by Ravi Kumar M.
\******************************************************************************/
#ifndef _PICBOOT
#define _PICBOOT

//Packet control characters
#define STX		15
#define ETX		4
#define DLE		5

//Error conditions
#define ERROR_GEN_READWRITE		-1
#define	ERROR_READ_TIMEOUT		-2
#define ERROR_READ_LIMIT		-3
#define	ERROR_BAD_CHKSUM		-4
#define	ERROR_RETRY_LIMIT		-5
#define ERROR_INVALID_COMMAND	-6
#define ERROR_BLOCK_TOO_SMALL	-7
#define ERROR_PACKET_TOO_BIG	-8
#define ERROR_OFF_BOUNDRY		-9
#define ERROR_BPA_TOO_SMALL		-10
#define ERROR_BPA_TOO_BIG		-11	
#define ERROR_VERIFY_FAILED		-12

//Limits
#define MAX_PACKET			256

//Bootloader commands
#define COMMAND_READVER		0
#define COMMAND_READPM		1
#define COMMAND_WRITEPM		2
#define COMMAND_ERASEPM		3
#define COMMAND_READEE		4
#define COMMAND_WRITEEE		5
#define COMMAND_READCFG		6
#define COMMAND_WRITECFG	7


//PIC structure used for some functions
typedef struct _PIC {
	BYTE BootCmd;
	BYTE BootDatLen;		//Number of bytes to read/write
	DWORD BootAddr;			//24 bit memory address (Prog or EE)
	BYTE BytesPerBlock;
	BYTE BytesPerAddr;
	WORD MaxRetrys;			//Number of retries before failure
}PIC;


//Prototypes
extern HANDLE (*OpenPIC)(LPSTR ComPort, DWORD BitRate, DWORD ReadTimeOut);
extern INT (*ClosePIC)(HANDLE hComPort);
extern INT (*GetPacket)(HANDLE hComPort, BYTE PacketData[], WORD ByteLimit);
extern INT (*SendPacket)(HANDLE hComPort, BYTE PacketData[], WORD NumOfBytes);
extern INT (*SendGetPacket)(HANDLE hComPort, BYTE PacketData[], WORD SendNumOfBytes, WORD RecvByteLimit, WORD NumOfRetrys);
extern INT (*ReadPIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);
extern INT (*WritePIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);
extern INT (*ErasePIC)(HANDLE hComPort, DWORD PICAddr, BYTE nBlock, BYTE nRetry);
extern INT (*VerifyPIC)(HANDLE hComPort, PIC *pic, BYTE PacketData[]);


#endif
