/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codefrmPICDEMUSBFSDemoTool.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/


#ifndef codefrmPICDEMUSBFSDemoToolH
#define codefrmPICDEMUSBFSDemoToolH

/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <TabNotBk.hpp>
#include <Menus.hpp>
#include "PERFGRAP.h"
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <ImgList.hpp>
#include <Dialogs.hpp>
#include "VrBitmapDial.hpp"
#include "VrControls.hpp"
#include "VrAngularMeter.hpp"
#include "VrLabel.hpp"
#include "VrLeds.hpp"
#include "VrSwitch.hpp"
#include "VrCheckLed.hpp"
#include "VrScope.hpp"
#include "codeHEXFileHandler.h"
#include "codeDeviceManager.h"
#include <Graphics.hpp>

/* For ChangeAbortStatus function */
#define SAVE_CONTEXT    1
#define RESTORE_CONTEXT 0


/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------
/******************************************************************************
 * Class:    TWMDeviceChange
 *
 * Overview: Used by OnDeviceChange message handler
 *
 *
 * Note: None
 *
 *****************************************************************************/

struct TWMDeviceChange
{
    UINT Msg;
    UINT wParam;
    DWORD lParam;
    long Result;
};

/******************************************************************************
 * Class:    TfrmFullSpeedUSBDemoTool
 *
 * Overview: Implement the main form behaviour of the application.
 *           It is responsible for communication among various objects
 *           in this application.
 *
 * Note: None
 *
 *****************************************************************************/

class TfrmFullSpeedUSBDemoTool : public TForm
{
__published:	// IDE-managed Components
        TTabbedNotebook *TabbedNotebook;
        TStatusBar *StatusBar;
        TGroupBox *GroupBox1;
        TLabel *Label4;
        TLabel *lblTemp0;
        TLabel *lblTemp1;
        TLabel *lblTemp2;
        TLabel *lblTemp3;
        TLabel *lblTemp5;
        TLabel *lblTemp4;
        TLabel *lblTemp6;
        TLabel *lblTemp7;
        TLabel *lblTemp8;
        TLabel *lblTemp9;
        TLabel *lblTemp10;
        TGroupBox *GroupBox2;
    TRadioButton *rbRealTime;
    TRadioButton *rbDataLogging;
        TButton *cmdAcquireData;
        TGroupBox *GroupBox3;
        TLabel *Label1;
    TEdit *edtPOT;
        TGroupBox *GroupBox4;
        TLabel *Label2;
        TButton *cmdConnect;
        TImageList *ImageList1;
        TOpenDialog *OD1;
        TSaveDialog *SD1;
    TEdit *edtTemperature;
        TLabel *Label3;
        TPanel *Panel1;
        TVrAngularMeter *POTAngMeter;
    TVrCheckLed *VrLED3;
    TVrCheckLed *VrLED4;
        TGroupBox *GroupBox5;
    TComboBox *cmbBOOTList;
    TBitBtn *cmdProgramDevice;
    TBitBtn *cmdReadDevice;
    TBitBtn *cmdEraseDevice;
    TBitBtn *cmdExecute;
    TBitBtn *cmdAbortOperation;
    TVrScope *TempScope;
    TComboBox *cmbDEMOCommunicationChannel;
    TButton *cmdClearScreen;
    TBitBtn *cmdLoadHEX;
    TBitBtn *cmdSaveToHEX;
    TTimer *demoModeTimer;
    TLabel *Label5;
    TComboBox *cmbBaudRate;
    TPanel *Panel2;
    TLabel *Label6;
    TGroupBox *GroupBox6;
    TLabel *Label7;
    TImage *Image1;
        TRichEdit *txtMessage;
        void __fastcall Exit1Click(TObject *Sender);
        void __fastcall rbDataLoggingClick(TObject *Sender);
        void __fastcall rbRealTimeClick(TObject *Sender);
        void __fastcall cmdConnectClick(TObject *Sender);
        void __fastcall cmdLoadHEXClick(TObject *Sender);
        void __fastcall cmdSaveToHEXClick(TObject *Sender);
        void __fastcall cmbDEMOCommunicationChannelSelect(TObject *Sender);
        void __fastcall TabbedNotebookChange(TObject *Sender, int NewTab,
          bool &AllowChange);
        void __fastcall cmdClearScreenClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall cmbBOOTListSelect(TObject *Sender);
    void __fastcall cmdReadDeviceClick(TObject *Sender);
    void __fastcall cmdEraseDeviceClick(TObject *Sender);
    void __fastcall cmdProgramDeviceClick(TObject *Sender);
    void __fastcall cmdExecuteClick(TObject *Sender);
    void __fastcall demoModeTimerTimer(TObject *Sender);
    void __fastcall cmdAcquireDataClick(TObject *Sender);
    void __fastcall cmdIdentifyBoardsClick(TObject *Sender);
    void __fastcall cmdAbortOperationClick(TObject *Sender);
    void __fastcall Image1Click(TObject *Sender);
    void __fastcall cmbBOOTListDropDown(TObject *Sender);
    void __fastcall cmbDEMOCommunicationChannelDropDown(TObject *Sender);
    void __fastcall FormResize(TObject *Sender);

private:	// User declarations
        HEXFileHandler hex;
        bool Busy;
        DeviceManager  deviceManager;

        void DisableBootInterface();
        void EnableBootInterface();
        void DisableDemoInterface();
        void EnableDemoInterface();
        BOOL IsHexEmpty();
        void ChangeAbortStatus(int update);

        void ResetDemoMode();
        void ResetBootMode();
        void CheckConfiguration(AnsiString& Config);
        void ShowWarning(AnsiString WarningText);
        void ShowMessage(AnsiString WarningText);
        void ShowStatusMessage(AnsiString Message);
        void FormatMemoryDump(AnsiString &FormatBuffer, DWORD StartAddress, BYTE *ByteBuffer, DWORD Length);
        void FormatConfigMemoryDump(AnsiString &FormatBuffer, DWORD StartAddress, BYTE *ByteBuffer);
        AnsiString ProcessTemperature(UINT Temp);
        void ProcessPOT(UINT POT);
        void ShowHexContent();

        void __fastcall OnDeviceChange(TWMDeviceChange& Message);
        
public:		// User declarations
        __fastcall TfrmFullSpeedUSBDemoTool(TComponent* Owner);

BEGIN_MESSAGE_MAP
    MESSAGE_HANDLER(WM_DEVICECHANGE, TWMDeviceChange, OnDeviceChange)
END_MESSAGE_MAP(TForm)
};
//---------------------------------------------------------------------------
extern PACKAGE TfrmFullSpeedUSBDemoTool *frmFullSpeedUSBDemoTool;
//---------------------------------------------------------------------------
#endif
