//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "codefrmConfigurationBits.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfrmConfigurationBits *frmConfigurationBits;

tagConfigOptions ConfigOptions[] = {
        {0,1,"<Can not be Modified>\n"},
        {1,2,"Enabled\nDisabled\n"},
        {2,3,"clk src from 96MHz PLL/2\nclk src from OSC1/OSC2\n"},

};

/*
        int Index;
        unsigned long Address;
        AnsiString CategoryName;
        unsigned BitMask;
        unsigned Value;
        int OptionsMenuIndex;
*/
const int ConfigurationBitsDataCount  = 38;
tagConfigurationBitsData ConfigurationBitsData[38] = {
        tagConfigurationBitsData(0 ,0x300000,"USB Clock Selection",0x00,0x00,0x2),
        tagConfigurationBitsData(1 ,0x300000,"CPU Sys CLK Select",0x00,0x00,0x01),
        tagConfigurationBitsData(2 ,0x300000,"OSC Select",0x00,0x00,0x01),

        tagConfigurationBitsData(3 ,0x300001,"Oscillator",0x00,0x00,0x01),
        tagConfigurationBitsData(4 ,0x300001,"Fail-Safe Clock Monitor Enable",0x00,0x00,0x01),
        tagConfigurationBitsData(5 ,0x300001,"Internal External Switch Over Mode",0x00,0x00,0x01),

        tagConfigurationBitsData(6 ,0x300002,"USB Voltage Regulator",0x00,0x00,0x01),
        tagConfigurationBitsData(7 ,0x300002,"Power Up Timer",0x00,0x00,0x00),
        tagConfigurationBitsData(8 ,0x300002,"Brown Out Detect",0x00,0x00,0x00),
        tagConfigurationBitsData(9 ,0x300002,"Brown Out Voltage",0x00,0x00,0x00),

        tagConfigurationBitsData(10,0x300003,"Watchdog Timer",0x00,0x00,0x00),
        tagConfigurationBitsData(11,0x300003,"Watchdog Postscaler",0x00,0x00,0x00),

        tagConfigurationBitsData(12,0x300005,"CCP2 Mux",0x00,0x00,0x00),
        tagConfigurationBitsData(13,0x300005,"PortB A/D Enable",0x00,0x00,0x00),
        tagConfigurationBitsData(14,0x300005,"Low Power Timer1 Osc enable",0x00,0x00,0x00),
        tagConfigurationBitsData(15,0x300005,"Master Clear Enable",0x00,0x00,0x00),

        tagConfigurationBitsData(16,0x300006,"Stack Overflow Reset",0x00,0x00,0x00),
        tagConfigurationBitsData(17,0x300006,"Low Voltage Program",0x00,0x00,0x00),
        tagConfigurationBitsData(18,0x300006,"Dedicated In-Circuit Port {ICD/ICSP}",0x00,0x00,0x00),
        tagConfigurationBitsData(19,0x300006,"Entended CPU Enable",0x00,0x00,0x00),

        tagConfigurationBitsData(20,0x300008,"Code Protect 00800-01FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(21,0x300008,"Code Protect 02000-03FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(22,0x300008,"Code Protect 04000-05FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(23,0x300008,"Code Protect 06000-07FFF",0x00,0x00,0x00),

        tagConfigurationBitsData(24,0x300009,"Data EE Read Protect",0x00,0x00,0x00),
        tagConfigurationBitsData(25,0x300009,"Code Protect Boot",0x00,0x00,0x00),

        tagConfigurationBitsData(26,0x30000A,"Table Write Protect 00800-01FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(27,0x30000A,"Table Write Protect 02000-03FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(28,0x30000A,"Table Write Protect 04000-05FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(29,0x30000A,"Table Write Protect 06000-07FFF",0x00,0x00,0x00),

        tagConfigurationBitsData(30,0x30000B,"Data EE Write Protect",0x00,0x00,0x00),
        tagConfigurationBitsData(31,0x30000B,"Table Write Protect Boot",0x00,0x00,0x00),
        tagConfigurationBitsData(32,0x30000B,"Config. Write Protect",0x00,0x00,0x00),

        tagConfigurationBitsData(33,0x30000C,"Table Read Protect 00800-01FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(34,0x30000C,"Table Read Protect 02000-03FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(35,0x30000C,"Table Read Protect 04000-05FFF",0x00,0x00,0x00),
        tagConfigurationBitsData(36,0x30000C,"Table Read Protect 06000-07FFF",0x00,0x00,0x00),

        tagConfigurationBitsData(37,0x30000C,"Table Read Protect Boot",0x00,0x00,0x00)

};



//---------------------------------------------------------------------------
__fastcall TfrmConfigurationBits::TfrmConfigurationBits(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TfrmConfigurationBits::ResizeListBox(int ARow)
{
        TRect r = DG->CellRect(3,ARow);
        cmbOptions->Height = 0;
        cmbOptions->Width = 0;
        cmbOptions->Top = DG->Top + r.top+1;
        cmbOptions->Left = DG->Left + r.left+1 ;
        cmbOptions->Height = r.Height()-1  ;
        cmbOptions->Width  = r.Width()-1 ;
        cmbOptions->Clear();
        tagConfigOptions CO;
        cmbOptions->Items->SetText(ConfigOptions[ConfigurationBitsData[ARow].OptionsMenuIndex].Text);
        cmbOptions->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfigurationBits::HCSectionResize(
      THeaderControl *HeaderControl, THeaderSection *Section)
{
        DG->ColWidths[Section->Index] = Section->Width;
        ResizeListBox(DG->Row);
}
//---------------------------------------------------------------------------
void __fastcall TfrmConfigurationBits::FormCreate(TObject *Sender)
{
/*        Panels[0] = Panel1;
        Panels[1] = Panel2;
        Panels[2] = Panel3;
        Panels[3] = Panel4;
*/

        // Initialize the grid with data
        unsigned long PrevAddress = -1;
        HandlingKeyPress = false;
        DG->RowCount = ConfigurationBitsDataCount;
        for (int i = 0; i <  ConfigurationBitsDataCount; i++)
        {
               DG->Cells[2][ConfigurationBitsData[i].Index] = ConfigurationBitsData[i].CategoryName;
               if (PrevAddress != ConfigurationBitsData[i].Address)
               {
                       DG->Cells[0][ConfigurationBitsData[i].Index] = IntToHex(__int64(ConfigurationBitsData[i].Address),6);
               }
               PrevAddress = ConfigurationBitsData[i].Address;
        }

}
//---------------------------------------------------------------------------
void __fastcall TfrmConfigurationBits::FormResize(TObject *Sender)
{
        int tWidth = 0;
        if (HandlingKeyPress) return;
        for (int i = 0; i < 4; i++)
        {
                if (i== 3) {
                        HC->Sections->Items[i]->Width = HC->Width - tWidth;
                }
                DG->ColWidths[i] = HC->Sections->Items[i]->Width;
                tWidth += DG->ColWidths[i];
        }
        ResizeListBox(DG->Row);

}
//---------------------------------------------------------------------------


void __fastcall TfrmConfigurationBits::DGSelectCell(TObject *Sender,
      int ACol, int ARow, bool &CanSelect)
{
        ResizeListBox(ARow);
}
//---------------------------------------------------------------------------





void __fastcall TfrmConfigurationBits::cmbOptionsKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
        DG->SetFocus();
        /*
        HandlingKeyPress = true;
        if (Key == VK_DOWN && DG->Row < DG->RowCount-1 )
                DG->Row++;
        else if (Key == VK_UP && DG->Row > 0 )
        {
            if (DG->TopRow == DG->Row){
                DG->TopRow--;
                DG->Row = DG->TopRow;
            }
            else {
                DG->Row--;

            }

        }
        if (Key == VK_PRIOR)
        {

                if (DG->Row-5 > 0) {
                        if (DG->TopRow <= DG->Row && DG->TopRow >= DG->Row-5){
                                DG->TopRow-=5;
                                DG->Row = DG->TopRow;
                            }
                        else DG->Row-=5;
                }
                else {DG->TopRow= 0;DG->Row = DG->TopRow;}
        }
        else if (Key == VK_NEXT) {
                 if (DG->Row+5 < DG->RowCount-1) {
                        if ((DG->TopRow+DG->VisibleRowCount) >= DG->Row && (DG->TopRow+DG->VisibleRowCount) <= DG->Row+5){
                                DG->TopRow+=5;
                                DG->Row = (DG->TopRow+DG->VisibleRowCount-1);
                            }
                        else DG->Row+=5;
                }
                else {DG->TopRow = (DG->RowCount-1)- DG->VisibleRowCount; DG->Row = DG->TopRow+DG->VisibleRowCount;}
        }
        HandlingKeyPress = false;
      */
}
//---------------------------------------------------------------------------


void __fastcall TfrmConfigurationBits::DGKeyDown(TObject *Sender,
      WORD &Key, TShiftState Shift)
{
        Key = Key;        
}
//---------------------------------------------------------------------------


