/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codeHEXFileHandler.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/



#ifndef codeHEXFileHandlerH
#define codeHEXFileHandlerH

/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------


#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <stdio.h>

/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------
/******************************************************************************
 * Class:    HEXFileHandler
 *
 * Overview: Implements the required functionalty to load and save Intel HEX
 *           files into application buffers.
 *
 * Note: None
 *
 *****************************************************************************/
class HEXFileHandler
{

//    AnsiString FileName;
    AnsiString PMOut,EEOut,UIDOut,CFGOut;
    TStringList *Errors;

public:
    int ImportP18HEXFile(AnsiString FileName);
    int ValidateHEXFile(AnsiString FileName);
    int ImportP16HEXFile(AnsiString FileName);
    int ExportP18HEXFile(AnsiString FileName);

    AnsiString& GetProgramMemory(){return PMOut;}
    AnsiString& GetEEMemory(){return EEOut;}
    AnsiString& GetUID(){return UIDOut;}
    AnsiString& GetConfig(){return CFGOut;}
    void ClearAllMemoryBuff(void);
};


#endif
