/*********************************************************************
 *
 *                Microchip Full Speed USB Demo Tool Version 1.0
 *
 *********************************************************************
 * FileName:        codeDeviceManager.h
 * Dependencies:    See INCLUDES section below
 * Processor:       PIC18
 * Compiler:        Borland C++ Builder 6.0
 * Company:         Microchip Technology, Inc.
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the Company) for its PICmicro Microcontroller is intended and
 * supplied to you, the Companys customer, for use solely and
 * exclusively on Microchip PICmicro Microcontroller products. The
 * software is owned by the Company and/or its supplier, and is
 * protected under applicable copyright laws. All rights are reserved.
 * Any use in violation of the foregoing restrictions may subject the
 * user to criminal sanctions under applicable laws, as well as to
 * civil liability for the breach of the terms and conditions of this
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN AS IS CONDITION. NO WARRANTIES,
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ravi Kumar M        11/04/04     Original.
 ********************************************************************/



#ifndef codeDeviceManagerH
#define codeDeviceManagerH
/* I N C L U D E S **********************************************************/
//---------------------------------------------------------------------------


#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <vcl.h>
#include <stdio.h>

#include "codeCommunication.h"

/** D E C L A R A T I O N S **************************************************/
//---------------------------------------------------------------------------

#define READ_VERSION        0x00
#define READ_FLASH          0x01
#define WRITE_FLASH         0x02
#define ERASE_FLASH         0x03
#define READ_EEDATA         0x04
#define WRITE_EEDATA        0x05
#define READ_CONFIG         0x06
#define WRITE_CONFIG        0x07

#define ID_BOARD            0x31
#define UPDATE_LED          0x32
#define SET_TEMP_REAL       0x33
#define RD_TEMP             0x34
#define SET_TEMP_LOGGING    0x35
#define RD_TEMP_LOGGING     0x36
#define RD_POT              0x37

#define RESET               0xFF



/******************************************************************************
 * Class:    Device
 *
 * Overview: Implements the behaviour of a device with which this application
 *           communicates. I will have an object of CommunicationChannel and
 *           provides functionality to send and receive data over that
 *           CommunicationChannel.
 *
 * Note: None
 *
 *****************************************************************************/
class Device: public TObject
{
    static int UsedDevIDs[4];
    int CurrentModeOfOperation; // 0-Boot, 1- Demo
    CommunicationChannel *Channel; // if CurrentModeOfOperation = DEMO MODE, then
                                   // defaults to USB Object
    char *ByteBuffer;
    int BufferSize;
    int AssignedIndex;
    bool Disabled;

public:
    int DemoDevID; // Used in Demo Mode to identify the device
                   // Device identification can be {00b,01b,02b,03b}
    
    AnsiString DeviceName;
    Device(AnsiString deviceName, int Mode,int assignedIndex, int communicationChannelType);
    int OpenDevice();
    int CloseDevice();
    int SendData(void *Bytes, int Length);
    int ReceiveData(void *Bytes, int &Length);
    int SendReceivePacket(BYTE *SendData, DWORD SendLength, BYTE *ReceiveData, DWORD *ReceiveLength,UINT SendDelay=500, UINT ReceiveDelay=1000);
    int GetModeOfOperation();
    inline bool IsDisabled(){return Disabled;}  
    virtual __fastcall ~Device();

};

/******************************************************************************
 * Class:    DeviceManager
 *
 * Overview: This class implements the functionality to manages all the connected
 *           boards. It also implements the functionality required to communicate
 *           with boards and the Bootload protocol.
 *
 * Note: None
 *
 *****************************************************************************/
class DeviceManager
{
        TObjectList *DeviceList;
        Device *CurrentDevice;
        bool IsOpen;
    public:
        DeviceManager();
        ~DeviceManager();
        int ActiveMode; /* Boot, Demo */
        bool AbortOperation;
        void StartExecution();
        void StopExecution();
        int SelectDevice(AnsiString deviceName);
        int OpenDevice();
        int CloseDevice();
        void Refresh();
        AnsiString GetDeviceList();

        // Commands To Be handled- All commands are available
        // to both modes.

        int ResetBoard();  // 0xFF
        // Boot Mode
        AnsiString ReadVersion(); // 0x00
        int ReadFLASH(UINT Len, UINT Addr, BYTE *Data); // 0x01
        int WriteFLASH(AnsiString& MemoryBuffer); // 0x02
        int WriteUID(AnsiString& MemoryBuffer);
        int EraseFLASH(UINT Len, UINT Addr); // 0x03

        int ReadEEDATA(UINT Len, UINT Addr, UCHAR *Data); // 0x04
        int WriteEEDATA(AnsiString& MemoryBuffer); // 0x05

        int ReadCONFIG(UINT Addr, UCHAR *Data); // 0x06
        int WriteCONFIG(AnsiString& MemoryBuffer); // 0x07

        //Demo Mode
        int SetBoardID(UINT ID); // 0x31
        int UpdateLED(UINT led, int State); //0x32
        int SetTempRealMode(); // 0x33
        int ReadTemperature(UINT &Temperature); // 0x34
        int SetTempLogging(); // 0x35
        int ReadTempLogging(char *Data, int *Length); //0x36
        int ReadPot(UINT &POTValue); //0x37

        // Get Board Details
        AnsiString GetCurrentDeviceUSBDetails();

        void ToggleLEDD4();

        void IdentifyBoards();
        void IdentifyCurrentDevice();
};
//---------------------------------------------------------------------------
#endif
