'*****************************************************************************
'Tracteur.bas Enregistreur/Afficheur p/ Tracteur Honda
'
'Le 09/08/2007
'
'*****************************************************************************
'*****************************************************************************
'
'PIC 16F452 @ 4Mhz + Horloge EXT 32 768 Hz sur TMR1 ( interruptions @ 1Hz )
'Compte-Tours avec Capture sur TMR3 avec Horloge systme.
'
'Afficheur LCD 2*16 sur PORTD
'
' 2835 Lignes
'
'*****************************************************************************
'*****************************************************************************
'
'Defines
'*****************************************************************************

DEFINE OSC 4
'DEFINE BUTTON_PAUSE 50 
DEFINE ADC_BITS 8

'DEFINE USE_LOWPRIORITY 1

' Define LCD connections

DEFINE LCD_DREG PORTD   	' Set LCD Data port
DEFINE LCD_DBIT 4       	' Set starting Data bit (0 or 4) if 4-bit bus
DEFINE LCD_RSREG PORTD  	' Set LCD Register Select port
DEFINE LCD_RSBIT 2      	' Set LCD Register Select bit
DEFINE LCD_EREG PORTD   	' Set LCD Enable port
DEFINE LCD_EBIT 3      		' Set LCD Enable bit
DEFINE LCD_BITS 4       	' Set LCD bus size (4 or 8 bits)

'
'
ExtOSC 		con 32768

Tension_ 	con 0
TempA_		con 1
TempH_		con 2
PressH_		con 4
Dureetonte	con 3
OffsetP		con 0
ScaleP		con 1

SecondsChanged 	var bit
Hours			con 8888
Minutes			con 88

DATA (0),0 (10) 'Raz des Mmoires

'*****************************************************************************
'*****************************************************************************
'Config processeur
'*****************************************************************************
'
'@  __CONFIG    _CONFIG1L, _WDT_OFF_1L & _WDTPS_128_1L
@   __CONFIG    _CONFIG1H, _OSCS_OFF_1H & _XT_OSC_1H
@	__CONFIG	_CONFIG2L, _BOR_OFF_2L & _BORV_27_2L
@   __CONFIG    _CONFIG2H, _WDT_OFF_2H & _WDTPS_128_2H
'@  __CONFIG    _CONFIG3L, _WDT_OFF_3L & _WDTPS_128_3L
@   __CONFIG    _CONFIG3H, _CCP2MX_OFF_3H
@   __CONFIG    _CONFIG4L, _STVR_OFF_4L & _LVP_OFF_4L & _DEBUG_OFF_4L
'@  __CONFIG    _CONFIG4H, _WDT_ON_4H & _WDTPS_128_4H
@   __CONFIG    _CONFIG5L, _CP0_OFF_5L & _CP1_OFF_5L & _CP2_OFF_5L & _CP3_OFF_5L
@   __CONFIG    _CONFIG5H, _CPB_OFF_5H & _CPD_OFF_5H
@   __CONFIG    _CONFIG6L, _WRT0_OFF_6L & _WRT1_OFF_6L & _WRT2_OFF_6L & _WRT3_OFF_6L
@   __CONFIG    _CONFIG6H, _WRTC_OFF_6H & _WRTB_OFF_6H & _WRTD_OFF_6H 
@   __CONFIG    _CONFIG7L, _EBTR0_OFF_7L & _EBTR1_OFF_7L & _EBTR2_OFF_7L & _EBTR3_OFF_7L
@   __CONFIG    _CONFIG7H, _EBTRB_OFF_7H 


'*****************************************************************************
'Config TIMER 1

T1CON = %00001110	'1/1 prescaler, Quartz 32,768

'*****************************************************************************
'Config TIMER 3

T3CON = %01110001	' ccp SUR TMR3,1/8 prescaler,Horloge systme,ON

'*****************************************************************************
'Config CCP1 arret CCP2

CCP1CON = %00000101	' Capture sur front montant 

CCP2CON = %00000000	'inhibition module CCP2

'*****************************************************************************
'Config Interruptions

INTCON  = %11000000
INTCON2 = %11110000
INTCON3 = %00000000

PIE1    = %00000100
PIE2    = %00000000

IPR1    = %00000101
IPR2	= %00000000

RCON	= %10000000

'*****************************************************************************
'Config ADC
'*****************************************************************************

ADCON0 = %11000000
ADCON1 = %00000011

'*****************************************************************************
'*****************************************************************************
'Config et Prepositionnement E/S
'*****************************************************************************

PORTA	= %0101000
PORTB 	= %0001000
PORTC	= 0
PORTD	= 0
PORTE	= 0

TRISA 	= %00111111
TRISB	= %11100011
TRISC	= %00000111
TRISD	= %00000000
TRISE	= %00000000
'
'*****************************************************************************
'Alias E/S
'*****************************************************************************

'MCLR/ sur Broche 1 par R/C/D

Voltage		var PORTA.0		'TENSION Batterie / 4
TempA		var PORTA.1		'LM335
TempH		var PORTA.2		'LM335
Vref		var PORTA.3		'MAX 874 = 4.096v ...
Raz			var PORTA.4		'JUMPER Raz/Programmation
PressH		var PORTA.5		'MPX5700

Contact		var PORTB.0		' + 12 v sous cl ( / 4 = 2 - 4 v !!! )
Selection 	var PORTB.1		'Poussoir slection Affichage
'			var PORTB.2
'			var PORTB.3
AlLCD		var PORTB.4		'Alimentation LCD BS 250 !!! 0 = ON : 1 = OFF
'			var PORTB.5
'			var PORTB.6
'			var PORTB.7

'			var PORTC.0
'			var PORTC.1
Speed		var PORTC.2		'Entre compte-tours 1C/4T
'			var PORTC.3
'			var PORTC.4
'			var PORTC.5
'			var PORTC.6
'			var PORTC.7

Buzzer		var PORTD.0		'Sortie commande Buzzer
Signal		var PORTD.1
RS			var PORTD.2
E			var PORTD.3
D4			var PORTD.4
D5			var PORTD.5
D6			var PORTD.6
D7			var PORTD.7

'			var PORTE.0
'			var PORTE.1
'			var PORTE.2

'*****************************************************************************
'Types Variables
'*****************************************************************************
'
Result		var WORD
Tension		var WORD
Tensionmoy	var WORD
Tair		var WORD
Thuile		var WORD
Vitesse		var WORD
Vitessemoy	var WORD
VitesseMax	var WORD
Pression	var WORD
Periode		var WORD
Periode2	var WORD
HoursT		var WORD
Dummy		var WORD
Capture		var WORD
CaptureOld	var WORD

Volt		var BYTE
LSelect		var BYTE
MinutesT	var BYTE
Delay		var BYTE
I			var BYTE


Cont		var BIT
DisabT		var BIT
DisabA		var BIT
DisabH		var BIT
DisabP		var BIT
RazT		var BIT
Buzz		var BIT
ServiceBit	var BIT

CLEAR

SecondsChanged = 1

'*****************************************************************************
'Includes
'*****************************************************************************

INCLUDE "DT_INTS-18.bas"
INCLUDE "ReEnterPBP-18.bas"

ASM
INT_LIST_H  macro    ; IntSource,        Label,  Type, ResetFlag?
 
        INT_Handler	   CCP1_INT,  _Period,       PBP,  yes
 
    endm
    INT_CREATE_H            ; Creates the interrupt processor
    
ENDASM

@	INT_ENABLE CCP1_INT

GOTO Affinit 

'*****************************************************************************
'*****************************************************************************
'Interruptions


'****************************************************************************
Period: 'Capture CCP1
'****************************************************************************
'
@ INT_CLEAR CCP1_INT 	'Reset du flag capture


Capture.Highbyte = CCPR1H
Capture.Lowbyte  = CCPR1L

IF Captureold <= Capture THEN

	Periode = Capture - CaptureOld

	
ELSE

	Periode =  65535 - CaptureOld + Capture + 1
	
ENDIF

	CaptureOld = Capture
	
	IF Periode <= 1501 THEN ' 9999 RPM maxi
		Vitesse = 9999
		GOTO noRPM
	ENDIF
	
Toggle SIGNAL

'*****************************************************************************
 'Calcul de la vitesse / Speed computing
'*****************************************************************************

	Periode2	 = Periode / 2  '  et 2^15 Maxi !
	
	Dummy	 = 2500*3000		'Prdiviseur  8 !!!
	Vitesse  = DIV32 Periode2
	
'*****************************************************************************
'Enregistrement: 'Vitesse MAX
'*****************************************************************************

VitesseMax = VitesseMax MAX Vitesse

noRPM:
	
@ INT_RETURN


'*****************************************************************************
'*****************************************************************************
'*****************************************************************************

'*****************************************************************************
Affinit: 'Affichage initial
'*****************************************************************************	

AlLCD = 0 						'Mise sous tension LCD
PAUSE  500

	LCDOUT $FE,1                    ' Initialize LCD

@ 	INT_ENABLE  CCP1_INT ; Autorisation interruptions CCP1

INTCON.7 	= 1				'Valider les Interruptions



'*****************************************************************************
'*****************************************************************************
'*****************************************************************************
'*****************************************************************************
Main: 'Programme principal


'*****************************************************************************
Affichage: 'Affichage toutes les 1/2 secondes
'*****************************************************************************


     	LCDOUT $FE,1, "N",DEC5 Periode,":P " ,DEC5 Periode2
     	
     	LCDOUT $FE,$C0, "Speed:" ,DEC Vitesse," T/Mn"
     	
PAUSE 500	' Pas trop vite ... Slow down, Slow down ....
	
GOTO Main

'*****************************************************************************
'*****************************************************************************
END


