'******************************************************************************
'*   Name    : VClock.BAS                                                     *
'*   Author  : Trent Jackson                                                  *
'*   Notice  : No Copyright                                                   *
'*           :                                                                *
'*   Date    : 17/5/2007                                                      *
'*   Version : 1.0                                                            *
'*                                                                            *
'* Acknowledgements                                                           *
'* Portions of Program extracted from: EZCLOCK2 By Paul R. Borgmeier, PhD     *
'* Crux analysis & design, LLC www.cruxanalysis.com                           * 
'******************************************************************************

   Include "modedefs.bas"             ' Serial Protocol
   Define   OSC 4                     ' 4MHz crystal used
                                      '
   '// Variables
   Counter    VAR Word                ' Track TMRO  
   Hours      VAR Byte                ' Total hrs (0-23)
   Minutes    VAR ByTE                ' Mins (0-59)
   Seconds    VAR Byte                ' Secs (0-59)
   RX_To_PC   VAR PORTA.0             ' RX line
   TX_To_PC   VAR PORTA.1             ' TX ...
   LED_Buzzer VAR PORTB.5             ' LED & Buzzer
   
   '// Init
   CMCON       = 7                    ' All digital
   OPTION_REG  = %10000111            ' TMRO prescale = 256
   TRISA       = %00000010            ' All outputs except RA1
   TRISB       = %00000000            ' All outputs ...
   TMR0        = 0                    ' Reset TMRO
   INTCON.2    = 0                    ' Clear TMRO overflow flag
   Hours       = 0                    ' Null  
   Minutes     = 0                    ' ^
   Seconds     = 0                    ' ^
   Counter     = $7A12                ' Load time counter
   
   '=============
   Wait_For_TMR0:                     ' Main loop  
   '=============
   IF INTCON.2 = 0 THEN Wait_For_TMR0 ' Wait for TMRO overflow
   INTCON.2    = 0                    ' Clear TMRO overflow flag
       Counter = Counter - $800       ' Dec counter until 1 sec has elapsed  

   '// Process hrs, mins secs accordingly ...
   IF Counter < $800 THEN
      Seconds = Seconds + 1
      If Seconds = 60 Then
         Seconds = 0
         Minutes = Minutes + 1
         If Minutes = 60 Then
            Minutes = 0
            Hours = Hours + 1
            If Hours = 24 Then
               Hours = 0
            EndIf
         EndIf
      EndIf
   
   '// Add leading zeros to all single digits & output str serially to PC
      If Hours < 10 And Minutes > 9 And Seconds > 9 Then
         SEROUT RX_To_PC, N2400, ["@","0",#Hours,":",#Minutes,":",#Seconds]
      ELSE:IF Hours > 9 and Minutes < 10 and Seconds > 9 THEN
         SEROUT RX_To_PC, N2400, ["@",#Hours,":0",#Minutes,":",#Seconds]
      ELSE:IF Hours < 10 and Minutes < 10 and Seconds > 9 THEN
         SEROUT RX_To_PC, N2400, ["@","0",#Hours,":0",#Minutes,":",#Seconds]
      ELSE:IF Hours > 9 and Minutes > 9 and Seconds < 10 THEN
         SEROUT RX_To_PC, N2400, ["@",#Hours,":",#Minutes,":0",#Seconds]
      ELSE:IF Hours < 10 and Minutes > 9 and Seconds < 10 THEN
         SEROUT RX_To_PC, N2400, ["@","0",#Hours,":",#Minutes,":0",#Seconds]
      ELSE:IF Hours > 9 and Minutes < 10 and Seconds < 10 THEN
         SEROUT RX_To_PC, N2400, ["@",#Hours,":0",#Minutes,":0",#Seconds]
      ELSE:IF Hours < 10 and Minutes < 10 and Seconds < 10 THEN
         SEROUT RX_To_PC, N2400, ["@","0",#Hours,":0",#Minutes,":0",#Seconds]
      Else
         SEROUT RX_To_PC, N2400, ["@",#Hours,":",#Minutes,":",#Seconds]
      EndIf: EndIf: EndIf: EndIf: EndIf: EndIf: EndIf

      Counter = Counter + $7A12          ' Reset counter 
      Toggle LED_Buzzer                  '  
   '//
   Else 'Wait here for 50mS to see if the host(PC) is trying to set new time val                               
   '//
      SERIN TX_To_PC, N2400, 50, Wait_For_TMR0, ["@"], Hours, Minutes, Seconds
   EndIf
   GoTo Wait_For_TMR0                    ' Loop back
   end
