DEVICE 18F458
XTAL = 4

;------------------IMAGE DATA---------------------------------------

;include "logo.bas"

DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,
DATA $FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,

@CONFIG_REQ
	@__CONFIG CONFIG1H, OSCS_OFF_1 & XT_OSC_1
	@__CONFIG CONFIG2L, BOR_OFF_2 & BORV_20_2 & PWRT_OFF_2
	@__CONFIG CONFIG2H, WDT_OFF_2 & WDTPS_128_2
	@__CONFIG CONFIG4L, STVR_OFF_4 & LVP_OFF_4 & DEBUG_OFF_4

SYMBOL LCD_DC=PORTB.5 
SYMBOL LCD_CS=PORTB.6
SYMBOL LCD_SDA=PORTB.4
SYMBOL LCD_RST=PORTB.7
SYMBOL LCD_CLK=PORTB.3
SYMBOL LCD_MODE_INVERT=%00001101
SYMBOL LCD_MODE_NORMAL=%00001100

DECLARE RSOUT_MODE INVERTED , TRUE
DECLARE RSIN_MODE INVERTED , TRUE
DECLARE RSIN_TIMEOUT 2000
DECLARE RSOUT_PIN PORTA.0	
DECLARE RSIN_PIN PORTA.1
DECLARE SERIAL_BAUD 9600

SYMBOL MAXGRAPHVALUE = 15
ALL_DIGITAL = TRUE
DIM I AS BYTE
DIM I2 AS BYTE
DIM I3 AS BYTE
DIM J AS WORD
DIM K AS BYTE
DIM POSX AS BYTE
DIM POSY AS BYTE
DIM TEMPVAR1 AS WORD
DIM FONTCACHE[6] AS BYTE
DIM LCDSTR[14] AS BYTE
DIM LCD_DATA AS BYTE
DIM LCD_OFFSET_1 AS BYTE
DIM LCD_OFFSET_2 AS BYTE
DIM CHAR_MODE AS BYTE

;-------MEASURMENT-----------
DIM VALIN AS BYTE
DIM VALVAL[3] AS BYTE
;-------GRAPH VARIABLES------
DIM GRAPH_LOWBYTE AS BYTE
DIM GRAPH_HIGHBYTE AS BYTE
DIM GRAPH_PLOTVALUE AS BYTE
DIM GRAPH_ORIGO_X AS BYTE
DIM GRAPH_ORIGO_Y AS BYTE
;-------PROGRESS BAR---------
DIM LENGTH AS BYTE
DIM DRAW_DATA AS BYTE

;-------EEPROM DATA SAVE-----
DIM CUR_ADR AS BYTE
DIM E_DATA AS BYTE
CUR_ADR = 0
;-------LCD INITIALISATION--------
CHAR_MODE=1	  'NORMAL 0=INVERT


LOW LCD_CS 'CHIP SELECTED

GOSUB LCD_INIT
GOSUB LCD_CLEAR
DELAYMS 50 
GOSUB LCD_INIT
'SET CONTRAST
'LOW LCD_DC
SHOUT LCD_SDA , LCD_CLK , MSBFIRST, [ $21,$A7,$20 ]
;---------------------------
MAIN:

'NORMAL SCREEN MODE
  LOW LCD_DC
LCD_DATA= %00001100:GOSUB LCD_SENDBYTE

GOSUB LCD_CLEAR
GOSUB LCD_HOME
GOSUB LCD_SHOWIMAGE
STOP 
'DELAYMS 4000
GOSUB LCD_CLEAR

LOOP:
VALIN = COUNTER PORTE.2 ,100
STR LCDSTR = "Freq:",0:GOSUB LCD_HOME:GOSUB LCD_SENDSTRING
STR LCDSTR = STR$(DEC VALIN):GOSUB LCD_SENDSTRING
STR LCDSTR = "KHz:",0
LCD_DATA= VALIN:POSX=0:POSY=1:LENGTH=83:GOSUB LCD_PLOTPROGRESSBAR

RSOUT DEC VALIN,$D,$A
E_DATA = VALIN:GOSUB SAVE_DATA
IF CUR_ADR = 15 THEN
   GOSUB LCD_DRAWGRAPH
   RSOUT "MEMORY FULL"
   STOP
ENDIF
GOTO LOOP

'===================================LCD SUBROUTINE=====================================
LCD_INIT:
'RESET LCD
LOW LCD_RST
DELAYMS 20
HIGH LCD_RST
LOW LCD_CS : LOW LCD_DC
  LCD_DATA= $21: GOSUB LCD_SENDBYTE		'LCD EXTENDED COMMANDS
  LCD_DATA= $C8: GOSUB LCD_SENDBYTE		'SET LCD VOP (CONTRAST)
  LCD_DATA= $06: GOSUB LCD_SENDBYTE		'SET TEMP COEFFICENT
  LCD_DATA= $13: GOSUB LCD_SENDBYTE		'LCD BIAS MODE 1:48
  LCD_DATA= $20: GOSUB LCD_SENDBYTE		'LCD STANDARD COMMANDS
  LCD_DATA= $0C: GOSUB LCD_SENDBYTE		'LCD IN NORMAL MODE
RETURN
;=====================
LCD_SENDBYTE:
'  LOW LCD_CS
  SHOUT LCD_SDA , LCD_CLK , MSBFIRST, [ LCD_DATA ]
'  HIGH LCD_CS
RETURN
;=====================
LCD_SENDGBYTE:
	HIGH LCD_DC
	SHOUT LCD_SDA , LCD_CLK , MSBFIRST, [ LCD_DATA ]
	LOW LCD_DC
RETURN
;=====================
LCD_CONTRAST:
  LOW LCD_DC
  LCD_DATA=$C8:GOSUB LCD_SENDBYTE	'WRITE DATA
RETURN
;======================
LCD_SENDCHAR:
	J=LCD_DATA * 6
	FOR I=0 TO 5
	  LCD_DATA=CREAD FONT1+J+I
	  IF CHAR_MODE=0 THEN LCD_DATA = ~LCD_DATA
	  FONTCACHE[I]=LCD_DATA
	NEXT
	HIGH LCD_DC
	SHOUT LCD_SDA , LCD_CLK , MSBFIRST, [ FONTCACHE[0],FONTCACHE[1],FONTCACHE[2],FONTCACHE[3],FONTCACHE[4],FONTCACHE[5] ]
RETURN
;======================
LCD_SENDSTRING:
	FOR K=0 TO 13	  ' STEP -1
		LCD_DATA=LCDSTR[K]
		IF LCD_DATA=0 THEN BREAK
		GOSUB LCD_SENDCHAR
	NEXT
	CHAR_MODE=1
RETURN
;======================
LCD_CLEAR:
GOSUB LCD_HOME
HIGH LCD_DC
FOR I=1 TO 252
  LCD_DATA=0:GOSUB LCD_SENDBYTE	'WRITE DATA
  LCD_DATA=0:GOSUB LCD_SENDBYTE	'WRITE DATA
NEXT
RETURN
;======================
LCD_HOME:
  LOW LCD_DC
  LCD_DATA=%01000000:GOSUB LCD_SENDBYTE	'Y
  LCD_DATA=%10000000:GOSUB LCD_SENDBYTE	'X
  POSX=0:POSY=0:GOSUB LCD_GOTOXY
RETURN
;======================
LCD_GOTOXY:
  LOW LCD_DC
  LCD_DATA=%01000000 | POSY :GOSUB LCD_SENDBYTE	'Y
  LCD_DATA=%10000000 | POSX :GOSUB LCD_SENDBYTE	'X
RETURN
;====================== 
LCD_DRAWGRAPH: ;DRAWS A BAR GRAPH 84 PX WIDTH, 2 ROWS HIGHT = 16PX
POSX=0:POSY=4:GOSUB LCD_GOTOXY

FOR I2 = 0 TO 15
LCD_DATA = $22 : GOSUB LCD_SENDBYTE 'ACTIVATE VERTICAL ADRESSING MODE
'LCD_DATA= EREAD I2:GOSUB LCD_PLOTONEBAR
LCD_DATA = I2:GOSUB LCD_PLOTONEBAR
LCD_DATA = $20 : GOSUB LCD_SENDBYTE 'ACTIVATE HORISONTAL ADRESSING MODE
POSX=POSX+1:GOSUB LCD_GOTOXY 
NEXT

RETURN
;======================
LCD_PLOTONEBAR: ;DRAWS ONE BAR FOR THE GRAPH, LCD_DATA AS BYTE TO DRAW
GRAPH_LOWBYTE = $00
GRAPH_HIGHBYTE = $00
GRAPH_PLOTVALUE = LCD_DATA*15/MAXGRAPHVALUE
RSOUT "BAR", DEC I2,":", DEC LCD_DATA, "PLOT:",DEC GRAPH_PLOTVALUE,$D,$A

IF GRAPH_PLOTVALUE > 0 AND GRAPH_PLOTVALUE <= 8 THEN ;PLOTS THE BAR IF IT IS BELOW 8 PIXELS

        FOR I = GRAPH_PLOTVALUE - 1 TO  0 STEP -1
        	GRAPH_LOWBYTE = GRAPH_LOWBYTE >> 1
			GRAPH_LOWBYTE = GRAPH_LOWBYTE + $80
        NEXT

        GRAPH_HIGHBYTE = $00

ELSEIF GRAPH_PLOTVALUE > 8 AND GRAPH_PLOTVALUE < 15 THEN ;PLOTS THE BAR IF IT IS ABOVE 8 PIXELS

        GRAPH_PLOTVALUE = GRAPH_PLOTVALUE - 8

        FOR I = GRAPH_PLOTVALUE - 1 TO  0 STEP -1
        	GRAPH_HIGHBYTE = GRAPH_HIGHBYTE >> 1
        	GRAPH_HIGHBYTE = GRAPH_HIGHBYTE + $80
        NEXT

        GRAPH_LOWBYTE = $FF

ELSEIF GRAPH_PLOTVALUE > 15 THEN
        GRAPH_HIGHBYTE = $FF
        GRAPH_LOWBYTE = $FF
END IF

LCD_DATA = GRAPH_HIGHBYTE : GOSUB LCD_SENDGBYTE
LCD_DATA = GRAPH_LOWBYTE : GOSUB LCD_SENDGBYTE
RETURN
;=======================
LCD_PLOTPROGRESSBAR: ;(X,Y,VALUE,LENGTH)
DRAW_DATA = LCD_DATA
GRAPH_PLOTVALUE = (LCD_DATA*(LENGTH-2))/MAXGRAPHVALUE 
GOSUB LCD_GOTOXY
LCD_DATA=%01110000:GOSUB LCD_SENDGBYTE ;Start bar

IF DRAW_DATA < MAXGRAPHVALUE THEN 'Then everything is okay, draw bar...

        IF DRAW_DATA > 0 THEN
        		FOR I = 0 TO GRAPH_PLOTVALUE-1
                	LCD_DATA=%11011000:GOSUB LCD_SENDGBYTE
                NEXT
        
                LCD_DATA=%11111000:GOSUB LCD_SENDGBYTE
                
                FOR I = 0 TO LENGTH -GRAPH_PLOTVALUE - 4
                	LCD_DATA=%10001000:GOSUB LCD_SENDGBYTE
                NEXT
         			        		
        ELSE IF DRAW_DATA = 0 THEN
                FOR I = 0 TO LENGTH - 2
               	LCD_DATA=%10001000:GOSUB LCD_SENDGBYTE
                NEXT   		
        ENDIF
ELSE
        FOR I = 0 TO LENGTH - 2
        	LCD_DATA=%11011000:GOSUB LCD_SENDGBYTE
        NEXT

ENDIF
LCD_DATA=%01110000:GOSUB LCD_SENDGBYTE ;End bar
RETURN

;=======================
LCD_SHOWIMAGE:

FOR J = 0 TO 503
	  	RESTORE J
		LCD_DATA = READ:
		IF LCD_DATA = $00 THEN
		RSOUT "0"
		ENDIF
		GOSUB LCD_SENDGBYTE

NEXT

RETURN						 

;=======================EEPROM OPERATIONS=====================================
;WRITE EEPROM DATA, TO CURRENT ADDRESS
SAVE_DATA:
EWRITE CUR_ADR,[E_DATA]
CUR_ADR = CUR_ADR + 1
RETURN

'=============================================================================
' Font CDATA table
' Copy and paste this table into your own program
' If an internal font is required.
Font1:
CData $00,$00,$00,$00,$00,$00		'Graphic character 0
CData $FF,$FF,$FF,$FF,$FF,$FF		'Graphic character 1
CData $07,$07,$07,$00,$00,$00		'Graphic character 2
CData $00,$00,$00,$07,$07,$07		'Graphic character 3
CData $E0,$E0,$E0,$00,$00,$00		'Graphic character 4
CData $00,$00,$00,$E0,$E0,$E0		'Graphic character 5
CData $FF,$FF,$FF,$00,$00,$00		'Graphic character 6
CData $00,$00,$00,$FF,$FF,$FF		'Graphic character 7
CData $07,$07,$07,$07,$07,$07		'Graphic character 8
CData $E0,$E0,$E0,$E0,$E0,$E0		'Graphic character 9
CData $E0,$E0,$E0,$07,$07,$07		'Graphic character 10
CData $07,$07,$07,$E0,$E0,$E0		'Graphic character 11
CData $FF,$FF,$FF,$E0,$E0,$E0		'Graphic character 12
CData $E0,$E0,$E0,$FF,$FF,$FF		'Graphic character 13
CData $07,$07,$07,$FF,$FF,$FF		'Graphic character 14
CData $FF,$FF,$FF,$07,$07,$07		'Graphic character 15
CData $55,$AA,$55,$AA,$55,$AA		'Graphic character 16
CData $AA,$55,$AA,$55,$AA,$55		'Graphic character 17
CData $01,$01,$01,$01,$01,$01		'Graphic character 18
CData $80,$80,$80,$80,$80,$80		'Graphic character 19
CData $FF,$00,$00,$00,$00,$00		'Graphic character 20
CData $00,$00,$00,$00,$00,$FF		'Graphic character 21
CData $FF,$01,$01,$01,$01,$01		'Graphic character 22
CData $01,$01,$01,$01,$01,$FF		'Graphic character 23
CData $FF,$80,$80,$80,$80,$80		'Graphic character 24
CData $80,$80,$80,$80,$80,$FF		'Graphic character 25
CData $00,$00,$00,$00,$F0,$F0		'User defined character 26
CData $00,$00,$00,$00,$0F,$0F		'User defined character 27
CData $00,$00,$00,$00,$00,$00		'User defined character 28
CData $00,$00,$00,$00,$00,$00		'User defined character 29
CData $00,$00,$00,$00,$00,$00		'User defined character 30
CData $00,$00,$00,$00,$00,$00		'User defined character 31
CData $00,$00,$00,$00,$00,$00		'32 -   - 20        
CData $00,$00,$4F,$00,$00,$00		'33 - ! - 21
CData $00,$07,$00,$07,$00,$00		'34 - " - 22
CData $14,$7F,$14,$7F,$14,$00		'35 - # - 23
CData $24,$2A,$7F,$2A,$12,$00		'36 - $ - 24
CData $23,$13,$08,$64,$62,$00		'37 - % - 25
CData $36,$49,$55,$22,$50,$00		'38 - & - 26
CData $00,$05,$03,$00,$00,$00		'39 - ' - 27
CData $1C,$22,$41,$00,$00,$00		'40 - ( - 28
CData $00,$00,$41,$22,$1C,$00		'41 - ) - 29
CData $14,$08,$3E,$08,$14,$00		'42 - * - 2A
CData $08,$08,$3E,$08,$08,$00		'43 - + - 2B
CData $00,$50,$30,$00,$00,$00		'44 - , - 2C
CData $08,$08,$08,$08,$08,$00		'45 - - - 2D
CData $00,$60,$60,$00,$00,$00		'46 - . - 2E
CData $20,$10,$08,$04,$02,$00		'47 - / - 2F
CData $3E,$51,$49,$45,$3E,$00		'48 - 0 - 30
CData $00,$42,$7F,$40,$00,$00		'49 - 1 - 31
CData $42,$61,$51,$49,$46,$00		'50 - 2 - 32
CData $21,$41,$45,$4B,$31,$00		'51 - 3 - 33
CData $18,$14,$12,$7F,$10,$00		'52 - 4 - 34
CData $27,$45,$45,$45,$39,$00		'53 - 5 - 35
CData $3C,$4A,$49,$49,$30,$00		'54 - 6 - 36
CData $01,$71,$09,$05,$03,$00		'55 - 7 - 37
CData $36,$49,$49,$49,$36,$00		'56 - 8 - 38
CData $06,$49,$49,$49,$3E,$00		'57 - 9 - 39
CData $00,$36,$36,$00,$00,$00		'58 - : - 3A
CData $00,$56,$36,$00,$00,$00		'59 - ; - 3B
CData $08,$14,$22,$41,$00,$00		'60 - < - 3C
CData $14,$14,$14,$14,$14,$00		'61 - = - 3D
CData $00,$41,$22,$14,$08,$00		'62 - > - 3E
CData $02,$01,$51,$09,$06,$00		'63 - ? - 3F
CData $32,$49,$79,$41,$3E,$00		'64 - @ - 40
CData $7E,$11,$11,$11,$7E,$00		'65 - A - 41
CData $7F,$49,$49,$49,$36,$00		'66 - B - 42
CData $3E,$41,$41,$41,$22,$00		'67 - C - 43
CData $7F,$41,$41,$22,$1C,$00		'68 - D - 44
CData $7F,$49,$49,$49,$41,$00		'69 - E - 45
CData $7F,$09,$09,$09,$01,$00		'70 - F - 46
CData $3E,$41,$49,$49,$7A,$00		'71 - G - 47
CData $7F,$08,$08,$08,$7F,$00		'72 - H - 48
CData $00,$41,$7F,$41,$00,$00		'73 - I - 49
CData $20,$40,$41,$3F,$01,$00		'74 - J - 4A
CData $7F,$08,$14,$22,$41,$00		'75 - K - 4B
CData $7F,$40,$40,$40,$40,$00		'76 - L - 4C
CData $7F,$02,$0C,$02,$7F,$00		'77 - M - 4D
CData $7F,$04,$08,$10,$7F,$00		'78 - N - 4E
CData $3E,$41,$41,$41,$3E,$00		'79 - O - 4F
CData $7F,$09,$09,$09,$06,$00		'80 - P - 50
CData $3E,$41,$51,$21,$5E,$00		'81 - Q - 51
CData $7F,$09,$19,$29,$46,$00		'82 - R - 52
CData $46,$49,$49,$49,$31,$00		'83 - S - 53
CData $01,$01,$7F,$01,$01,$00		'84 - T - 54
CData $3F,$40,$40,$40,$3F,$00		'85 - U - 55
CData $1F,$20,$40,$20,$1F,$00		'86 - V - 56
CData $3F,$40,$38,$40,$3F,$00		'87 - W - 57
CData $63,$14,$08,$14,$63,$00		'88 - X - 58
CData $07,$08,$70,$08,$07,$00		'89 - Y - 59
CData $61,$51,$49,$45,$43,$00		'90 - Z - 5A
CData $7F,$41,$41,$00,$00,$00		'91 - [ - 5B
CData $02,$04,$08,$10,$20,$00		'92 - \ - 5C
CData $00,$00,$41,$41,$7F,$00		'93 - ] - 5D
CData $04,$02,$01,$02,$04,$00		'94 - ^ - 5E
CData $40,$40,$40,$40,$40,$00		'95 - _ - 5F
CData $00,$01,$02,$04,$00,$00		'96 - ` - 60
CData $20,$54,$54,$54,$78,$00		'97 - a - 61
CData $7F,$48,$44,$44,$38,$00		'98 - b - 62
CData $38,$44,$44,$44,$20,$00		'99 - c - 63
CData $38,$44,$44,$48,$7F,$00		'100  d - 64
CData $38,$54,$54,$54,$18,$00		'101  e - 65
CData $08,$7E,$09,$01,$02,$00		'102  f - 66
CData $0C,$52,$52,$52,$3E,$00		'103  g - 67
CData $7F,$08,$04,$04,$78,$00		'104  h - 68
CData $00,$44,$7D,$40,$00,$00		'105  i - 69
CData $00,$20,$40,$44,$3D,$00		'106  j - 6A
CData $7F,$10,$28,$44,$00,$00		'107  k - 6B
CData $00,$41,$7F,$40,$00,$00		'108  l - 6C
CData $7C,$04,$18,$04,$78,$00		'109  m - 6D
CData $7C,$08,$04,$04,$78,$00		'110  n - 6E
CData $38,$44,$44,$44,$38,$00		'111  o - 6F
CData $7C,$14,$14,$14,$08,$00		'112  p - 70
CData $08,$14,$14,$18,$7C,$00		'113  q - 71
CData $7C,$08,$04,$04,$08,$00		'114  r - 72
CData $48,$54,$54,$54,$20,$00		'115  s - 73
CData $04,$3F,$44,$40,$20,$00		'116  t - 74
CData $3C,$40,$40,$20,$7C,$00		'117  u - 75
CData $1C,$20,$40,$20,$1C,$00		'118  v - 76
CData $3C,$40,$30,$40,$3C,$00		'119  w - 77
CData $44,$28,$10,$28,$44,$00		'120  x - 78
CData $0C,$50,$50,$50,$3C,$00		'121  y - 79
CData $44,$64,$54,$4C,$44,$00		'122  z - 7A
CData $08,$36,$41,$00,$00,$00		'123  { - 7B
CData $00,$00,$7F,$00,$00,$00		'124  | - 7C
CData $00,$00,$41,$36,$08,$00		'125  } - 7D
CData $00,$08,$04,$08,$04,$00 		'126  ~ - 7E