'****************************************************************
'*  Name    : CanCfg.bas                                        *
'*  Author  : James S. McLaughlin                               *
'*  Notice  : Copyright (c) 2002                                *
'*          : All Rights Reserved                               *
'*  Date    : 1/10/2002                                         *
'*  Version : 1.0                                               *
'*  Notes   : can configuration routing MCP2510                 *
'*          :                                                   *
'****************************************************************
'cut and paste into code:    
'declares for receive filter 0 mask and filters
'RxMask0High     var byte
'RxMask0Low      var byte
'RxFilter0High   var byte
'RxFilter0Low    var byte
'RxFilter1High   var byte
'RxFilter1Low    var byte

'declares for receive filter 1 mask and filters
'RxMask1High     var byte
'RxMask1Low      var byte
'RxFilter2High   var byte
'RxFilter2Low    var byte
'RxFilter3High   var byte
'RxFilter3Low    var byte
'RxFilter4High   var byte
'RxFilter4Low    var byte
'RxFilter5High   var byte
'RxFilter5Low    var byte
    
'initializations for receive filter 0 mask and filters
'RxMask0High =0 
'RxMask0Low =0
'RxFilter0High = 0
'RxFilter0Low = 0
'RxFilter1High = 0
'RxFilter1Low = 0

'initializations for receive filter 1 mask and filters
'RxMask1High = 0
'RxMask1Low = 0
'RxFilter2High = 0
'RxFilter2Low = 0
'RxFilter3High = 0
'RxFilter3Low = 0
'RxFilter4High = 0
'RxFilter4Low = 0
'RxFilter5High = 0
'RxFilter5Low = 0

    'receive filter 0 mask and filters
    'RxMask0High   - RXMOSIDH
    'RxMask0Low    - RXMOSIDL

    'RxFilter0High - RXFOSIDH
    'RxFilter0Low  - RXFOSIDL
    'RxFilter1High - RXF1SIDH
    'RxFilter1Low  - RXF1SIDL

    'receive filter 1 mask and filters
    'RxMask1High   - RXM1SIDH
    'RxMask1Low    - RXM1SIDL
    
    'RxFilter2High - RXF2SIDH
    'RxFilter2Low  - RXF2SIDL
    'RxFilter3High - RXF3SIDH
    'RxFilter3Low  - RXF3SIDL
    'RxFilter4High - RXF4SIDH
    'RxFitler4Low  - RXF4SIDL
    'RxFilter5High - RXF5SIDH
    'RxFilter5Low  - RXF5SIDL
    
CanConfig:
	'from logic anal debug check of de:
	Low CS
		RXDATA = SSPBUF			'read, discard (slow down...)
		SSPBUF = %00000101			'bit modify command
		GoSub letclear
		RXDATA = SSPBUF			'read, discard (slow down...)
		SSPBUF = CANCTRL			'mcp2510 can controller address
		GoSub letclear
		RXDATA = SSPBUF			'read, discard (slow down...)
		SSPBUF = %00000011			'mask clkpre1,0
		GoSub letclear
		RXDATA = SSPBUF			'read, discard (slow down...)
		SSPBUF = %00000000			'clock clkpre1,0 = 1
		GoSub letclear
	High CS

	'set up mcp2510 can controller networking parameters:
	Low CS
	   RXDATA = SSPBUF			'read, discard (slow down...)
    	SSPBUF = %00000010			'write command
    	GoSub letclear
    	RXDATA = SSPBUF			'read, discard (slow down...)
    	SSPBUF = CNF1				'can configuration register
    	GoSub letclear
    	RXDATA = SSPBUF			'read, discard (slow down...)
'    	SSPBUF = $07				'load CNF1  '00001111
    	SSPBUF = $03				'load CNF1  '00001111
    	GoSub letclear
	High CS

    Low CS
        RXData = SSPBUF
        SSPBUF = %00000010			'write command
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00101001          'CNF2
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = $90                '10010000
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00101000          'CNF3
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = $02                '00000010
    	GoSub letclear
    High cs
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00100000          'RXM0SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxMask0High
        'SSPBUF = %11111111
    	GoSub letclear
    High CS
    
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00100001          'RXM0SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxMask0Low
        'SSPBUF = %11100000
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = 0                  'RXF0SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter0High
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = 1                'RXF0SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter0Low
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00000100          'RXF1SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter1High
    	GoSub letclear
    High CS
        
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00000101          'RXF1SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter1Low
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00100100          'RXM1SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxMask1High
        'SSPBUF = %11111111
'        SSPBUF = 0  'everything
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00100101          'RXM1SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxMask1Low
        'SSPBUF = %11100000
'        SSPBUF = 0  'everything
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00001000          'RXF2SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter2High
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00001001          'RXF2SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter2Low
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00010000          'RXF3SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter3High
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00010001          'RXF3SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter3Low
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00010100          'RXF4SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter4High
    	GoSub letclear
    High CS

    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00010101          'RXF4SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter4Low
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00011000          'RXF5SIDH
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter5High
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00011001          'RXF5SIDL
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = RxFilter5Low
    	GoSub letclear
    High CS
    
    Low CS
        RXDATA = SSPBUF
        SSPBUF = %00000010
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00101011          'CANINTE
    	GoSub letclear
        RXDATA = SSPBUF             
        SSPBUF = 0
    	GoSub letclear
    High CS

    Low CS
        RXData = SSPBUF
        SSPBUF = %00000101          'bit modify
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %00001111          'CANCTRL
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = %11100000          'MASK
    	GoSub letclear
        RXDATA = SSPBUF
        SSPBUF = 0                  'normal mode
    	GoSub letclear
    High CS	
Return

