'****************************************************************
'*  Name    : CanError.BAS                                      *
'*  Author  : James S. McLaughlin                               *
'*  Notice  : Copyright (c) 2002                                *
'*          : All Rights Reserved                               *
'*  Date    : 1/11/2002                                         *
'*  Version : 1.0                                               *
'*  Notes   : can receive and xmit error detection              *
'*          : (place in subroutines area of code)               *
'****************************************************************

'cut and paste in main declaration, remove comments:
'TECerror    var byte       'transmit error count (byte)
'RECerror    var byte       'receive error count (byte)
'ResetCanFlag    var bit    'flag to reset the controller (bit)
'TECerror = 0               'initialization
'RECerror = 0               'initialization
'ResetCanFlag = 0           'initialization
'CanErrLevelTx var byte     'set to any value, warn is 96, soft passive 128
'CanErrLevelRx var byte     'set to any value, warn is 96, soft passive 128
'CanErrLevelTx = 88         '96 is first warning level
'CanErrLevelRx = 88         '96 is first warning level

'place following in appropriate place in code and uncomment 
'       'check for can error count:
'    gosub CanError
'    if ResetCanFlag = 1 then
'        ResetCanFlag = 0
'        gosub ResetCan
'        GoSub CanConfig				'put in config mode, set up, return to normal mode...
'    endif

CanError:
        'TECerror         'can transmit error count
        Low CS
            'RXData = SSPBUF
            SSPBUF = %00000011			'read command
        	GoSub letclear
            'RXDATA = SSPBUF
            SSPBUF = TEC                'transmitter error count (section 6, page 42)
        	GoSub letclear
            'RXDATA = SSPBUF
            SSPBUF = 0                  'clock it out
        	GoSub letclear
            RXDATA = SSPBUF             'this should have data
        High CS	
        TECerror = RXDATA
        IF TECerror > CanErrLevelTx Then          'can controller is hung, so start over...
            'abort the transmit request, reset TECerror so printing to vbterm stops
            ResetCanFlag = 1
            TECerror = 0
            Low CS
                'RXData = SSPBUF
                SSPBUF = %00000101          'bit modify
            	GoSub letclear
                'RXDATA = SSPBUF
                SSPBUF = TXB0CTRL
            	GoSub letclear
                'RXDATA = SSPBUF
                SSPBUF = %00001000          'MASK (bit number 2)
            	GoSub letclear
                'RXDATA = SSPBUF
                SSPBUF = %00000000          'clear bit to request an abort!
            	GoSub letclear
            High CS	
        EndIF
        'RECerror         'can receive error count
        Low CS
            'RXData = SSPBUF
            SSPBUF = %00000011			'read command
        	GoSub letclear
            'RXDATA = SSPBUF
            SSPBUF = REC                'receive error count (section 6, page 42)
        	GoSub letclear
            'RXDATA = SSPBUF
            SSPBUF = 0                  'clock it out
        	GoSub letclear
            RXDATA = SSPBUF             'this should have data
        High CS	
        RECerror = RXDATA
        IF RECerror > CanErrLevelRx Then          'can controller is hung, so start over...
            ResetCanFlag = 1
            'reset counter
            RECerror = 0
        EndIF
return

