'****************************************************************
'*  Name    : TransCan.BAS                                      *
'*  Author  : James S. McLaughlin                               *
'*  Notice  : Copyright (c) 2002                                *
'*          : All Rights Reserved                               *
'*  Date    : 1/16/2002                                         *
'*  Version : 1.0                                               *
'*  Notes   : Tansmit on can chip                               *
'*          :                                                   *
'****************************************************************

TransCan:
        Low CS
            SSPBUF = %00000011			'read command
        	GoSub letclear
            SSPBUF = TXB0CTRL  + TxBuffer * 16          'transmission control register
        	GoSub letclear
            SSPBUF = 0                  'clock it out
        	GoSub letclear
            RXDATA = SSPBUF             'this should have buffer status
        High CS	
        IfCanBuf = RXDATA & %00001000               'bit 3 is all we care about (TXREQ)
        IF IfCanBuf = %00000000 Then        'will be zero if available...
            'bit modify to set tx buffer priority (0 to 3)
            Low CS
                RXData = SSPBUF
                SSPBUF = %00000101          'bit modify
            	GoSub letclear
                RXDATA = SSPBUF
                SSPBUF = TXB0CTRL + TxBuffer * 16  
            	GoSub letclear
                RXDATA = SSPBUF
                SSPBUF = %00000011          'MASK
            	GoSub letclear
                RXDATA = SSPBUF
                SSPBUF = TXPriority[TxBuffer]
            	GoSub letclear
            High CS	
            Low CS
                SSPBUF = %00000010          'write
                GoSub letclear
                SSPBUF = TXB0SIDH + TxBuffer * 16         'high id
                GoSub letclear
                SSPBUF = TxIDHigh[TxBuffer]
                GoSub letclear
            High CS
            Low CS
                SSPBUF = %00000010          'write
                GoSub letclear
                SSPBUF = TXB0SIDL  + TxBuffer * 16        'low id
                GoSub letclear
                SSPBUF = TxIDLow[TxBuffer]
                GoSub letclear
            High CS
            Low CS
                SSPBUF = %00000010          'write
                GoSub letclear
                SSPBUF = TXB0DLC + TxBuffer * 16   
                GoSub letclear
                SSPBUF = DataBytesTx
                GoSub letclear
            High CS
            Low CS
                SSPBUF = %00000010          'write
                GoSub letclear
                SSPBUF = TXB0D0  + TxBuffer * 16          'data buffer  
                GoSub letclear
                SSPBUF = CanDataTx[0]
                GoSub letclear
                IF DataBytesTx > 1 Then
                    For i = 1 to DataBytesTx - 1
                        SSPBUF = CanDataTx[i]
                        GoSub letclear
                    Next
                EndIF
            High CS
            'must end dialog with a transmit request (use bit mod):
            Low CS
                SSPBUF = %00000101          'bit modify
            	GoSub letclear
                SSPBUF = TXB0CTRL + TxBuffer * 16
            	GoSub letclear
                SSPBUF = %00001000          'MASK (bit number 3)
            	GoSub letclear
                SSPBUF = %00001000          'can will clear when the message goes!
            	GoSub letclear
            High CS	
        Else
            'oops, buffer is full, return
            '(can't do this in a general include - ionode has no usart)
            'char = "$" : GoSub sendstuff
        EndIF
Return
