'****************************************************************
'*  Name    : ReceiveCan.BAS                                    *
'*  Author  : James S. McLaughlin                               *
'*  Notice  : Copyright (c) 2002                                *
'*          : All Rights Reserved                               *
'*  Date    : 1/17/2002                                         *
'*  Version : 1.0                                               *
'*  Notes   : MCP2510 communication (receive) control           *
'*          :                                                   *
'****************************************************************
ReceiveCan:
    'check mcp2510 can controller receive buffer:
    RxBuffer = 0                    'clear flag
    Low CS
        SSPBUF = %00000011			'read command
    	GoSub letclear
        SSPBUF = CANINTF            'buffer flags are contained in this mcp2510 can controller register
    	GoSub letclear
        SSPBUF = 0                  'clock it out
    	GoSub letclear
        RXDATA = SSPBUF             'receive buffer status
    High CS
    RxBuffer = RXDATA & %00000011   'isolate last two bits
    IF RxBuffer > 0 Then               'a buffer is full, or 3, then both are full!
        if (RxBuffer = 1) or (RxBuffer = 3) then
            RxBufferSub = 1
            Gosub ReceiveCanSub0
        endif
        if (RxBuffer = 2) or (RxBuffer = 3) then
            RxBufferSub = 2
            gosub ReceiveCanSub1
        endif
    EndIF   'RX1If end
return

ReceiveCanSub0:
            Low CS
            SSPBUF = 3               'read
            GoSub letclear
            SSPBUF = RXB0DLC + (RxBufferSub -1) * 16      'receive buffer of data bytes offset 16
            GoSub letclear
            SSPBUF = 0              'dummy clock it
            GoSub LetClear
            RXDATA = SSPBUF         'should contain the number of data bytes
            High CS
            DataBytesRx0 = RXDATA & %00001111  'bits 0-3 contain the number of data bytes p.28
            IF DataBytesRx0 > 0 Then
                For i = 0 to DataBytesRx0 - 1        '(say data is 2, then 0 and 1)
                    Low cs
                        SSPBUF = 3
                        GoSub letclear
                        SSPBUF = (RXB0D0 + (RxBufferSub -1) * 16) + i     
                        GoSub letclear
                        SSPBUF = 0              'dummy clock
                        GoSub letclear
                        RXDATA = SSPBUF         'should be real mcp2510 can controller data!!!
                    High cs
                    CanDataRx0[i] = RXDATA
                Next
            EndIF
            Low CS
                SSPBUF = 3          'read
                GoSub letclear
                SSPBUF = RXB0SIDH + (RxBufferSub -1) * 16   'high identifier
                gosub letclear
                SSPBUF = 0          'clock spi
                gosub letclear
                RXDATA = SSPBUF     'identifier
            high CS
            CanRxIDHigh0 = SSPBUF
            Low CS
                SSPBUF = 3          'read
                GoSub letclear
                SSPBUF = RXB0SIDL + (RxBufferSub -1) * 16   'low identifier
                gosub letclear
                SSPBUF = 0          'clock spi
                gosub letclear
                RXDATA = SSPBUF     'identifier
            high CS
            CanRxIDLow0 = SSPBUF
            
            'now, clear the buffer!
            'use bit modify...
        	Low CS
        		SSPBUF = %00000101		'bit modify command
        		GoSub letclear
        		SSPBUF = CANINTF		'mcp2510 can controller interrupt flags
        		GoSub letclear
	            SSPBUF = RxBufferSub		'mask for buffer number n
        		GoSub letclear
        		SSPBUF = %00000000		'clock in a clear bit
        		GoSub letclear
        	High CS
return
ReceiveCanSub1:
            Low CS
            SSPBUF = 3               'read
            GoSub letclear
            SSPBUF = RXB0DLC + (RxBufferSub -1) * 16      'receive buffer of data bytes offset 16
            GoSub letclear
            SSPBUF = 0              'dummy clock it
            GoSub LetClear
            RXDATA = SSPBUF         'should contain the number of data bytes
            High CS
            DataBytesRx1 = RXDATA & %00001111  'bits 0-3 contain the number of data bytes p.53
            IF DataBytesRx1 > 0 Then
                For i = 0 to DataBytesRx1 - 1        '(say data is 2, then 0 and 1)
                    Low cs
                        SSPBUF = 3
                        GoSub letclear
                        SSPBUF = (RXB0D0 + (RxBufferSub -1) * 16) + i     
                        GoSub letclear
                        SSPBUF = 0              'dummy clock
                        GoSub letclear
                        RXDATA = SSPBUF         'should be real mcp2510 can controller data!!!
                    High cs
                    CanDataRx1[i] = RXDATA
                Next
            EndIF
            Low CS
                SSPBUF = 3          'read
                GoSub letclear
                SSPBUF = RXB0SIDH + (RxBufferSub -1) * 16   'high identifier
                gosub letclear
                SSPBUF = 0          'clock spi
                gosub letclear
                RXDATA = SSPBUF     'identifier
            high CS
            CanRxIDHigh1 = SSPBUF
            Low CS
                SSPBUF = 3          'read
                GoSub letclear
                SSPBUF = RXB0SIDL + (RxBufferSub -1) * 16   'low identifier
                gosub letclear
                SSPBUF = 0          'clock spi
                gosub letclear
                RXDATA = SSPBUF     'identifier
            high CS
            CanRxIDLow1 = SSPBUF

            'now, clear the buffer!
            'use bit modify...
        	Low CS
        		SSPBUF = %00000101		'bit modify command
        		GoSub letclear
        		SSPBUF = CANINTF		'mcp2510 can controller interrupt flags
        		GoSub letclear
	            SSPBUF = RxBufferSub		'mask for buffer number n
        		GoSub letclear
        		SSPBUF = %00000000		'clock in a clear bit
        		GoSub letclear
        	High CS
return
