' Differential thermostat


temperature VAR	WORD			' Temperature storage
count_remain VAR BYTE			' Count remaining
count_per_c VAR	BYTE			' Count per degree C
temperapanel VAR WORD			' Panel temperature storage
count_rempan VAR BYTE
count_per_cpan VAR BYTE
DQ	VAR PORTA.4			' One-wire data pin for boiler
DP  VAR PORTA.5			' One-wire data pin for panel*
delta VAR WORD		    ' Delta T btwn Panel & Boiler to start pump

' Define LCD registers and bits
        DEFINE LCD_DREG     PORTB  
        
        DEFINE LCD_DBIT     4      
        DEFINE LCD_RSREG    PORTA
        
        DEFINE LCD_RSBIT    2
        
        DEFINE LCD_EREG     PORTA
        
        DEFINE LCD_EBIT     1
        
        DEFINE LCD_BITS     4 
               
        DEFINE LCD_LINES    2
        
        DEFINE LCD_COMMANDUS 2000
        
        DEFINE LCD_DATAUS 50


	ADCON1 = 7			' Set PORTA and PORTE to digital
	LCDOut $fe, 1, "Diff. Thermostat"
    
	Pause 3000
	delta = 700     ' DEFAULT T DIFFERENCE AT WHICH PUMP STARTS
	
mainloop:    IF PORTA.3 = 0 Then pressed ' CHECK IF TEMPERATURE DIFFERENCE
                                         ' BUTTON IS PRESSED

    OWOut DQ, 1, [$CC, $44]       ' Start temperature conversion

waitloop: OWIn DQ, 4, [count_remain]	' Check for still busy converting
	IF count_remain = 0 Then waitloop

	OWOut DQ, 1, [$CC, $BE]		' Read the temperature
        OWIn DQ, 0, [temperature.LOWBYTE, temperature.HIGHBYTE, Skip 4, count_remain, count_per_c]

	' Calculate temperature in degrees C to 2 decimal places (not valid for negative temperature)
	temperature = (((temperature >> 1) * 100) - 25) + (((count_per_c - count_remain) * 100) / count_per_c)
	LCDOut $fe, 1, DEC (temperature / 100), ".", DEC1 temperature, "C Boiler"
		

	OWOut DP, 1, [$CC, $44]        ' Start temperature conversion
waitloop2:	OWIn DP, 4, [count_rempan]	' Check for still busy converting
	IF count_rempan = 0 Then waitloop2

	OWOut DP, 1, [$CC, $BE]		   ' Read the temperature
        OWIn DP, 0, [temperapanel.LOWBYTE, temperapanel.HIGHBYTE, Skip 4, count_rempan, count_per_cpan]

	' Calculate temperature in degrees C to 2 decimal places (not valid for negative temperature)
	temperapanel = (((temperapanel >> 1) * 100) - 25) + (((count_per_cpan - count_rempan) * 100) / count_per_cpan)
	LCDOut $fe, $c0, DEC (temperapanel / 100), ".", DEC1 temperapanel, "C Panel"

    Pause 3000                      ' Display about once every 3 seconds
    
    IF temperapanel < 1800 Then mainloop    'Less than 18C? Pump stays off
        
    IF temperapanel > (temperature + delta) Then   'Checks T diff. for the pump to start (default 7C)
        
    High PORTC.4           'Start pump   
    EndIF
    IF PORTC.4 Then				'Check for PORTC pin 4 high
    LCDOut $fe,$c0+4, " h2o PUMPING"  'It's high so pump is on
    EndIF   
    IF temperapanel < (temperature +300)  Then  'Checks if T difference < 3C    
    Low PORTC.4			'Stop pump
    EndIF   
    Pause 3000                  ' Refresh time =~3 seconds    
	GoTo mainloop			        ' Do it forever
	End
	
	
pressed: Pause 30    'debounce
     IF PORTA.3 = 0 Then	setdelta   'IF STILL PRESSED GO TO SETDELTA
setdelta:	For delta = 700 TO 2000 STEP 100         '  STEP SIZE 1C
	 LCDOut $fe, 1, "Delta ", delta    'CLEAR LCD AND DISPLAY DELTA VALUE
	 Pause 3000
	 IF PORTA.3 = 1 Then mainloop      'if not pressed go to mainloop
		Next delta
		GoTo setdelta
	 
