; ***************************************
; * Proximity kaart 2 RS-232 vahengu   *
; * felc@edu.ttu.ee					    *
; * viimane bugfix: 21.1.2004			*
; * enable otca tegemine 19.3.2004		*
; ***************************************    
	INCLUDE "P12F629.inc"
; ***** Definitions ***** 
; ***** constants *******
#define MaxBits		1ah							; niimitut bitti ootame
#define MaxBytes	4							; niimitut baiti ootame
#define T1timeL		0CFh
#define T1timeH		40h;8A
; ***** Hardware ******** 
#define Dat0			GPIO,5					; Wiegandi D0 juhe (RF-10 lugejal roheline)
#define Dat1	      	GPIO,4	                ; Wiegandi D1 juhe (RF-10 lugejal valge)
#define	RS232_TX		GPIO,0					; Daata vlja
#define	enable			GPIO,1					; info vljastamise lubamine (kui 1)
; ***** various flags ***
#define	pulss			flags,2					; 1 kui pulss algas/kestab
#define	viga			flags,0					; 1 kui aega linud le 30mS aga bitid pole kohal
#define dataok		    flags,1                 ; 1 kui 26 bitti vastu vetud
#define CARRY           STATUS,C 
#define ZERO            STATUS,Z 


; ***** RESET *****          
				org     0000h  
 	__CONFIG _INTRC_OSC_NOCLKOUT & _PWRTE_ON & _BODEN_ON & _MCLRE_OFF & _WDT_OFF & _CP_OFF & _CPD_OFF   
	
; ***** Variables Definitions *****    
RAMbase         equ     20h            
	cblock  	RAMbase                 
				flags                 
				temp0                 
				temp1                 
				temp2                 
				temp3 
				tmp
				baitcount
				bitcount
				H_byte
				L_byte
				R0
				R1
				R2
				count
				temp
		endc 
Reset         
				goto    Main_Start       		; Alustame siis...
; ***** INTERRUPT *****  
; *************************************************************
; * T1 loeb pulsside kestust. >30mS => viga, lipp psti		  *
; *************************************************************
Interrupt         
				org     0004h 
Push;    		movwf   W_Temp           		; Save W         
;				swapf   STATUS,W         
;				movwf   S_Temp           		; Save STATUS         
				bcf     STATUS,RP0      		; Select Bank 0 
Disable_Int         	
				bcf     INTCON,GIE       		; keela katckestused        
				btfsc   INTCON,GIE       		       
				goto    Disable_Int      		
         
				btfsc   PIR1,TMR1IF      		; Taimer1 (pulsiseeria pikkus)?         
				goto    Timer_Int        		; jah, anna viga
				btfsc	INTCON,GPIF				; mingi daataots liigutas ennast?
				goto	daatatuleb				; jepp
Pop     			
;				swapf   S_Temp,W         
;				movwf   STATUS           		; Return STATUS         
;				swapf   W_Temp,F         
;				swapf   W_Temp,W         		; Return W         
				retfie                   		; vlja siit, jta intsid lubatux (GIE  !)

; ***** GPIF datasisendite Interrupt *****  
daatatuleb
				bsf		T1CON,TMR1ON			; taimer 1 paketi kestust valvama
				btfss	Dat0					; daata 0 liigutas?
				goto	data0					; ttle 
; **** data 1 liigutas ****
				btfss	Dat1					; daata 1 liigutas?
				goto	data1					; ttle
				bcf		pulss					; pulss lppes
				movlw	0						; 8 bitti tehtud?
				subwf	count
				btfsc	ZERO
				goto	data6
				decf	count					; ei, vhenda
				goto	data7
data6
				movlw	7						; jah, taasta count
				movwf	count
				decf	baitcount
data7	
				decfsz	bitcount
				goto	data9
data8
				bsf		dataok					; valmis!
				bcf		CARRY
				rlf		temp3,1					; korrigeerib viimast baiti
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				rlf		temp3,1
				
data9								
				movf	GPIO,W					; read port to reset int condition
				bcf		INTCON,GPIF
				goto 	Pop
; **** data 0 ots liigutas ****
data0
				btfss	pulss					; pulss kestab vi alles algas ?
				goto	data0a
				goto	data9
data0a
				bcf		CARRY					; saime nulli
data0b
				bsf		pulss					; pulss algas
; **** kirjutab dataflagis oleva pulsi mllu ****
				swapf   STATUS,W         
				movwf   tmp           			; seivi bitt      
				movlw   d'4'           			; kuhu kirjutame        
				subwf   baitcount,W  
				btfss   ZERO 
				goto	data3a
				swapf   tmp,W         
				movwf   STATUS           		; taasta STATUS         
           	    rlf		temp0,1
				goto	data3d
data3a			movlw   d'3'           			
				subwf   baitcount,W  
				btfss   ZERO            	      
				goto	data3b
				swapf   tmp,W         
				movwf   STATUS           		; taasta STATUS         
				rlf		temp1,1
				goto	data3d
data3b			movlw   d'2'           			
				subwf   baitcount,W  
				btfss   ZERO            	      
				goto	data3c
				swapf   tmp,W         
				movwf   STATUS           		; taasta STATUS         
				rlf		temp2,1
				goto	data3d
data3c			movlw   d'1'           			
				subwf   baitcount,W  
				btfss   ZERO            	      
				goto	data3d
				swapf   tmp,W         
				movwf   STATUS           		; taasta STATUS         
				rlf		temp3,1
data3d
				goto	data9					; oota uut pulssi
; **** data 1 ots liigutas ****
data1
				btfss	pulss					; pulss kestab vi algas
				goto	data1a
				goto	data9
data1a
				bsf		CARRY					; saime he
				goto	data0b					; kirjuta

; **** aeg sai otsa aga pulsse ikka pole (kiki)				
Timer_Int                                            
				bcf     STATUS,RP0      		; pank 0		 
				bcf		T1CON,TMR1ON			; stop taimer 1
				bcf     PIR1,T1IF    			; katkestuse nue maha   
				bsf		viga        			; vea lipp psti
				bsf     STATUS,RP0      		; pank 1		 
 				bcf     PIE1,T1IE 	    		; keela Timer1 Interruptsid
				bcf     STATUS,RP0      		; pank 0		 
				goto	Pop
   
; ************************* 
; ***** Main Program ****** 
; *************************  
Main_Start         
				call	Init					; majapidamine korda
main_loop         
				btfsc	viga					; kik ok?
				goto	Main_Start				; siis tmba vesi peale
				btfss	dataok					; kaart loetud?
				goto	main_loop				; siis tmba ikkagi vesi peale
;				call	process					; tee kaardi numbriks
;				call	convert					; tee BCD-ks
;				call	bcd2ASCII				; tee ASCII-ks
main_wait		btfss	enable					; kas meil lubatakse sna vtta?
				goto	main_wait				; oota luba
				call	send_rs232				; saada baidid teele
;				bcf		test
				call	Dly
				call	Dly
;				bsf		test
				goto	Main_Start				; jlle vesi peale...
; *************************  

Init          
; **** kalibreeri sisemine gener ****
				bsf     STATUS,RP0      		 
				call 	3FFh 					
				movwf 	OSCCAL 					; Kalibreeri sisemine taktigene
; **** taimerid ****
				bcf     STATUS,RP0      		; pank 0 
				bcf     INTCON,T0IE     		; keela Timer0 Interruptsid
				bcf     INTCON,T0IF            
				bcf		T1CON,TMR1ON			; stop taimer 1
				bsf     STATUS,RP0      		; pank 1
 				bcf     PIE1,T1IE 	    		; keela Timer1 Interruptsid
				bcf     STATUS,RP0      		; pank 0
				bcf     PIR1,T1IF    		
				movlw	T1timeL					; lae T1
				movwf	TMR1L
				movlw	T1timeH
				movwf	TMR1H
; **** EDT-d ei pruugi **** 
				clrwdt                    		; WDT nullida 
; **** konf ****
				bsf     STATUS,RP0      		; pank 1 
				movlw   b'00000000'         
				movwf   OPTION_REG      		; 1:1 prescaler T0-le, sisemine takt, WPU lubatud 
; **** pordid ****
				bcf     STATUS,RP0      		; pank 0 
				clrf	GPIO					; pordid nulli
				movlw 	07h 					; analoog komparaator vlja
				movwf 	CMCON 
				bsf     STATUS,RP0      		; pank 1 
				movlw	3Ch						; GP0 vljund, muud sisendid (1 ka)
				movwf 	TRISIO 
				movlw	3Eh						; WPU-d
				movwf	WPU
				movlw	30h						; int on change kaardilugeja otstele
				movwf	IOCB
				bcf     STATUS,RP0      		; pank 0 
				movlw	3Dh						; port sellisesse lhteseisu
				movwf 	GPIO 
; **** variaablid ****
				movlw	0
				movwf	temp0	      		
				movwf	temp1	      		
				movwf	temp2	      		
				movwf	temp3
				movlw	MaxBits	      		
				movwf	bitcount
				movlw	MaxBytes
				movwf	baitcount
				movlw	7
				movwf	count
				bcf		viga
				bcf		dataok	      		
; **** katkestused ****
				bsf		INTCON,PEIE				; luba peripheral ints
				bcf		INTCON,T0IE				; clear int. flags
				movf	GPIO,W					; read port to reset int condition
				bcf		INTCON,GPIF				; port change flag
				bsf		INTCON,GPIE				; enable port on change int
; **** Timer 1 ****
				movlw	b'00000100'				; 1/1 prescaler, int osc, seisma
				movwf	T1CON
				bcf		PIR1,TMR1IF				; letit. lipp
				bsf     STATUS,RP0      		; pank 1 
				bsf		PIE1,TMR1IE				; luba T1 int
				bcf     STATUS,RP0      		; pank 0 
; **** lubame intsid ****
				bsf     INTCON,GIE        		; Enable Interrupts Global 
    			return  

; ***** tee temp0...temp3 kaardi numbrikse *****  
process         								; esiteks teisendame saadud joru igeks binary koodiks
				bcf		CARRY					; valmistume 1. baidi lugemiseks
				rlf		temp0,1					; viskame EVEN paarsuse biti le parda
				bcf		CARRY					; valmistume 2. baidi lugemiseks
				rlf		temp1,1					; jlle nihe
				btfsc	CARRY					; kas temp0-i tuleb 1 vi 0 ?
				bsf		temp0,0					; oli 1
				bcf		CARRY					; nii vi naa, jtkame 3.baidiga
				rlf		temp2,1					; jlle nihe
				btfsc	CARRY					; kas temp1-i tuleb 1 vi 0 ?
				bsf		temp1,0					; oli 1
				bcf		CARRY					; jtkame 4.baidiga
				rlf		temp3,1					; nihe...
				btfsc	CARRY					; kas temp2-i tuleb 1 vi 0 ?
				bsf		temp2,0					; oli 1
				return
;binary number olemas (temp1 ja temp2), teeme BCDks
convert
				movf	temp1,W
				movwf	H_byte
				movf	temp2,W
				movwf	L_byte
B2_BCD 
				bcf 	STATUS,0 ; clear the carry bit
				movlw 	.16
				movwf 	count
				clrf 	R0
				clrf 	R1
				clrf 	R2
loop16 			rlf 	L_byte, F
				rlf 	H_byte, F
				rlf 	R2, F
				rlf 	R1, F
				rlf 	R0, F
				decfsz 	count, F
				goto 	adjDEC
				return;
adjDEC 			
				movlw 	R2
				movwf 	FSR
				call 	adjBCD

				movlw 	R1
				movwf 	FSR
				call 	adjBCD
				movlw 	R0
				movwf 	FSR
				call 	adjBCD
				goto 	loop16

adjBCD 			
				movlw 	3
				addwf 	0,W
				movwf 	temp
				btfsc 	temp,3 ; test if result > 7
				movwf 	0
				movlw 	30
				addwf 	0,W
				movwf 	temp
				btfsc 	temp,7 ; test if result > 7
				movwf 	0 ; save as MSD
				return;
bcd2ASCII
				movf	R1,W		;seivime
				movwf	temp
				swapf	R1,R1		; nihuta
				movlw	0Fh
				andwf	R1,F
				movlw	30h
				addwf	R1,F
				movf	R1,W		; seivime puhvrisse
				movwf	temp0		; 1.bait ASCIIs
				movf	temp,W
				movwf	R1			; taasta
				movlw	0Fh
				andwf	R1,F
				movlw	30h
				addwf	R1,W
				movwf	temp1		; 2.bait ASCIIs

				movf	R2,W		;seivime
				movwf	temp
				swapf	R2,F		; nihuta
				movlw	0Fh
				andwf	R2,F
				movlw	30h
				addwf	R2,W
				movwf	temp2		; 1.bait ASCIIs
				movf	temp,W
				movwf	R2			; taasta
				movlw	0Fh
				andwf	R2,F
				movlw	30h
				addwf	R2,W
				movwf	temp3		; 2.bait ASCIIs		
				return
; ***** saada temp0...temp3 RS232-e *****  
send_rs232         
				movlw	'I'
				call	senddata
				movlw	'D'
				call	senddata
				movlw	' '
				call	senddata
				movf	temp0,W
				call	senddata
				movf	temp1,W
				call	senddata
				movf	temp2,W
				call	senddata
				movf	temp3,W
				call	senddata
				movlw	0Dh
				call	senddata
				return  

; ***** RS232: Saada W porti GP0 *****  
senddata         
				movwf   tmp         
;				SEL_BANK_1         
;				bcf     TRISB,3         		; Set port B3 to output         
;				SEL_BANK_0   
;       
				movlw   08h         
				movwf   bitcount     			; 8 Bitti
          
				bcf     RS232_TX        		;  Start Bit         
				call    Wait_Bit  

Send_RS232_Loop         
				btfsc   tmp,0         
				goto    RS232_TX_1         
				goto    RS232_TX_0  

RS232_TX_1         
				bsf     RS232_TX         
				goto    RS232_Cont  
RS232_TX_0         
				bcf     RS232_TX         
				goto    RS232_Cont  
RS232_Cont         
				call    Wait_Bit         
				rrf     tmp,1         
				decfsz  bitcount,1         
				goto    Send_RS232_Loop          

				bsf     RS232_TX         
				call    Wait_Bit          
				return 
; ***** Wiide *****  
Dly
				movlw	0FFh
				movwf	bitcount
dly1
				call	Wait_Bit
				decfsz	bitcount,1
				goto	dly1
				return
Wait_Bit         
				movlw   d'65'         
				movwf   count 
W196u_Loop         
				decfsz  count,1   				; 1         
				goto 	W196u_Loop         		; 2         
				return  


; ***** Reset 12F629 *****          
				org     01FFh         
				goto    Reset					; taassnd...         

				org		03FFh
				retlw	b'0011111'				; dummy OSCCAL
	END  
