; *******************************************************************
; ************* Bootloader MMC-kaardilt  ****************************
; **** ttab FAT16 failissteemiga ja ainult juurkataloogis ********
; Ftakt=8MHz, kordistatud PICi sisemise PLLiga 32MHz-ni.*************

; kood asub aadressil 0x7000 ja lespoole. Loader seda ala EI puutu. Ka siis kui laetav hex-fail tahaks sinna kirjutada 
; Voolukatkestuste ja vigade puhul siseneda "errorloader" rutiini. **
; See teeb kaardile INITi ja laeb faili "CODExxxx.HEX (case unsensitive). xxxx asemel vib olla mis iganes, muu osa nimest on KOHUSTUSLIK!
; Rutiin "bootloader" laeb ja flshib faili kivisse.Vljakutseks peab olema eelnevalt loetud kettalt sobiv fail ja saadud tema parameetrid 
; (seda teeb errorloader).
; Kasutamine:
; aadressile 0x0000 kirjuta "goto errorloader". Laetakse ja flshitakse fail codexxxx.hex.
; aadressil 0x0000  on tavaline "goto minu_koodi_algus". Oma koodist kutsu bootloaderit, andes ette puhvrisse FileName vajaliku faili kataloogikirje 
; (kik 32 baiti nagu kettalt lugemisel). Kuidas tpselt? Vaata errorloaderi koodi! MMC-kaart peab olema initi teinud!
; Errorloader paneb ise 0x0000-le goto errorloader ja alles flshimise eduka lppemise puhul kirjutab esimesed 64 baiti igeks.
; Voolukatkestuste vi kaardi kadumise (!) puhul jb "goto errorloader" alles ja kui ige failiga kaart masinasse satub, tehakse flshiumine
; automaatselt.
; >>> kik kommentaarid, soovitused ja bug reportid -> felch@staff.ttu.ee <<<<<<<<<<
;***************************************************************************************************************************************
; * this code is FREE for everybody for every LEGAL purpose. Parts or full version, no matter! 
; For stupid ones: NO WARRANTY whatsoever!!! If u can't understand it, take a coke (may-be some drugs also) and fuck off!
;***************************************************************************************************************************************
; Prose
  						LIST P=18F452
  						errorlevel 0,-305,-302
  						INCLUDE "P18F452.inc"
;**** Prose konfi (ropud :) snad ****
;Program Configuration Register 1H
		__CONFIG    _CONFIG1H, _OSCS_OFF_1H & _HSPLL_OSC_1H
;Program Configuration Register 1H
;		__CONFIG    _CONFIG1H, _OSCS_OFF_1H & _HS_OSC_1H
;Program Configuration Register 2L
		__CONFIG    _CONFIG2L, _BOR_OFF_2L & _BORV_42_2L & _PWRT_ON_2L
;Program Configuration Register 2H
		__CONFIG    _CONFIG2H, _WDT_OFF_2H & _WDTPS_128_2H
;Program Configuration Register 3H
		__CONFIG    _CONFIG3H, _CCP2MX_OFF_3H
;Program Configuration Register 4L
		__CONFIG    _CONFIG4L, _STVR_ON_4L & _DEBUG_OFF_4L & _LVP_OFF_4L	
; ****************************************************************************************************************
; ***************************** DEFINITSIOONID *******************************************************************
; ****************************************************************************************************************
; ***************************** MMC *************************************************************************** 
;MMC_DATA				EQU	PORTC				; MMS-kaardi siin
#define CCS		      	PORTC,2	                ; kiip select
#define	CDIN			PORTC,5					; daata in (kaarti)
#define CCLK	      	PORTC,3	                ; takt
#define	CDOUT			PORTC,4					; daata out (kaardist)
#define CDI		      	PORTA,0	                ; kaart sees = LOW

#define	T3resoH				0x27				; 10mS @ 32 MHz 
#define	T3resoL				0xBF			

#define	CCS_passive		flags1,0			; kui 1, jb MC-kaart valituks (CS=0) peale ksu andmist (lugemine!)
#define viga			flags1,1
#define nofiles         flags1,2            	; faile pole (thi ketas)
#define	lastfile		flags1,3
#define	notfound		flags1,4

#define CARRY           STATUS,C 
#define ZERO            STATUS,Z 
#define	CSave			SSave,0

;*** ainult flashimise ajal kasutatavad lipud ***
#define row				flags1,5				; hex-faili rea algus leitud
#define upperr			flags1,6
#define adrh			flags6,0
#define adrl			flags6,1				; 
#define bcnt			flags6,2
#define packet			flags6,3				; 
#define datah			flags6,4
#define chk				flags6,5				; 
#define eeprom			flags6,6				; viimased 2 PEAVAD olema sel kohal (aga vib omavahel vahetada)
#define conf			flags6,7				; 
; *************************************************************************************************************
; ***************************** Mlu jaotus *******************************************************************
; *************************************************************************************************************
RAMbase         equ     00h            
	cblock  	RAMbase
;*** MMC kaart ***
				lba0							; meedia adresseerimise LBA-baidid
				lba1
				lba2
				lba3
				dlba0
				dlba1
				dlba2
				dlba3
				DATA_LO							; sektorist loetav sna/MMC-ksk (HI) ja CRC (LO)
				DATA_HI	
				StartSec_H						; volume boot recordi algus-sektor	
				StartSec_L		
				BPSec_H							; baiti sektoris
				BPSec_L				
				SPClust							; baiti sektorit klastris
				ResSec_H						; reserveeritud sektoreid
				ResSec_L	
				CopFat							; FATi koopiaid
				MaxRent_H						; max. root entries
				MaxRent_L
				SectFat_H						; sektoreid FATis
				SectFat_L
				FatStart_L
				FatStart_H
				DataSec_H
				DataSec_L
				tempor1_l
				tempor1_h
				tempor0_l
				tempor0_h
				abi_L
				abi_H
				rsp								; kaardilt oodatav vastus
				mmc_cnt
				temp
				seccount
				file_numH						; jooksva faili number kettal
				file_numL
;*** kaardi matemaatika ***
				COUNTER_LO
				COUNTER_HI 
				Dividend
				Dividend1
				Divisor
				Divisor1
				Quotient
				Quotient1
				Count
				Count1
				Multiplicand
				Multiplicand1
				Multiplier
				Multiplier1
				Product
				Product1
				up_per							; ka ListDir'i matemaatikas (file_num vrdluses)
				lower
;*** ssteem ***
				flags1
				flags6
				W_Temp							; W ja Status'e seivi registrid (katkestuse ajaks)
				S_Temp
				lath_tmp
				lath_tmp1
				count
;*** valitud/valitava faili andmed ***
                File_Name:.26                   ; faili nimi ja muu pudi
				StartClust_L
				StartClust_H					; faili algusclusteri nr.
				F_Size_3						; faili pikkus baitides, LSB
				F_Size_2						
				F_Size_1
				F_Size_0						; MSB
;*** Flashimine ***
				Baidiloendi
				PacketType
				FlashCnt
				Chartmp
				Chartmp1
				ChkSum
	endc
	cblock		0x100
				SectorBuf						; sektor salvestatakse siia
	endc
	cblock 0x300
				Line1Buf:						; displei formaati konverditud teksti puhver
												; bootloader kasutab sellest 64 baiti
	endc
;*************************************************************************************************************
; ***************************** Reset - algus *****************************************************************
; *************************************************************************************************************
				org     0x0000 				
				goto    main		       		; Alustame siis...
;				goto	errorloader				; kui tahame startida kettalt flshimist
; *************************************************************************************************************
; ************************ KATSKESTUSED ***********************************************************************
; *************************************************************************************************************
Interruptsid:   org     0x000008 
_Push:    		movwf   W_Temp           		; Seivi kontekst        
				swapf   STATUS,W         
				movwf   S_Temp     
         		movf	PCLATH,W
				movwf	lath_tmp1
				clrf	PCLATH

; kirjuta siia oma kood kui vaja

_Pop:      		movf	lath_tmp1,W
				movwf	PCLATH
				swapf   S_Temp,W         
				movwf   STATUS           		; taasta STATUS         
				swapf   W_Temp,F         
				swapf   W_Temp,W         		; ja W         
				retfie                   		; vlja siit, jta intsid lubatux (GIE  !)
; *************************************************************************************************************
; ************************ MAIN *******************************************************************************
; *************************************************************************************************************
main:
	; minu koodi kokku jooksutamine... ;)

; *************************************************************************************************************
; ******************************* Bootloader ******************************************************************
; *************************************************************************************************************
				org 0x7000 						; kutsutakse etteantud faili parameetritega (puhver File_Name)
bootloader:		call	erase_flsh				; kustuta vana kood FLASHist. Nd on pael kui uut koodi peale ei saa...
bldr_0:			bcf		row						; nulli muutujad
				bcf		upperr
				clrf	flags6
				movlw	.8						; kirjutame 8 baidi kaupa, esimene on alati 0x0c, teine vajalik kood jne
				movwf	FlashCnt
				LFSR	.2,Line1Buf+.32				; siia 8 esimest koodibaiti mida flahib alles siis kui muu kirjutamine edukas		
; ****** loe kettalt ja kirjuta FLASHi ***********
				call	erase_flsh				; kigepealt kustuta vana kood
				movlw	UPPER bldr_err_rec		; vea puhul kirjutame RESET vektorile "goto errorloader" ja... saabast!
				movwf	TBLPTRU
				movlw	HIGH bldr_err_rec
				movwf	TBLPTRH
				movlw	LOW bldr_err_rec
				movwf	TBLPTRL
				movlw	.4
				movwf	Count					; 4 baiti lugeda
				LFSR	.0,SectorBuf			; kopime esmalt goto ksu RAMi (meil on ainult 1 TBLPTR ! )
bldr_err1:		TBLRD*+
				movff	TABLAT,POSTINC0
				decfsz	Count
				goto	bldr_err1
				clrf	TBLPTRU					; koodi poetab reset-vektori aadressile
				clrf	TBLPTRH
				clrf	TBLPTRL
				movlw	.8
				movwf	Count					; 4 baiti kirjutada, lejnud 4 on saast aga flashi saab kirjutada vaid 8 baidi kaupa.
				LFSR	.0,SectorBuf			
bldr_err2:		movff	POSTINC0,TABLAT
				TBLWT*+
				decfsz	Count
				goto	bldr_err2
				TBLRD*-
				call	bwr_flsh2
				goto	bldr_1

bldr_err:		reset							; vea puhul tmbab julmalt vee peale !

bldr_err_rec:	goto	errorloader				; kopeeritav kirje

bldr_1:			movff	StartClust_L,abi_L		; algusclusteri nr. meelde jtta
				movff	StartClust_H,abi_H
				movff	SPClust,seccount		; sektoreid clusteris
				call	bfind_sector			; leia vastav sektor -> lba2, lba3
				movff	StartClust_L,abi_L		; taasta abi_L ja abi_H
				movff	StartClust_H,abi_H
bldr_2:			movff	dlba0,lba0
				movff	dlba1,lba1
				movff	dlba2,lba2
				movff	dlba3,lba3
				call	bMMC_get_sect			; lae sektor -> SectorBuf
				btfsc	viga
				goto	bldr_err				; ERROR !				
bldr_3:			movf	POSTINC0,W				; loe 1 bait
				movwf	Chartmp
				sublw	0x0A					; oli NEW LINE ?
				btfsc	ZERO
				goto	bldr_4					; siis unusta ra
				movf	Chartmp,W
				sublw	0x0D					; oli CR ?
				btfsc	ZERO
				goto	bldr_3a					; uus rida algas, nulli muutujad
				movf	Chartmp,W
				sublw	':'						; oli rea algus ?
				btfss	ZERO
				goto	bldr_3c					; ei, vaata edasi
				bsf		row						; rea algus leitud !
				clrf	ChkSum					; nulli kontrollsumma
				goto	bldr_3b					; nulli muud muutujad
bldr_3c:		btfss	row						; rea algus kes ?
				goto	bldr_4					; siis unusta ra
				btfsc	datah					; esimene ASCII-mrk baidi kujutises ?
				goto	bldr_3d					; ei
				bsf		datah					; mrgi ra
				movf	Chartmp,W				
        		addlw   0xbf            ;add -'A' to Ascii high byte
        		btfss   STATUS,C        ;check if positive
        		addlw   0x07            ;if not, add 17 ('0' to '9')
        		addlw   0x0a            ;else add 10 ('A' to 'F') 
        		movwf   Chartmp         ;save nibble
       			swapf   Chartmp,W       ;move nibble to high position
				movwf	Chartmp1
				goto	bldr_4
bldr_3d:		bcf		datah					; on 2. ASCII-mrk baidi kujutises
				movf	Chartmp,W				
        		addlw   0xbf            ;add -'A' to Ascii low byte
        		btfss   STATUS,C        ;check if positive
        		addlw   0x07            ;if not, add 17 ('0' to '9')
        		addlw   0x0a            ;else add 10 ('A' to 'F') 
        		iorwf   Chartmp1,F       ;add low nibble to high nibble
        		movf    Chartmp1,W       ;put result in W reg
				btfsc	chk						; sai kontrollsumma ?
				goto	bldr_3p					; jah, kontrolli seda
				movf	Chartmp1,W
				addwf	ChkSum,F				; reabait, cheksummeeri
				btfsc	bcnt					; sai baitide arvu ?
				goto	bldr_3e
				bsf		bcnt					; mrgi ra
				movf	Chartmp1,W				; ei lase le 0x1F-i
				andlw	0x1F
				movwf	Baidiloendi				; ja seivi edaspidiseks
				goto	bldr_4
bldr_3e:		btfsc	adrh					; sai kirjutatava aadressi MSB ?
				goto	bldr_3f
				bsf		adrh					; mrgi ra
				movff	Chartmp1,TBLPTRH		; ja seivi
				goto	bldr_4
bldr_3f:		btfsc	adrl					; sai kirjutatava aadressi LSB ?
				goto	bldr_3g
				bsf		adrl					; mrgi ra
				movff	Chartmp1,TBLPTRL		; ja seivi
				TBLRD*-							; samm tagasi
				goto	bldr_4
bldr_3g:		btfsc	packet					; sai rea tbi numbri ?
				goto	bldr_3h
				bsf		packet					; mrgi ra
				movff	Chartmp1,PacketType		; seivi
				decf	PacketType,W			; tp 0 thendab filee lppu
				btfsc	ZERO
				goto	bldr_8					; kik, aitab! Persse nd...
				sublw	0x01
				btfsc	ZERO
				goto	bldr_err				; reatpi 2 ei tohiks olla -> viga !!!
				goto	bldr_4
bldr_3h:		movf	PacketType,W			; rida 4 ehk laaadressi ette andmine ?
				sublw	0x04
				btfss	ZERO
				goto	bldr_3m
				btfsc	upperr					; sai aadressi MSB ?
				goto	bldr_3j
				bsf		upperr					; mrgi, et saime ja unustame kohe...
bldr_3i:		decfsz	Baidiloendi				; nutud baidid loetud ?
				goto	bldr_4					; vara veel
				bsf		chk						; jah, nd tuleb kontrollsumma
				goto	bldr_4					; seda ootama
bldr_3j:		bcf		upperr					; sai aadressi LSB. Seda on vaja !
				movf	Chartmp1,W				; kirjuta EEEPROMi ?
				sublw	0xF0
				btfss	ZERO	
				goto	bldr_3k
				bsf		eeprom					; eeprom nehh !
				bcf		conf
				movff	TBLPTRL,EEADR			; aadress oli meldud EEPROMi jaux
				goto	bldr_3i
bldr_3k:		movf	Chartmp1,W				; kirjuta konfibaidid ?
				sublw	0x30
				btfss	ZERO	
				goto	bldr_3l
				bcf		eeprom					; conf nehh !
				bsf		conf
				movff	Chartmp1,TBLPTRU		; siis oli see tabeli (flshi) UPPER pointer
				goto	bldr_3i
bldr_3l:		movff	Chartmp1,TBLPTRU		; oli lihtsalt FLASHi laadressi mramine,kirjuta UPPERisse
				bcf		eeprom					
				bcf		conf
				goto	bldr_3i
bldr_3m:		btfss	eeprom					; kirjutame EEPROMi ?
				goto	bldr_3n					; ei
				movff	Chartmp1,EEDATA			; jah, lkka registrisse
				call	bwr_eprom				; kirjuta 
				incf	EEADR,F					; nekst aadress
				movlw	.8						; lae loendi uuesti: kirjutame ikka 8 baidi kaupa
				movwf	FlashCnt
				goto	bldr_3i
bldr_3n:		movff	Chartmp1,TABLAT			; kirjuta registrisse
				TBLWT+*
				btfsc	conf					; konfibait vi tavaline ?
				goto	bldr_3o					
				movf	TBLPTRU,W				; tavaline bait, kui adr. 0-63, kirjuta @ FSR2 mitte flashi
				btfss	ZERO
				goto	bldr_3nn
				movf	TBLPTRH,W
				btfss	ZERO
				goto	bldr_3nn
				bcf		CARRY
				movf	TBLPTRL,W
				bcf		CARRY
				sublw	.63
				btfss	CARRY
				goto	bldr_3nn
;	movf FSR2H,W
;	call bs_rs_a
;	movf FSR2L,W
;	call bs_rs_a
				movf	Chartmp1,W
				movwf	POSTINC2
				decfsz	FlashCnt
				goto	bldr_3i
				movlw	.8						; lae loendi uuesti: kirjutame ikka 8 baidi kaupa
				movwf	FlashCnt
				goto	bldr_3i

bldr_3nn:		decfsz	FlashCnt				; pea arvet nende le
				goto	bldr_3i
bldr_3o:		call	bwr_flsh				; kui 8 baiti kogunenud, kirjuta FLASHi ra (v.a. esimesed 63)
				movlw	.8						; lae loendi uuesti: kirjutame ikka 8 baidi kaupa
				movwf	FlashCnt
				goto	bldr_3i
bldr_3p:		movf	Chartmp1,W
				addwf	ChkSum,F
				movf	ChkSum,W
				btfss	ZERO
				goto	bldr_err				; ERROR !				
				call	bldr_9					; oli OK, oota uut rida. Enne kirjuta 8 baiti tis kui tegemist flashiga ja FlashCnt><8
bldr_3a:		bcf		row						; rea algust enam ei ole
bldr_3b:		movf	flags6,W				; muid vidinaid ka mitte. Eeprom/conf bitte ei solgi !
				andlw	0xC0
				movwf	flags6
				bcf		upperr
bldr_4:			LFSR	.1,F_Size_3				; faili pikkus -1, LSB
				decf	INDF1,F
				btfsc	CARRY
				goto	bldr_5
				incf	FSR1L,F
				decf	INDF1,F
				btfsc	CARRY
				goto	bldr_5
				incf	FSR1L,F
				decf	INDF1,F
				btfsc	CARRY
				goto	bldr_5
				incf	FSR1L,F
				decf	INDF1,F

bldr_5:			LFSR	.1,F_Size_0				; kas kik (=0)? Alustame MSB-st
				movf	POSTDEC1,W				
				btfss	ZERO
				goto	bldr_6					; ei
				movf	POSTDEC1,W				
				btfss	ZERO
				goto	bldr_6					; ei
				movf	POSTDEC1,W				
				btfss	ZERO
				goto	bldr_6					; ei
				movf	POSTDEC1,W				
				btfss	ZERO
				goto	bldr_6					; ei
				goto	bldr_8					; jah, valmis: taasta eelnev txt kui vimalik
bldr_6:		;	bcf		CARRY
				movf	FSR0H,W					; sektor lbi loetud?
				sublw	HIGH Line1Buf
				btfss	ZERO
				goto	bldr_3					; ei, loe edasi!
				movf	FSR0L,W					
				sublw	LOW Line1Buf
				btfss	ZERO
				goto	bldr_3					; ei, loe edasi!
				decf	seccount,F				; seccount -1
				movf	seccount,W
				btfsc	ZERO					; =0?
				goto	bldr_7					; on 0, leia ja lae uus cluster
				bcf		CARRY
				movf	dlba3,W					; lae jrgmine sektor
				addlw	0x01
				movwf	dlba3
				btfss	CARRY
				goto	bldr_2					; tskelda edasi
				movf	dlba2,W
				addlw	0x01
				movwf	dlba2
				btfss	CARRY
				goto	bldr_2					; tskelda edasi
				movf	dlba1,W
				addlw	0x01
				movwf	dlba1
				btfss	CARRY
				goto	bldr_2					; tskelda edasi
				incf	dlba0,F
				goto	bldr_2					; tskelda edasi

bldr_7:
				call	bfind_fat_sec			; leia FATi sektor kus faili jrgmine sektor kirjas. Adresseeri see ja loe puhvrisse	
				btfsc	viga
				goto	bldr_err				; ERROR !				
				movf	abi_L,W					; eelmise clusteri aadress
				mullw	.2
				movf	PRODL,W
				addwf	FSR0L,F
				btfsc	CARRY
				incf	FSR0H,F
				movf	abi_H,W
				addwf	FSR0H,F					; indekseerib uue clusteri
				movff	POSTINC0,abi_L			; loe selle vrtus
				movff	POSTINC0,abi_H
				movff	abi_L,StartClust_L		; seivi startclusteriks
				movff	abi_H,StartClust_H
				goto	bldr_1					; ja jtka tegutsemist

bldr_8:			call	bldr_9
				clrf	TBLPTRU					; kirjutamine edukas, kustuta esimesed 64 baiti, milledest 4 esimset jumpisid bootloaderile
				clrf	TBLPTRH
				clrf	TBLPTRL
				movlw	0x94					; kirjuta FLASHi, luba kirjutamine ja row erase
				movwf	EECON1		
				MOVLW 	0x55					; lahtilukustamine
				MOVWF 	EECON2 	
				MOVLW 	0xAA
				MOVWF 	EECON2 
				BSF 	EECON1,WR 				; kustuta 64-baidine rida, prose hangub seniks.
				movlw	0x80					; keela kirjutamine FLASHi ja row erase
				movwf	EECON1

				clrf	TBLPTRU					; taasta laetava koodi 64 esimset baiti mis seni (@Line1Buf@FSR2) mlus redutavad
				clrf	TBLPTRH
				clrf	TBLPTRL
				LFSR	.2,Line1Buf+.32			; soorts siin
				movlw	.8
				movwf	Count1					; 64 baiti koodi alguse osa kirjutada
bldr_8b:		movlw	.8
				movwf	Count					; 8 baidi kaupa
bldr_8a:		movff	POSTINC2,TABLAT
				TBLWT*+
				decfsz	Count
				goto	bldr_8a
				TBLRD*-
				call	bwr_flsh2
				TBLRD*+
				decfsz	Count1
				goto	bldr_8b				
				reset							; nd sai vist kll valmis...

bldr_9:			btfsc	eeprom
				return
				btfsc	conf
				return
				movf	FlashCnt,W				; ainult tavakoodi puhul: kik 8 baiti kirjutatud ?
				sublw	.8
				btfsc	ZERO
				return

bldr_9a:		movf	TBLPTRU,W				; tida puuduv osa 8-st baidisest puhvrist 0xFF-ga.  
				btfss	ZERO
				goto	bldr_9b
				movf	TBLPTRH,W
				btfss	ZERO
				goto	bldr_9b
				movf	TBLPTRL,W
				bcf		CARRY
				sublw	.63
				btfss	CARRY
				goto	bldr_9b
bldr_9c:		movlw	0xFF					; Kui adr. 0-63, siis @FSR2 !
				movwf	POSTINC2
				TBLWT+*							; Dummi kirjutamine, kuna TBLPTR-i jrgi kontrollime mujal koodis kirjutamise kohta.
				decfsz	FlashCnt				
				goto	bldr_9c	
				movlw	.8
				movwf	FlashCnt			
				return							
;
bldr_9b:		movlw	0xFF					; tida puuduv osa 8-st baidisest puhvrist 0xFF-ga	
				movwf	TABLAT
				TBLWT+*
				decfsz	FlashCnt				; kuni tis
				goto	bldr_9b				
				call	bwr_flsh				; kirjuta FLASHi ra 
				return							; nd sai tsiselt siiber...
; *************************************************************************************************************
; *************************** kirjuta 8 baiti flashi **********************************************************
; *************************************************************************************************************
bwr_flsh:		movff	TBLPTRH,up_per			; kui TBLPTR >= bootloader'i aadress lahku palun otsekohe :) 
				movff	TBLPTRL,lower
				movf  	up_per,W	        	
  				sublw  	HIGH bootloader
  				movwf   temp                    ; Store in a Temporary Register
  				movf  	lower,W                 ; Get the Low Byte 
  				sublw  	LOW bootloader
  				btfss  	CARRY		            ; Decrement High if Necessary
   				decf  	temp
  				iorwf  	temp,w	                ; Check for Equal to Zero
  				btfsc   ZERO		            ; If Not Zero, Jump Over
   				goto  	bwr_flsh1	         	; TBLPTR=bootloader, mine siit ra
  				btfsc  	temp,7                  ; If Number is Negative, execute 
   				goto  	bwr_flsh1	          	; TBLPTR>bootloader, mine siit ra
bwr_flsh2:		movlw	0x84					; kirjuta FLASHi, luba kirjutamine
				movwf	EECON1		
				btfsc	conf					; konfibait vi tavaline ?
				bsf		EECON1,CFGS				; kirjutame knfi, siis bitt psti				
				MOVLW 	0x55					; lahtilukustamine
				MOVWF 	EECON2 	
				MOVLW 	0xAA
				MOVWF 	EECON2 
				BSF 	EECON1,WR 				; kirjuta 8 baiti, prose hangub seniks.
				nop
				movlw	0x80					; keela kirjutamine FLASHi ja row erase
				movwf	EECON1		
bwr_flsh1:		movlw	.8						; lae loendi uuesti: kirjutame ikka 8 baidi kaupa
				movwf	FlashCnt
				return
; *************************************************************************************************************
; *************************** kustuta firmware flashist *******************************************************
; *************************************************************************************************************
erase_flsh:		movlw	0x02					; 448 (1C0) tsklit koodi kustutamiseks. Kuna "decfsz", siis +1 !!!
				movwf	Count1
				movlw	0xC0
				movwf	Count
				clrf	TBLPTRU					; alustame mlu algusest
				clrf	TBLPTRH
				clrf	TBLPTRL
erase_flsh1:	movlw	0x94					; kirjuta FLASHi, luba kirjutamine ja row erase
				movwf	EECON1		
				MOVLW 	0x55					; lahtilukustamine
				MOVWF 	EECON2 	
				MOVLW 	0xAA
				MOVWF 	EECON2 
				BSF 	EECON1,WR 				; kustuta 64-baidine rida, prose hangub seniks.
				bcf		CARRY
				movlw	.64						; dvaanci flashi pointerit
				addwf	TBLPTRL,F
				btfsc	CARRY
				incf	TBLPTRH,F
				decfsz	Count					; tskelda edasi
				goto	erase_flsh1
				decfsz	Count1					; tskelda edasi
				goto	erase_flsh1
				movlw	0x80					; keela kirjutamine FLASHi ja row erase
				movwf	EECON1		
				return			
; *************************************************************************************************************
; ******************* leia FATi sektor kus faili jrgmine sektor kirjas ***************************************
; *************************************************************************************************************
;Which FAT sector contains the Nth cluster entry I need ? Location of FAT copy + (( N * 2) / BytesPerSector) 
bfind_fat_sec:	movf	abi_L,W					; leiame FATi sektori kus asub huvitav inff
				movwf	Multiplier
				movf	abi_H,W 
				movwf	Multiplier1
				movlw	0x02
				movwf	Multiplicand
				clrf	Multiplicand+1
				call	bmul1616
				movf	Product,W				
				movwf	Dividend				;L
				movf	Product1,W				
				movwf	Dividend1				;H
				movf	BPSec_H,W				; baite sektoris
				movwf	Divisor1
				movf	BPSec_L,W				
				movwf	Divisor
				call	bdiv1616
				movf	FatStart_L,W			; liita FATi algus
				addwf	Quotient,W
				movwf	lba3
				movwf	dlba3					; ebimuutuja
				btfsc	CARRY
				incf	Quotient1,F
				movf	FatStart_H,W			
				addwf	Quotient1,W
				movwf	lba2
				movwf	dlba2					; ebimuutuja
				clrf	dlba1					; neid peab samuti arvestama!!!
				clrf	dlba0
				clrf	lba1					; neid peab samuti arvestama!!!
				clrf	lba0
				call	bMMC_get_sect			; loeme FATi sektorit
				return
; *************************************************************************************************************
; ******************* leia clusteri numbri jrgi faili sektor *************************************************
; *************************************************************************************************************
bfind_sector:	movlw	0x02					; arvutame faili algussektori
				subwf	abi_L,W ;HIGH L
				btfss	CARRY
				decf	abi_H,F ;LOW H
				movwf	Multiplicand			; LOW
				movf	abi_H,W; H
				movwf	Multiplicand+1			; HI

				movf	SPClust,W				; sectors per cluster
				movwf	Multiplier				; LOW	
				movlw	0x00
				movwf	Multiplier1				; HI
				call	bmul1616
				movf	Product,W
				addwf	DataSec_L,W
				movwf	lba3
				movwf	dlba3					; ebimuutuja
				btfsc	CARRY
				incf	Product1,F
				movf	Product1,W
				addwf	DataSec_H,W
				movwf	lba2
				movwf	dlba2					; ebimuutuja
				clrf	dlba1					; neid peab samuti arvestama!!!
				clrf	dlba0
				return
; *************************************************************************************************************
; **** Loeb kaardilt sektori -> SectorBuf-i. Eelnevalt olgu sektori aadress -> lba0(Hi)...lba3(Lo) ************
; *************************************************************************************************************
bMMC_get_sect:	bcf		viga
				btfsc	CDI						; kaart sees?
				goto	binit_cf_err1			; ei, vlju veateatega
				LFSR	.0,SectorBuf			; salvestamise koha aadress
bMMC_get_sect1:	movlw	0x51					; ksk LOE 1 blokk
				movwf	DATA_HI
				movlw	0xFF					; CRC
				movwf	DATA_LO
				clrf	rsp						; ootab vastust 0x00
				bsf		CCS_passive				; las kaart jb valituks !
				call	bwr_spi_cmd
				btfsc	viga
				goto	binit_cf_err1			; vlju veateatega
				call	bMMC_rdy_wait			; oota kuni kaart valmis inffi saatma
				movlw	0x00					; loeme 512 baiti
				movwf	COUNTER_LO
				movlw	0x02
				movwf	COUNTER_HI
bMMC_get_1:		movlw	0xFF					; loe bait kaardilt
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err1			; vlju veateatega
				movwf	POSTINC0				; kirjuta mllu
				decfsz	COUNTER_LO,F
				goto	bMMC_get_1
				decfsz	COUNTER_HI,F
				goto	bMMC_get_1
				movlw	0xFF					; loe bait kaardilt
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err1			; vlju veateatega
				movwf	POSTINC0				; kirjuta mllu
				movlw	0xFF					; loe bait kaardilt
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err1			; vlju veateatega
				bcf		CCS_passive				; MMC-kaardi CS passiivseks
				bsf		CCS						; ja fsiliselt kah
				LFSR	.0,SectorBuf			; koristame natuke...mlupuhvri algus
				return							; loetud !			
binit_cf_err1:	bsf		CCS						; kaart DISABLE
				bsf		viga					; keegi on kaardi ptcu pand
				return
; *************************************************************************************************************
; ************************ kivitab MMC-kaardi SPI-reziimis ***************************************************
; *************************************************************************************************************
binit_card:		bcf		viga
				BTFSC	CDI						; kaart sees?
				GOTO	binit_cf_err			; ei, vlju veateatega
				movlw	0xFF
				movwf	Count					; 255 * proovime
binit_c0:		bsf		CCS						; MMC disabled hetkel veel
				movlw	.10						; Seame MMC SPI-reziimi. Selleks saadame 80 taktipulssi thjalt
				movwf	count
binit_c1:		movlw	0xFF
				call	bwr_spi
				decfsz	count
				goto	binit_c1
				bcf		CCS						; kaart tle!
				movlw	0x40					; ksk RESET (CMD0)
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x95					; CRC
;				call	wr_spi
;				movlw	0xFF					; thikargamise takt, vastust ei loe
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
binit_c2:		movlw	0xFF
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				sublw	0x01					; soovitav vastus on 0x01
				btfsc	ZERO
				goto	binit_c3				; OK!
				decfsz	Count
				goto	binit_c2				; proovi veel
				goto	binit_cf_err			; ei, vlju veateatega
binit_c3:		movlw	0xFF
				movwf	Count					; 255 * proovime
binit_c4:		movlw	0xFF					; thikargamise bait
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x41					; ksk Get_Out_Of_IDle
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0x00
				call	bwr_spi
				movlw	0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0xFF					; CRC asemel saadame 0xFF, oleme SPI-s ja CRC-d enam ei vajata
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0xFF					; thikargamise bait
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				movlw	0xFF					; soovitav vastus on 0x00
				call	bwr_spi
				btfsc	viga
				goto	binit_cf_err			; vlju veateatega
				sublw	0x00					; 0x00 ?
				btfsc	ZERO
				goto	binit_c5				; OK!
				decfsz	Count
				goto	binit_c4				; proovi veel
				goto	binit_cf_err			; ei, vlju veateatega
binit_c5:		bsf		CCS						; kaart DISABLE
				nop
				nop
binit_c7:		bsf		CCS						; kaart DISABLE
				bcf		viga
				return							
binit_cf_err:	bsf		CCS						; kaart DISABLE
				bsf		viga					; keegi on kaardi ptcu pand
				return
; *************************************************************************************************************
; ************************ ootab kaardi jobutamise lppu ******************************************************
; *************************************************************************************************************
bMMC_rdy_wait:	movlw	0xFF					; loeme kaardilt vastuse
				call	bwr_spi
				btfsc	viga
				return
				sublw	0xFE					; kas oli "data token" ?
				btfss	ZERO
				goto	bMMC_rdy_wait			; ei veel, oota!
				return
; *************************************************************************************************************
; ************************ Kirjutab W sisu SSPBUF'i ***********************************************************
; *************************************************************************************************************
bwr_spi:		movwf	SSPBUF
				call	loadT3					; vahikoer ketist lahti
bwr_spi1:		btfsc	SSPSTAT,BF				; sai tehtud ?
				goto	bwr_spi2
				btfss	PIR2,TMR3IF				; 10 mS armuaega otsas ?
				goto	bwr_spi1				; ootame veel		
				bsf		viga
				return
bwr_spi2:		movf	SSPBUF,W				; loe vastus
				bcf		viga
				return
; *************************************************************************************************************
; **** Saadab MMC-le ksu: ksk->DATA_HI; Aadress: lba0...lba3, Lpu mrk-> DATA_LO ***************************
; *************************************************************************************************************
bwr_spi_cmd:	bcf		CCS
				movlw	0x09					; nihutame aadressi
				movwf	mmc_cnt
bwr_spi_cmd_0:	bcf		CARRY
				rlcf	lba3,W
				movwf	lba3
				rlcf	lba2,W
				movwf	lba2
				rlcf	lba1,W
				movwf	lba1
				rlcf	lba0,w
				movwf	lba0
				decfsz	mmc_cnt
				goto	bwr_spi_cmd_0
				movlw	0xFF
				movwf	Count					; vastuse ootamise kordade loendi
				call	bwr_spi					; thikargamise bait MMC-le (anname aega baiti seada...)
				btfsc	viga
				return
				movf	DATA_HI,W				; ksk
				call	bwr_spi					; kirjuta kaardile
				btfsc	viga
				return
				
				movf	lba0,W					; Sect.Adr.Hi,8hi
				call	bwr_spi					; kirjuta kaardile
				btfsc	viga
				return
				movf	lba1,W					; Sect.Adr.Hi,8lo
				call	bwr_spi					; kirjuta kaardile
				btfsc	viga
				return
				movf	lba2,W					; Sect.Adr.Lo,8hi
				call	bwr_spi					
				btfsc	viga
				return
				movf	lba3,W					; Sect.Adr.Lo,8lo
				call	bwr_spi					
				btfsc	viga
				return
				movf	DATA_LO,W				; CRC
				call	bwr_spi					
				btfsc	viga
				return
bwr_spi_cmd1:	movlw	0xFF
				call	bwr_spi					; thikargamise bait MMC-le (anname aega baiti seada...)
				btfsc	viga
				return
				subwf	rsp,W					; kontrollime kaardi vastust
				btfsc	ZERO
				goto	bwr_spi_cmd2			; oligi soovitud vastus !
				decfsz	Count
				goto	bwr_spi_cmd1			; vale vastus aga ootame veel
				bsf		viga					; mt sai tis: 256 * vastati valesti
				goto	bwr_spi_cmd3
bwr_spi_cmd2:	bcf		viga					; kik OK
bwr_spi_cmd3:	btfss	CCS_passive				; jtame kaardi selektituks ?
				bsf		CCS						; Kaart Stopp!
				return
;; ***** JUNK  ************
bmul1616:		clrf   Product
  				clrf   Product + 1

  				movlw  .16			      ;  Operating on 16 Bits
  				movwf  count

bmulLoop                          ;  Loop Here for Each Bit

  rrcf    Multiplier + 1, f    ;  Shift the Multiplier down
  rrcf    Multiplier, f        ;   by one

  btfss  STATUS, C            ;  If the bit is set, add 
   goto  bmulSkip                 ;   the Multiplicand to the
                              ;   "Product"
  movf   Multiplicand + 1, w
  addwf  Product + 1, f
  movf   Multiplicand, w
  addwf  Product, f
  btfsc  STATUS, C
   incf  Product + 1, f

bmulSkip                          ;  Shift up Multiplicand and
  bcf    STATUS, C            ;   Loop Around
  rlcf	 Multiplicand, f
  rlcf    Multiplicand + 1, f

  decfsz count
   goto  bmulLoop
				return

bdiv1616:		 clrf   Quotient				; nulli tulemus (jagatis)
				 clrf   Quotient + 1

				 movlw  1                    	;  Initialize Count
		 		 movwf  Count
				 clrf   Count + 1

bStartLoop:                    					; kui suureks jagaja minna vib
  				btfsc  Divisor + 1, 7       	; If at the "top", then do 
   				goto  bdivLoop                 		; the Division
  				bcf    STATUS, C            	;  Shift Count and Divisor Up
  				rlcf    Count, f
  				rlcf    Count + 1, f
   				rlcf    Divisor, f
  				rlcf    Divisor + 1, f
  				goto   bStartLoop

bdivLoop                          ;  Now, Take Away "Divisor" 
                              ;   from "Dividend"
  movf   Divisor, w           ;  If Dividend => Divisor then
  subwf  Dividend, w          ;   Take Away
  movwf  temp
  movlw  0
  btfss  STATUS, C
   movlw 1
  addwf  Divisor + 1, w
  subwf  Dividend + 1, w
  btfss  STATUS, C
   goto  bdivSkip                 ;   Divisor < Dividend

  movwf  Dividend + 1         ;  Save the New Dividend
  movf   temp, w
  movwf  Dividend

  movf   Count, w             ;  Add Count to the Quotient
  addwf  Quotient, f
  movf   Count + 1, w
  addwf  Quotient + 1, f      ;  No Opportunity for Carry

bdivSkip                          ;  Shift Divisor/Count Down

  bcf    STATUS, C
  rrcf    Divisor + 1, f
  rrcf    Divisor, f

  rrcf    Count + 1, f         ;  If Carry Set after Count
  rrcf    Count, f             ;   Shift, Finished

  btfss  STATUS, C            ;  If Carry NOT Set, then 
   goto  bdivLoop                 ;   Process next Bit
				return
; *************************************************************************************************************
; ************** EEPROMi kirjutamine **************************************************************************
; *************************************************************************************************************
bwr_eprom:;		MOVWF 	EEADR 					; kirjutatava pesa aadress
				BCF 	EECON1, EEPGD 			; viita EEPROMile
				BCF 	EECON1, CFGS 			; Access program FLASH or Data EEPROM memory
				BSF 	EECON1, WREN			; luba kirjutamine
				MOVLW 	0x55					; spets koodijada kirjutamise enableerimiseks
				MOVWF 	EECON2 
				MOVLW 	0xAA
				MOVWF 	EECON2 
				BSF 	EECON1, WR 				; kirjuta !
bwr_epr1:		btfsc	EECON1, WR 
				goto	bwr_epr1
				BCF 	EECON1, WREN 			; keela kirjutamine
				return
; *************************************************************************************************************
; ************** Vea puhul stardib bootloader siitkaudu *******************************************************
; *************************************************************************************************************
errorloader:   	clrf	STATUS					; initsialiseeri plaat
				clrf	INTCON	
				clrf	PCLATH	
				clrf	PORTD	
				clrf	PORTC	
				clrf	PORTB	
				clrf	PORTA
				clrf	PORTE
				MOVLW	0x00					; **** A/D ****
				MOVWF	ADCON0					; A/D: T0sc/2, kanal 0, x, seisma, muundi OFF
				MOVLW	0x06					; tulemus vasakule joondet, kik otsad digipinnidex
				MOVWF	ADCON1
				MOVLW	0xD0
				MOVWF	TRISC					; RS232, MMSi koivad:(SDO-C5-CDIN vljund, SDI-C4-CDOUT sisend,SCK-C3-CCK vljund), C0 vljund: RClk_X2
				movlw	0x03
				movwf	TRISE
				movlw	0xF0					; RS232 ja MMC otsad krgeks, C0 madalaks: RClk_X2
				movwf	PORTC
				movlw	0xFF					; A0 on CDI ehk kaardi sisestamise kontrolli pinn
				movwf	TRISA
				clrf	CCP1CON					; 1. CCP resettida
				movlw	0x00					; PWM reset
				movwf	CCP2CON
				bcf		INTCON2,NOT_RBPU		; pull-up takid sees
				movlw	0x00					;**** EEPROM ***************
				movwf	EECON1
				movlw	0x7C					; **** SPI BUS ****
				movwf	T2CON
				bcf		SSPSTAT,SMP				; loeme daata CLK keskel
				bcf		SSPSTAT,CKE				; saadame daata SCK tusval frondil
				movlw	0x33
				movwf	SSPCON1
				bsf		CDI						; **** MMC-kaart ****
				bsf		CCLK
				bsf		CDIN
				bsf		CDOUT
				bsf		CCS						; MMC keelatud
				clrf	flags1
				clrf	flags6

;
				call	loadT3					; kaardioperatsioone ootame 10 mS
				call	binit_card				; hakkame ketast lugema - init
				btfsc	viga
				goto	errorloader				; proovime niikaua kuni kaart leitakse ja kima tmmatakse
				bcf		viga					
				movlw	0x04					; meedial saab olla max. 4 partitsiooni
				movwf	count
				clrf	lba0					; adresseeri MBR'i sektor 0
				clrf	lba1
				clrf	lba2
				clrf	lba3
find_part:		call	bMMC_get_sect			; loe sektor mllu
				btfsc	viga
				reset
				LFSR	.0,SectorBuf+.446+.4+.2+.2; loe partitsiooni 1 infot (446 baiti vahele jtta, part.kirje algusest veel 8 "igavat" baiti)
				bsf		viga					; oletame, et saame nullid (part. defineerimata)
				movf	POSTINC0,W				; boot rec. algus: lba3 ja lba2
				andlw	0xFF				
				btfss	ZERO
				bcf		viga
				movwf	lba3
				movwf	StartSec_L				; seivime igaks juhuks (kui ige, kasutame)
				movf	POSTINC0,W
				andlw	0xFF				
				btfss	ZERO
				bcf		viga
				movwf	lba2
				movwf	StartSec_H
				movf	POSTINC0,W				; boot rec. algus: lba1 ja lba0
				andlw	0xFF				
				btfss	ZERO
				bcf		viga
				movwf	lba1
				movf	POSTINC0,W
				andlw	0xFF				
				btfss	ZERO
				bcf		viga
				movwf	lba0
				btfsc	viga					; kas partitsiooni algus = 0x00000000 ? (ehk defineerimata)
				goto	bvol_next_part_ent		; ongi, vaatame jrgmist
				call	bMMC_get_sect			; partitsioon leitud ! Loe sektor mllu
				btfsc	viga
				reset
; partitsioon leitud !	
				movlw	.11						; jtame 11 baiti vahele
				addwf	FSR0L,F
				movff	POSTINC0,BPSec_L		; loeme bytes per sector (1 WORD)
				movff	POSTINC0,BPSec_H
				movff	POSTINC0,SPClust		; loe sectors per cluster (1BYTE)
				movff	POSTINC0,ResSec_L
				movff	POSTINC0,ResSec_H
				movff	POSTINC0,CopFat			; loe copies of fat
				movff	POSTINC0,MaxRent_L		; loe max root directory entries
				movff	POSTINC0,MaxRent_H
				movlw	.3
				addwf	FSR0L,F					; jtame 3 baiti vahele
;;******************** TEHA: eristamine 12/1 ja 32-bit FATi vahel! ******************************
				movff	POSTINC0,SectFat_L		; loeme sectors per fat
				movff	POSTINC0,SectFat_H		
				bcf		CARRY					; arvutame: FAT region start
				movf	StartSec_L,W			; Reserved Region Start
				addwf	ResSec_L,W				; + Reserved Sectors
				movwf	StartSec_L				; tulemus -> FATregion start L
				movwf	FatStart_L
				btfsc	CARRY
				incf	StartSec_H,F
				movf	StartSec_H,W
				addwf	ResSec_H,W
				movwf	StartSec_H				; tulemus -> FATregion start H
				movwf	FatStart_H

				bcf		CARRY					; arvutame sectors in all
				rlcf	SectFat_L,W
				movwf	tempor0_l
				rlcf	SectFat_H,W
				movwf	tempor0_h
 
				bcf		CARRY
				movf	StartSec_L,W			; actual start sector
				addwf	tempor0_l,W
				movwf	StartSec_L				; RootDir region start H (lplik!)
				btfsc	CARRY
				incf	tempor0_h,F
				movf	StartSec_H,W
				addwf	tempor0_h,W
				movwf	StartSec_H				; RootDir region start H

				movf	MaxRent_L,W				; data sector offset
				movwf	Multiplier
				movf	MaxRent_H,W
				movwf	Multiplier+1
				movlw	0x20
				movwf	Multiplicand
				clrf	Multiplicand+1
				call	bmul1616
				movf	Product1,W				; data sectors per cluster
				movwf	Dividend				;L
				movf	Product,W				
				movwf	Dividend1				;H
				movf	BPSec_L,W				
				movwf	Divisor1
				movf	BPSec_H,W				
				movwf	Divisor
				call	bdiv1616
				movf	Quotient,W
				movwf	tempor0_l
				movf	Quotient1,W
				movwf	tempor0_h				; data region start

				movf	StartSec_L,W			; Data sector
				bcf		CARRY
				addwf	tempor0_l,W
				movwf	DataSec_L
				btfsc	CARRY
				incf	tempor0_h
				movf	StartSec_H,W			
				bcf		CARRY
				addwf	tempor0_h
				movwf	DataSec_H				; Data Region Start H
;************************
				clrf	file_numL
				clrf	file_numH
				bcf		lastfile
err_ld_file1:	bcf		notfound				
				bcf		viga
				call	eopen_file				; loe HEX-faili file_num nimi. Seivi parameetrid.
				btfsc	viga
				reset							; saime vea, vesi peale
				btfss	notfound				; selle numbriga faili pole?
				goto	err_ld_file2			; saime ktte !!!
				btfsc	lastfile				; viimane fail ?
				reset							; jah, siis ei leiagi :(
				bcf		CARRY
				incf	file_numL,F				; vta jrgmine fail(i number) (edasi!)
				btfsc	CARRY
				incf	file_numH,F
				goto	err_ld_file1			; ja proovi uuesti
err_ld_file2:	movf	F_Size_0,W				; kontrollida, kas pikkus 0, siis eksit! MSB
				btfss	ZERO
				goto	err_ld_file3
				movf	F_Size_1,W
				btfss	ZERO
				goto	err_ld_file3
				movf	F_Size_2,W
				btfss	ZERO
				goto	err_ld_file3
				movf	F_Size_3,W
				btfsc	ZERO
				reset							; oli null, vesi peale
; ***** HEX-fail olemas, kas nime alguses on "CODE..."? ****
err_ld_file3:	LFSR	.0,File_Name			
				movlw	UPPER errversion		; viita firmware faili nime algusele
				movwf	TBLPTRU
				movlw	HIGH errversion
				movwf	TBLPTRH
				movlw	LOW errversion
				movwf	TBLPTRL
				movlw	.4
				movwf	Count					; 4 esimest smbolit peavad  olema vrdsed
err_ld_file4:	TBLRD*+
				movf	POSTINC0,W
				andlw	0x5F					; converdi upperkeissiks
				subwf	TABLAT,W				; loe 1 nime bait
				btfss	ZERO
				reset							; ei sobi, rock off
				TBLRD*+
				decfsz	Count					; loenda kirjutatavat
				goto	err_ld_file4				
				goto	bootloader				; kik vajalik krvetamiseks olemas - hakkab pihta...
; ***************** >>>> pane PIC plema... ;)
bvol_next_part_ent:	movlw	0x08				; part. puudub: vtame jrgmise vimaliku part. koha
				addwf	FSR0L,F
				decfsz	count
				goto	find_part				; otsi jrgmist
				reset							; ei leitud - ketas formaatimata vi tuxus, ootame uut rongi krbes
errversion:		dt      'C','O','D','E'			; firmware faili nime alguseots
; *************************************************************************************************************
; ************************ leia fail file_num. Seivi parameetrid **********************************************
; *************************************************************************************************************
;*** firmware faili laiendi tabel ****
eL_hex:			dt		'H','E','X'
eopen_file:		movlw	HIGH eL_hex				; lae koodifaili laiendi pointer
				movwf	TBLPTRH
				movlw	LOW	eL_hex
				movwf	TBLPTRL
				bcf		notfound
				movf	StartSec_L,W			; alustame otsingut kataloogi algusest
				movwf	lba3
				movf	StartSec_H,W
				movwf	lba2
				movff	file_numL,Dividend		; leia vastav kataloogisektor
				movff	file_numH,Dividend1		; file_num/16
				movlw	0x10				
				movwf	Divisor1
				movlw	0x00				
				movwf	Divisor
				call	bdiv1616
				movf	Quotient,W
				addwf	lba3,F
				btfsc	CARRY
				incf	lba2,F
				movf	Quotient1,W
				addwf	lba2,F
				clrf	lba0					; hiljem kasuta ka neid !!!
				clrf	lba1
				call	bMMC_get_sect			; loe kataloogisektor -> SectorBuf
				btfsc	viga
				reset
;; korrigeeri faili numbrit: file_num=file_num-((file_num/16)*32)
				movff	Quotient,Multiplier		; L
				movff	Quotient1,Multiplier1	; H
				movlw	0x02					; arv 32
				movwf	Multiplicand
				clrf	Multiplicand+1
				call	bmul1616
				LFSR	.0,.0		
				bcf		CARRY
				movf	Product,W				; L
				subwf	file_numL,W
				btfss	CARRY
				decf	FSR0H,F
				addwf	FSR0L,F
				movf	Product1,W				; H		
				subwf	file_numH,W
				addwf	FSR0H,F					; korrigeeritud file_num nd FSR0-s
				movff	FSR0L,Multiplier		; viitame faili algusele puhvris: file_num*32, L
				movff	FSR0H,Multiplier1		; H
				movlw	0x20					; arv 32
				movwf	Multiplicand
				clrf	Multiplicand+1
				call	bmul1616
				LFSR	.0,SectorBuf			; liidame sektori puhvri aadressi
				bcf		CARRY
				movf	FSR0L,W
				addwf	Product,W
				movwf	FSR0L
				btfsc	CARRY
				incf	FSR0H,F
				movf	Product1,W
				addwf	FSR0H,F					; faili kirje algus kes
				LFSR	.1,File_Name			; siia kirjutab valitu
				movf	INDF0,W					; loeme valitud filee nime
				btfsc	ZERO	
				goto	eopen_file5				; thi koht ehk failide lpp
				movf	INDF0,W					; otsime
				sublw	0xE5					; kustutatud ?
				btfsc	ZERO
				goto	eopen_file4				; jah!
				movf	INDF0,W
				sublw	0x05					; kustutatud ?
				btfsc	ZERO
				goto	eopen_file4				; jah!
				movlw	.8						; kopeerime 8 baiti ra kuni pseb laiendit vaatama
				movwf	Count
eopen_file2:
				movff	POSTINC0,POSTINC1
				decfsz	Count
				goto	eopen_file2
				movf	POSTINC0,W
				andlw	0x5F					; converdi upperkeissiks
				TBLRD*+
				subwf	TABLAT,W
				TBLRD*+
				btfss	ZERO
				goto	eopen_file4				; vale asi
				movlw	0x0D					; pane faili lpu mrk
				movwf	POSTINC1				; laiendi asemele tuhikud
				movf	POSTINC0,W
				andlw	0x5F					; converdi upperkeissiks
				TBLRD*+
				subwf	TABLAT,W
				TBLRD*+
				btfss	ZERO
				goto	eopen_file4				; vale asi
				movlw	' '
				movwf	POSTINC1				; laiendi asemele tuhikud
				movf	POSTINC0,W
				andlw	0x5F					; converdi upperkeissiks
				TBLRD*+
				subwf	TABLAT,W
				TBLRD*+
				btfss	ZERO
				goto	eopen_file4				; vale asi
				movlw	' '
				movwf	POSTINC1				; laiendi asemele tuhikud

				movf	INDF0,W					; vaatame edasi
				sublw	0x08					; Vol.Name ?
				btfsc	ZERO
				goto	eopen_file4				; jah
				btfsc	INDF0,4					; Dir. ?
				goto	eopen_file4				; jah
				movf	INDF0,W
				sublw	0x0F					; LFN ?
				btfsc	ZERO
				goto	eopen_file4				; jah
				movf	INDF0,W
				sublw	0x10					; LFN' jtk ???
				btfsc	ZERO
				goto	eopen_file4				; jah
				movff	POSTINC0,POSTINC1		; vist ige asi, kopeeri atribuut 
				movlw	.20						; ning lejnu kah
				movwf	Count
eopen_file3:	movff	POSTINC0,POSTINC1
				decfsz	Count
				goto	eopen_file3
				movlw	0x0D					; pane faili lpu mrk
				movwf	INDF1
				bcf		nofiles					; ja et ikka oli sobivaid faile
				return							; ei, siis ei saa see olla ESIMENE sobiv fail. Minema !
eopen_file4:	bsf		notfound				; nimetet numbriga fileet ei leitud mitte
				return
eopen_file5:	bsf		lastfile				; failid otsa lpnud
				movf	file_numH,W				; ldse pole?
				btfss	ZERO
				goto	eopen_file6
				movf	file_numL,W				
				btfss	ZERO
				goto	eopen_file6
				bsf		nofiles
				return
eopen_file6:	bcf		CARRY					; judsime failide lppu, vhenda faili numbrit
				decf	file_numL,F				
				btfss	CARRY
				decf	file_numH,F
				return
; *************************************************************************************************************
loadT3:			movlw	0x1C					; 1:8, sisemise taktiga (F/4), 8-bitine kirjutamine, stop
				movwf	T3CON
				movlw	T3resoH
				movwf	TMR3H
				movlw	T3resoL
				movwf	TMR3L
				bcf		PIR2,TMR3IF				; 10 mS
				bcf		PIE2,TMR3IE
				bsf		T3CON,TMR3ON
				return
 	end			
; *************************************************************************************************************
