
; PICBASIC PRO(TM) Compiler 2.47, (c) 1998, 2006 microEngineering Labs, Inc. All Rights Reserved.  
_USED			EQU	1

	INCLUDE	"C:\PBP\18F452.INC"


; Define statements.
; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00017	DEFINE OSC 48          
#define		OSC		 48          

RAM_START       		EQU	00000h
RAM_END         		EQU	005FFh
RAM_BANKS       		EQU	00006h
BANK0_START     		EQU	00080h
BANK0_END       		EQU	000FFh
BANK1_START     		EQU	00100h
BANK1_END       		EQU	001FFh
BANK2_START     		EQU	00200h
BANK2_END       		EQU	002FFh
BANK3_START     		EQU	00300h
BANK3_END       		EQU	003FFh
BANK4_START     		EQU	00400h
BANK4_END       		EQU	004FFh
BANK5_START     		EQU	00500h
BANK5_END       		EQU	005FFh
BANKA_START     		EQU	00000h
BANKA_END       		EQU	0007Fh

; C:\PBP\PBPPIC18.RAM      	00028	FLAGS   VAR     BYTE BANKA SYSTEM       ' Static flags
FLAGS           		EQU	RAM_START + 000h
; C:\PBP\PBPPIC18.RAM      	00012	R0      VAR     WORD BANKA SYSTEM       ' System Register
R0              		EQU	RAM_START + 001h
; C:\PBP\PBPPIC18.RAM      	00013	R1      VAR     WORD BANKA SYSTEM       ' System Register
R1              		EQU	RAM_START + 003h
; C:\PBP\PBPPIC18.RAM      	00014	R2      VAR     WORD BANKA SYSTEM       ' System Register
R2              		EQU	RAM_START + 005h
; C:\PBP\PBPPIC18.RAM      	00015	R3      VAR     WORD BANKA SYSTEM       ' System Register
R3              		EQU	RAM_START + 007h
; C:\PBP\PBPPIC18.RAM      	00016	R4      VAR     WORD BANKA SYSTEM       ' System Register
R4              		EQU	RAM_START + 009h
; C:\PBP\PBPPIC18.RAM      	00017	R5      VAR     WORD BANKA SYSTEM       ' System Register
R5              		EQU	RAM_START + 00Bh
; C:\PBP\PBPPIC18.RAM      	00018	R6      VAR     WORD BANKA SYSTEM       ' System Register
R6              		EQU	RAM_START + 00Dh
; C:\PBP\PBPPIC18.RAM      	00019	R7      VAR     WORD BANKA SYSTEM       ' System Register
R7              		EQU	RAM_START + 00Fh
; C:\PBP\PBPPIC18.RAM      	00020	R8      VAR     WORD BANKA SYSTEM       ' System Register
R8              		EQU	RAM_START + 011h
; C:\PBP\PBPPIC18.RAM      	00027	GOP     VAR     BYTE BANKA SYSTEM       ' Gen Op Parameter
GOP             		EQU	RAM_START + 013h
; C:\PBP\PBPPIC18.RAM      	00023	RM1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Mask
RM1             		EQU	RAM_START + 014h
; C:\PBP\PBPPIC18.RAM      	00026	RM2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Mask
RM2             		EQU	RAM_START + 015h
; C:\PBP\PBPPIC18.RAM      	00021	RR1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Register
RR1             		EQU	RAM_START + 016h
; C:\PBP\PBPPIC18.RAM      	00024	RR2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Register
RR2             		EQU	RAM_START + 017h
; C:\PBP\PBPPIC18.RAM      	00022	RS1     VAR     BYTE BANKA SYSTEM       ' Pin 1 Bank
RS1             		EQU	RAM_START + 018h
; C:\PBP\PBPPIC18.RAM      	00025	RS2     VAR     BYTE BANKA SYSTEM       ' Pin 2 Bank
RS2             		EQU	RAM_START + 019h
; C:\PBP\18F452.BAS        	00024	PORTL   VAR     PORTB
_PORTL           		EQU	 PORTB
; C:\PBP\18F452.BAS        	00025	PORTH   VAR     PORTC
_PORTH           		EQU	 PORTC
; C:\PBP\18F452.BAS        	00026	TRISL   VAR     TRISB
_TRISL           		EQU	 TRISB
; C:\PBP\18F452.BAS        	00027	TRISH   VAR     TRISC
_TRISH           		EQU	 TRISC
#define _LED0            	_PORTB??0
#define _TMR0IF          	_INTCON??2
#define _TMR0ON          	_T0CON??7
#define _TRISB??0        	 TRISB, 000h
#define _PORTB??0        	 PORTB, 000h
#define _INTCON??2       	 INTCON, 002h
#define _T0CON??7        	 T0CON, 007h

; Constants.
_Reload          		EQU	0FDE8h

; EEPROM data.


	INCLUDE	"USBDEM~1.MAC"
	INCLUDE	"C:\PBP\PBPPIC18.LIB"


; C:\PBP\18F452.BAS        	00012	BANKA   $0000, $007F
; C:\PBP\18F452.BAS        	00013	BANK0   $0080, $00FF
; C:\PBP\18F452.BAS        	00014	BANK1   $0100, $01FF
; C:\PBP\18F452.BAS        	00015	BANK2   $0200, $02FF
; C:\PBP\18F452.BAS        	00016	BANK3   $0300, $03FF
; C:\PBP\18F452.BAS        	00017	BANK4   $0400, $04FF
; C:\PBP\18F452.BAS        	00018	BANK5   $0500, $05FF
; C:\PBP\18F452.BAS        	00020	LIBRARY "PBPPIC18"

; C:\PBP\18F452.BAS        	00022	        include "PIC18EXT.BAS"

; C:\PBP\18F452.BAS        	00029	        include "PBPPIC18.RAM"

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00001	asm

	ASM?

    __CONFIG    _CONFIG1L, _PLLDIV_1_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L  
                            ;              ;                      ; USB clock source comes from the 96 MHz PLL divided by 2
                            ;              ; [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]
                            ; No prescale (4 MHz oscillator input drives PLL directly)


    __CONFIG    _CONFIG1H, _FOSC_XTPLL_XT_1H & _FCMEN_OFF_1H & _IESO_OFF_1H 
                            ;                  ;               ; Oscillator Switchover mode disabled
                            ;                  ; Fail-Safe Clock Monitor disabled
                            ; XT oscillator, PLL enabled, XT used by USB
    __CONFIG    _CONFIG2L, _PWRT_ON_2L & _BOR_ON_2L  & _BORV_2_2L  & _VREGEN_ON_2L   
    __CONFIG    _CONFIG2H, _WDT_OFF_2H 
    __CONFIG    _CONFIG3H, _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_ON_3H 
    __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L  & _XINST_OFF_4L & _DEBUG_OFF_4L 


	ENDASM?

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00017	DEFINE OSC 48          

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00019	PORTB   =   0
	MOVE?CB	000h, PORTB

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00020	TRISB.0 =   0
	MOVE?CT	000h, _TRISB??0

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00026	INTCON  =   %10100000       ' Enable global and TMR0 interrupts
	MOVE?CB	0A0h, INTCON

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00027	T0CON   =   %10000000       ' TMR0, CLK internal, prescaler 1:2, T0ON
	MOVE?CB	080h, T0CON
; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00031	Reload      con 65000       ' ~100 uSec

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00032	ucfg    =   %00010100       ' enable internal USB pull-up, Full speed USB
	MOVE?CB	014h, UCFG

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00034	goto SkipMacro
	GOTO?L	_SkipMacro

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00035	    asm 

	ASM?
 
Reload_TMR0 macro
    BCF     _TMR0ON         ; stop timer
    MOVE?CW _Reload,TMR0L   ; reload
    BCF     _TMR0IF         ; clear overflow flag
    BSF     _TMR0ON         ; start timer
    ENDM
    

	ENDASM?


; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00044	SkipMacro:

	LABEL?L	_SkipMacro	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00045	    pause 500               ' Settle delay
	PAUSE?C	001F4h

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00046	    usbinit                 ' initialise USB...
	USBINIT?	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00047	@   Reload_TMR0             ; Reload timer0

	ASM?
   Reload_TMR0             ; Reload timer0

	ENDASM?


; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00048	    ON INTERRUPT GOTO DoUSBService
	ONINT?LL	_DoUSBService, L00001

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00050	Start: 

	LABEL?L	_Start	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00051	    goto start              ' Spin 'till you die!
	ICALL?L	L00001
	GOTO?L	_Start

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00053	DISABLE
	DISABLE?	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00054	DoUSBService:

	LABEL?L	_DoUSBService	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00055	    toggle LED0             ' toggle LED each time 
	TOGGLE?T	_LED0

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00056	    usbservice              ' keep connection alive
	USBSERVICE?	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00057	@   Reload_TMR0             ; reload timer

	ASM?
   Reload_TMR0             ; reload timer

	ENDASM?


; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00058	    RESUME                  ' getout of here
	RESUME?	

; C:\PBP_PROG\USBDEMO\PICBAS~1\USBDEM~1.BAS	00059	ENABLE    
	ENABLE?	

	END
