'****************************************************************
'*  Name    : ReEnterPBP-18LP.bas                               *
'*  Author  : Darrel Taylor / Timothy Box                       *
'*  Date    : MAR 18, 2006                                      *
'*  Version : 1.2   JUL 18, 2006                                *
'*  Notes   : Allows re-entry to PBP from a Low Priority        *
'*          :                               ASM interrupt       *
'*          : Must have DT_INTS-18.bas loaded first             *
'****************************************************************
'*  Versions:                                                   *
'*    1.2  : Modified to handle smaller BANKA in the newer chips*
'****************************************************************
DISABLE DEBUG

DEFINE   ReEnterLPused  1
VarsSaved_L   VAR BIT

goto OverReEnterL
   
' Save locations for PBP system Vars during Low Priority Interrupts
LP_Vars  VAR  WORD[22]        ; group vars together for less banking
    R0_SaveL      VAR LP_Vars[0]
    R1_SaveL      VAR LP_Vars[1]
    R2_SaveL      VAR LP_Vars[2]
    R3_SaveL      VAR LP_Vars[3]
    R4_SaveL      VAR LP_Vars[4]
    R5_SaveL      VAR LP_Vars[5]
    R6_SaveL      VAR LP_Vars[6]
    R7_SaveL      VAR LP_Vars[7]
    R8_SaveL      VAR LP_Vars[8]
    Flag_GOP_L    VAR LP_Vars[9]
      Flags_SaveL   VAR Flag_GOP_L.lowbyte
      GOP_SaveL     VAR Flag_GOP_L.highbyte
    RM_L          VAR LP_Vars[10]
      RM1_SaveL     VAR RM_L.lowbyte
      RM2_SaveL     VAR RM_L.highbyte
    RR_L          VAR LP_Vars[11]
      RR1_SaveL     VAR RR_L.lowbyte
      RR2_SaveL     VAR RR_L.highbyte
    RS_L          VAR LP_Vars[12]
      RS1_SaveL     VAR RS_L.lowbyte
      RS2_SaveL     VAR RS_L.highbyte
    T1_SaveL      VAR LP_Vars[13]
    T2_SaveL      VAR LP_Vars[14]
    T3_SaveL      VAR LP_Vars[15]
    T4_SaveL      VAR LP_Vars[16]
    T5_SaveL      VAR LP_Vars[17]
    T6_SaveL      VAR LP_Vars[18]
    T7_SaveL      VAR LP_Vars[19]
    TBLPTR_L      VAR LP_Vars[20]
      TBLPTRL_SaveL VAR TBLPTR_L.lowbyte
      TBLPTRH_SaveL VAR TBLPTR_L.highbyte
    Product_L     VAR LP_Vars[21]
   
SavePBP_L:               ' Save all PBP system Vars Low Priority
  if VarsSaved_L = 0 then
    R0_SaveL = R0
    R1_SaveL = R1
    R2_SaveL = R2
    R3_SaveL = R3
    R4_SaveL = R4
    R5_SaveL = R5
    R6_SaveL = R6
    R7_SaveL = R7
    R8_SaveL = R8
    Flags_SaveL = FLAGS
    GOP_SaveL = GOP
    RM1_SaveL = RM1
    RM2_SaveL = RM2
    RR1_SaveL = RR1
    RR2_SaveL = RR2
@ if Save_TBLPTR == 1
    TBLPTRL_SaveL = TBLPTRL
    TBLPTRH_SaveL = TBLPTRH
@ endif
    ASM
        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveL
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveL
        endif
        ifdef MUL
            MOVE?WW    PRODL, _Product_L
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveL
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveL
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveL
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveL
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveL
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveL
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveL
        endif
    ENDASM   
    VarsSaved_L = 1
  endif
@ INT_RETURN

RestorePBP_L:
  if VarsSaved_L = 1 then
    R0 = R0_SaveL
    R1 = R1_SaveL
    R2 = R2_SaveL
    R3 = R3_SaveL
    R4 = R4_SaveL
    R5 = R5_SaveL
    R6 = R6_SaveL
    R7 = R7_SaveL
    R8 = R8_SaveL
    FLAGS = Flags_SaveL
    GOP = GOP_SaveL
    RM1 = RM1_SaveL
    RM2 = RM2_SaveL
    RR1 = RR1_SaveL
    RR2 = RR2_SaveL
@ if Save_TBLPTR == 1
    TBLPTRL = TBLPTRL_SaveL
    TBLPTRH = TBLPTRH_SaveL
@ endif
    ASM
        ifdef RS1
            MOVE?BB    _RS1_SaveL, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveL, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_L, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveL, T1
        endif
        ifdef T2
            MOVE?WW    _T2_SaveL, T2
        endif
        ifdef T3
            MOVE?WW    _T3_SaveL, T3
        endif
        ifdef T4
            MOVE?WW    _T4_SaveL, T4
        endif
        ifdef T5
            MOVE?WW    _T5_SaveL, T5
        endif
        ifdef T6
            MOVE?WW    _T6_SaveL, T6
        endif
        ifdef T7
            MOVE?WW    _T7_SaveL, T7
        endif
        ifdef T8
            ERROR "Temp variables exceeding T7"
        endif
    ENDASM   
    VarsSaved_L = 0
  ENDIF
@ INT_RETURN

OverReEnterL:
ENABLE DEBUG
