asm
    __CONFIG    _CONFIG1L, _PLLDIV_1_1L & _CPUDIV_OSC1_PLL2_1L & _USBDIV_2_1L  
                            ;              ;                      ; USB clock source comes from the 96 MHz PLL divided by 2
                            ;              ; [OSC1/OSC2 Src: /1][96 MHz PLL Src: /2]
                            ; No prescale (4 MHz oscillator input drives PLL directly)


    __CONFIG    _CONFIG1H, _FOSC_XTPLL_XT_1H & _FCMEN_OFF_1H & _IESO_OFF_1H 
                            ;                  ;               ; Oscillator Switchover mode disabled
                            ;                  ; Fail-Safe Clock Monitor disabled
                            ; XT oscillator, PLL enabled, XT used by USB
    __CONFIG    _CONFIG2L, _PWRT_ON_2L & _BOR_ON_2L  & _BORV_2_2L  & _VREGEN_ON_2L   
    __CONFIG    _CONFIG2H, _WDT_OFF_2H 
    __CONFIG    _CONFIG3H, _MCLRE_ON_3H & _LPT1OSC_OFF_3H & _PBADEN_OFF_3H & _CCP2MX_ON_3H 
    __CONFIG    _CONFIG4L, _STVREN_ON_4L & _LVP_OFF_4L & _ICPRT_OFF_4L  & _XINST_OFF_4L & _DEBUG_OFF_4L 
endasm
DEFINE OSC 48          
PORTB   =   0
TRISB.0 =   0

LED0    VAR PORTB.0
TMR0IF  VAR INTCON.2
TMR0ON  VAR T0CON.7

INTCON  =   %10100000       ' Enable global and TMR0 interrupts
T0CON   =   %10000000       ' TMR0, CLK internal, prescaler 1:2, T0ON

UCFG    var byte EXT        ' include UCFG register... Yeah Melabs didn't :o(

Reload      con 65000       ' ~100 uSec
ucfg    =   %00010100       ' enable internal USB pull-up, Full speed USB

INCLUDE "DT_INTS-18.bas"    ' Base Interrupt System
INCLUDE "ReEnterPBP-18.bas" ' Include if using PBP interrupts

goto skipmacro

    ASM
INT_LIST  macro    ; IntSource,        Label,  Type, ResetFlag?
        INT_Handler    TMR0_INT,  _DoUSBService,   PBP,  no
    endm
    INT_CREATE               ; Creates the interrupt processor

Reload_TMR0 macro
    BCF     _TMR0ON         ; stop timer
    MOVE?CW _Reload,TMR0L   ; reload
    BCF     _TMR0IF         ; clear overflow flag
    BSF     _TMR0ON         ; start timer
    ENDM
    endasm

SkipMacro:
    pause 500
    usbinit ' initialise USB...
@   Reload_TMR0
@   INT_ENABLE  TMR0_INT

Start: 
    goto start        

DoUSBService:
    toggle led0
    usbservice
@   Reload_TMR0
@   INT_RETURN

