'****************************************************************
'*  Name    : ReEnterPBP-18.bas                                 *
'*  Author  : Darrel Taylor / Timothy Box                       *
'*  Date    : MAR 18, 2006                                      *
'*  Version : 1.2   JUL 18, 2006                                *
'*  Notes   : Allows re-entry to PBP from a High Priority       *
'*          :                               ASM interrupt       *
'*          : Must have DT_INTS-18.bas loaded first             *
'****************************************************************
'*  Versions:                                                   *
'*   1.2  : Modified to handle smaller BANKA in the newer chips *
'****************************************************************
DISABLE DEBUG

DEFINE   ReEnterHPused  1
VarsSaved_H   VAR BIT

goto OverReEnterH
   
' Save locations for PBP system Vars during High Priority Interrupts
HP_Vars  VAR  WORD[22]        ; group vars together for less banking
    R0_SaveH      VAR HP_Vars[0]
    R1_SaveH      VAR HP_Vars[1]
    R2_SaveH      VAR HP_Vars[2]
    R3_SaveH      VAR HP_Vars[3]
    R4_SaveH      VAR HP_Vars[4]
    R5_SaveH      VAR HP_Vars[5]
    R6_SaveH      VAR HP_Vars[6]
    R7_SaveH      VAR HP_Vars[7]
    R8_SaveH      VAR HP_Vars[8]
    Flag_GOP_H    VAR HP_Vars[9]
      Flags_SaveH   VAR Flag_GOP_H.lowbyte
      GOP_SaveH     VAR Flag_GOP_H.highbyte
    RM_H          VAR HP_Vars[10]
      RM1_SaveH     VAR RM_H.lowbyte
      RM2_SaveH     VAR RM_H.highbyte
    RR_H          VAR HP_Vars[11]
      RR1_SaveH     VAR RR_H.lowbyte
      RR2_SaveH     VAR RR_H.highbyte
    RS_H          VAR HP_Vars[12]
      RS1_SaveH     VAR RS_H.lowbyte
      RS2_SaveH     VAR RS_H.highbyte
    T1_SaveH      VAR HP_Vars[13]
    T2_SaveH      VAR HP_Vars[14]
    T3_SaveH      VAR HP_Vars[15]
    T4_SaveH      VAR HP_Vars[16]
    T5_SaveH      VAR HP_Vars[17]
    T6_SaveH      VAR HP_Vars[18]
    T7_SaveH      VAR HP_Vars[19]
    TBLPTR_H      VAR HP_Vars[20]
      TBLPTRL_SaveH VAR TBLPTR_H.lowbyte
      TBLPTRH_SaveH VAR TBLPTR_H.highbyte
    Product_H     VAR HP_Vars[21]
    
SavePBP_H:               ' Save all PBP system Vars High Priority
  if VarsSaved_H = 0 then
    R0_SaveH = R0
    R1_SaveH = R1
    R2_SaveH = R2
    R3_SaveH = R3
    R4_SaveH = R4
    R5_SaveH = R5
    R6_SaveH = R6
    R7_SaveH = R7
    R8_SaveH = R8
    Flags_SaveH = FLAGS
    GOP_SaveH = GOP
    RM1_SaveH = RM1
    RM2_SaveH = RM2
    RR1_SaveH = RR1
    RR2_SaveH = RR2
@ if Save_TBLPTR == 1
    TBLPTRL_SaveH = TBLPTRL
    TBLPTRH_SaveH = TBLPTRH
@ endif
    ASM
        ifdef RS1
            MOVE?BB    RS1, _RS1_SaveH
        endif
        ifdef RS2
            MOVE?BB    RS2, _RS2_SaveH
        endif
        ifdef MUL_USED
            MOVE?WW    PRODL, _Product_H
        endif
        ifdef T1
            MOVE?WW    T1, _T1_SaveH
        endif
        ifdef T2
            MOVE?WW    T2, _T2_SaveH
        endif
        ifdef T3
            MOVE?WW    T3, _T3_SaveH
        endif
        ifdef T4
            MOVE?WW    T4, _T4_SaveH
        endif
        ifdef T5
            MOVE?WW    T5, _T5_SaveH
        endif
        ifdef T6
            MOVE?WW    T6, _T6_SaveH
        endif
        ifdef T7
            MOVE?WW    T7, _T7_SaveH
        endif
    ENDASM   
    VarsSaved_H = 1
  endif
@ INT_RETURN

RestorePBP_H:
  if VarsSaved_H = 1 then
    R0 = R0_SaveH
    R1 = R1_SaveH
    R2 = R2_SaveH
    R3 = R3_SaveH
    R4 = R4_SaveH
    R5 = R5_SaveH
    R6 = R6_SaveH
    R7 = R7_SaveH
    R8 = R8_SaveH
    FLAGS = Flags_SaveH
    GOP = GOP_SaveH
    RM1 = RM1_SaveH
    RM2 = RM2_SaveH
    RR1 = RR1_SaveH
    RR2 = RR2_SaveH
@ if Save_TBLPTR == 1
    TBLPTRL = TBLPTRL_SaveH
    TBLPTRH = TBLPTRH_SaveH
@ endif
    ASM
        ifdef RS1
            MOVE?BB    _RS1_SaveH, RS1
        endif
        ifdef RS2
            MOVE?BB    _RS2_SaveH, RS2
        endif
        ifdef MUL
            MOVE?WW    _Product_H, PRODL
        endif
        ifdef T1
            MOVE?WW    _T1_SaveH, T1
        endif
        ifdef T2
            MOVE?WW    _T2_SaveH, T2
        endif
        ifdef T3
            MOVE?WW    _T3_SaveH, T3
        endif
        ifdef T4
            MOVE?WW    _T4_SaveH, T4
        endif
        ifdef T5
            MOVE?WW    _T5_SaveH, T5
        endif
        ifdef T6
            MOVE?WW    _T6_SaveH, T6
        endif
        ifdef T7
            MOVE?WW    _T7_SaveH, T7
        endif
        ifdef T8
            ERROR "Temp variables exceeding T7"
        endif
    ENDASM   
    VarsSaved_H = 0
  ENDIF
@ INT_RETURN

OverReEnterH:
ENABLE DEBUG
