'****************************************************************
'*  Name    : DT_INTS-18.bas                                    *
'*  Author  : Darrel Taylor                                     *
'*  Notice  : Copyright (c) 2003                                *
'*  Version : 3.1    JUL 18, 2006                               *
'*  Date    : JUL 11, 2006                                      *
'****************************************************************
'*  Versions:                                                   *
'*    3.1  : Modified to handle smaller BANKA in the newer chips*
'****************************************************************

DEFINE  INTHAND       INT_ENTRY_H  ' Context saving for High Priority Ints
DEFINE  INTLHAND      INT_ENTRY_L  ' Context saving for Low Priority Ints

wsave       var byte  BANKA  SYSTEM   ' location for WREG
ssave       var byte  BANK0  SYSTEM   ' location for STATUS register
bsave       var byte  BANK0  SYSTEM   ' location for BSR register
psaveH      VAR BYTE  BANK0  SYSTEM
psaveL      VAR BYTE  BANK0  SYSTEM
fsave0H     var WORD  BANK0  SYSTEM   ' locations for FSR registers
fsave1H     var WORD  BANK0  SYSTEM
fsave2H     var WORD  BANK0  SYSTEM
fsave0L     var WORD  BANK0  SYSTEM   ' low priority FSR locations
fsave1L     var WORD  BANK0  SYSTEM
fsave2L     var WORD  BANK0  SYSTEM
RetAddrL    VAR WORD  BANKA  SYSTEM
RetAddrH    VAR WORD  BANKA  SYSTEM
INT_Flags   VAR BYTE  BANKA  SYSTEM
  Serviced_H  VAR INT_Flags.0
  Serviced_L  VAR INT_Flags.1
  InHPint     VAR INT_Flags.2

goto  OVER_DT_INTS_18

ASM
;  nolist

  #define INT_INT   INTCON,INT0IF   ;-- INT External Interrupt, 16F compatible
  #define INT0_INT  INTCON,INT0IF   ;-- INT0 External Interrupt
  #define INT1_INT  INTCON3,INT1IF  ;-- INT1 External Interrupt
  #define INT2_INT  INTCON3,INT2IF  ;-- INT2 External Interrupt
  #define INT3_INT  INTCON3,INT3IF  ;-- INT3 External Interrupt
  #define RBC_INT   INTCON,RBIF     ;-- RB Port Change Interrupt
  #define TMR0_INT  INTCON,TMR0IF   ;-- TMR0 Overflow Interrupt 18F
  #define TMR1_INT  PIR1,TMR1IF     ;-- TMR1 Overflow Interrupt
  #define TMR2_INT  PIR1,TMR2IF     ;-- TMR2 to PR2 Match Interrupt
  #define TMR3_INT  PIR2,TMR3IF     ;-- TMR3 Overflow Interrupt
  #define TMR4_INT  PIR3,TMR4IF     ;-- TMR4 Overflow Interrupt
  #define TX_INT    PIR1,TXIF       ;-- USART Transmit Interrupt
  #define TX1_INT   PIR1,TX1IF      ;-- USART1 Transmit Interrupt
  #define TX2_INT   PIR3,TX2IF      ;-- USART2 Transmit Interrupt
  #define RX_INT    PIR1,RCIF       ;-- USART Receive Interrupt
  #define RX1_INT   PIR1,RC1IF      ;-- USART1 Receive Interrupt
  #define RX2_INT   PIR3,RC2IF      ;-- USART2 Receive Interrupt
  #define CMP_INT   PIR2,CMIF       ;-- Comparator Interrupt
  #define EE_INT    PIR2,EEIF       ;-- EEPROM/FLASH Write Operation Interrupt
  #define BUS_INT   PIR2,BCLIF      ;-- Bus Collision Interrupt
  #define LVD_INT   PIR2,LVDIF      ;-- Low Voltage Detect Interrupt
  #define HLVD_INT  PIR2,HLVDIF     ;-- High/Low Voltage Detect Interrupt
  #define PSP_INT   PIR1, PSPIF     ;-- Parallel Slave Port Read/Write Interrupt
  #define AD_INT    PIR1, ADIF      ;-- A/D Converter Interrupt
  #define SSP_INT   PIR1, SSPIF     ;-- Master Synchronous Serial Port Interrupt
  #define CCP1_INT  PIR1, CCP1IF    ;-- CCP1 Interrupt
  #define CCP2_INT  PIR2, CCP2IF    ;-- CCP2 Interrupt
  #define CCP3_INT  PIR3, CCP3IF    ;-- CCP3 Interrupt
  #define CCP4_INT  PIR3, CCP4IF    ;-- CCP4 Interrupt
  #define CCP5_INT  PIR3, CCP5IF    ;-- CCP5 Interrupt
  #define USB_INT   PIR2, USBIF     ;-- USB Interrupt
  #define OSC_INT   PIR2, OSCFIF    ;-- Oscillator Fail Interrupt
ENDASM

asm
; -- macro --
INT_Source  macro  IFR, IFB, IER, IEB, IPR, IPB
    if (IflagReg == IFR) && (IflagBit == IFB)  
  list  
INT_Flag_Reg = IFR
INT_Flag_Bit = IFB
INT_Enable_Reg = IER
INT_Enable_Bit = IEB
INT_Priority_Reg = IPR
INT_Priority_Bit = IPB
Found = 1
    endif
  nolist  
    endm 
endasm


asm
;-------------------------------------------------------------------------------
GetIntInfo  macro  IflagReg, IflagBit
  nolist
INT_Flag_Reg = -1
INT_Flag_Bit = -1
INT_Enable_Reg = -1
INT_Enable_Bit = -1
  ifdef  IPR1
INT_Priority_Reg = -1
INT_Priority_Bit = -1
  endif
Found = 0

  ifdef INT0IF  ;----{ INT0 External Interrupt }----------[INTCON, INT0IF]---
      INT_Source  INTCON, INT0IF, INTCON, INT0IE, -1, -1
  endif
  ifdef INT1IF  ;----{ INT1 External Interrupt }---------[INTCON3, INT1IF]---
      INT_Source  INTCON3, INT1IF, INTCON3, INT1IE, INTCON3, INT1IP
  endif
  ifdef INT2IF  ;----{ INT2 External Interrupt }---------[INTCON3, INT2IF]---
      INT_Source  INTCON3, INT2IF, INTCON3, INT2IE, INTCON3, INT2IP
  endif
  ifdef INT3IF  ;----{ INT3 External Interrupt }---------[INTCON3, INT3IF]---
      INT_Source  INTCON3, INT3IF, INTCON3, INT3IE, INTCON2, INT3IP
  endif
  ifdef RBIF    ;----{ RB Port Change Interrupt }-----------[INTCON, RBIF]---
      INT_Source  INTCON, RBIF, INTCON, RBIE, INTCON2, RBIP
  endif
  ifdef TMR0IF  ;----{ TMR0 Overflow Interrupt }----------[INTCON, TMR0IF]---
      INT_Source  INTCON, TMR0IF, INTCON, TMR0IE, INTCON2, TMR0IP
  endif
  ifdef TMR1IF  ;----{ TMR1 Overflow Interrupt }------------[PIR1, TMR1IF]---
      INT_Source  PIR1, TMR1IF, PIE1, TMR1IE, IPR1, TMR1IP
  endif
  ifdef TMR2IF  ;----{ TMR2 to PR2 Match Interrupt }--------[PIR1, TMR2IF]---
      INT_Source  PIR1, TMR2IF, PIE1, TMR2IE, IPR1, TMR2IP
  endif
  ifdef TMR3IF  ;----{ TMR3 Overflow Interrupt }------------[PIR2, TMR3IF]---
      INT_Source  PIR2, TMR3IF, PIE2, TMR3IE, IPR2, TMR3IP
  endif
  ifdef TMR4IF  ;----{ TMR4 Overflow Interrupt }------------[PIR3, TMR4IF]---
      INT_Source  PIR3, TMR4IF, PIE3, TMR4IE, IPR3, TMR4IP
  endif
  ifndef TX1IF  ;----{ USART Transmit Interrupt }-------------[PIR1, TXIF]---
      ifdef TXIF
          INT_Source  PIR1, TXIF, PIE1, TXIE, IPR1, TXIP
      endif
  endif
  ifdef TX1IF   ;----{ USART1 Transmit Interrupt }-----------[PIR1, TX1IF]---
      INT_Source  PIR1, TX1IF, PIE1, TX1IE, IPR1, TX1IP
  endif
  ifdef TX2IF   ;----{ USART2 Transmit Interrupt }-----------[PIR3, TX2IF]---
      INT_Source  PIR3, TX2IF, PIE3, TX2IE, IPR3, TX2IP
  endif
  ifndef RC1IF  ;----{ USART Receive Interrupt }---------------[PIR1 RCIF]---  
    ifdef RCIF
        INT_Source  PIR1, RCIF, PIE1, RCIE, IPR1, RCIP
    endif
  endif
  ifdef RC1IF   ;----{ USART1 Receive Interrupt }------------[PIR1, RC1IF]---
      INT_Source  PIR1, RC1IF, PIE1, RC1IE, IPR1, RC1IP
  endif
  ifdef RC2IF   ;----{ USART2 Receive Interrupt }------------[PIR3, RC2IF]---
      INT_Source  PIR3, RC2IF, PIE3, RC2IE, IPR3, RC2IP
  endif
  ifdef CMIF    ;----{ Comparator Interrupt }-----------------[PIR2, CMIF]---
      INT_Source  PIR2, CMIF, PIE2, CMIE, IPR2, CMIP
  endif
  ifdef EEIF    ;----{ EEPROM/FLASH Write Operation Interrupt [PIR2, EEIF]---
      INT_Source  PIR2, EEIF, PIE2, EEIE, IPR2, EEIP
  endif
  ifdef BCLIF   ;----{ Bus Collision Interrupt }-------------[PIR2, BCLIF]---
      INT_Source  PIR2, BCLIF, PIE2, BCLIE, IPR2, BCLIP
  endif
  ifdef LVDIF   ;----{ Low Voltage Detect Interrupt }--------[PIR2, LVDIF]---
      INT_Source  PIR2, LVDIF, PIE2, LVDIE, IPR2, LVDIP
  endif
  ifdef HLVDIF  ;----{ High/Low Voltage Detect Interrupt }---[PIR2, HLVDIF]---
      INT_Source  PIR2, HLVDIF, PIE2, HLVDIE, IPR2, HLVDIP
  endif
  ifdef PSPIF   ;----{ Parallel Slave Port Interrupt }-------[PIR1, PSPIF]---
      INT_Source  PIR1, PSPIF, PIE1, PSPIE, IPR1, PSPIP
  endif
  ifdef ADIF    ;----{ A/D Converter Interrupt }--------------[PIR1, ADIF]---
      INT_Source  PIR1, ADIF, PIE1, ADIE, IPR1, ADIP
  endif
  ifdef SSPIF   ;----{ Synchronous Serial Port Interrupt }---[PIR1, SSPIF]---
      INT_Source  PIR1, SSPIF, PIE1, SSPIE, IPR1, SSPIP
  endif
  ifdef CCP1IF  ;----{ CCP1 Interrupt }---------------------[PIR1, CCP1IF]---
      INT_Source  PIR1, CCP1IF, PIE1, CCP1IE, IPR1, CCP1IP
  endif
  ifdef CCP2IF  ;----{ CCP2 Interrupt Flag }----------------[PIR2, CCP2IF]---
      INT_Source  PIR2, CCP2IF, PIE2, CCP2IE, IPR2, CCP2IP
  endif
  ifdef CCP3IF  ;----{ CCP3 Interrupt Flag }----------------[PIR3, CCP3IF]---
      INT_Source  PIR3, CCP3IF, PIE3, CCP3IE, IPR3, CCP3IP
  endif
  ifdef CCP4IF  ;----{ CCP4 Interrupt Flag }----------------[PIR3, CCP4IF]---
      INT_Source  PIR3, CCP4IF, PIE3, CCP4IE, IPR3, CCP4IP
  endif
  ifdef CCP5IF  ;----{ CCP5 Interrupt Flag }----------------[PIR3, CCP5IF]---
      INT_Source  PIR3, CCP5IF, PIE3, CCP5IE, IPR3, CCP5IP
  endif
  ifdef USBIF   ;----{ USB  Interrupt Flag }-----------------[PIR2, USBIF]---
      INT_Source  PIR2, USBIF, PIE2, USBIE, IPR2, USBIP
  endif
  ifdef OSCFIF  ;----{ Osc Fail  Interrupt Flag }-------------[PIR2, USBIF]---
      INT_Source  PIR2, OSCFIF, PIE2, OSCFIE, IPR2, OSCFIP
  endif
    
  list
    endm
  list  
ENDASM

ASM
    ifndef  USE_LOWPRIORITY
INT_ENTRY_L
        retfie
    else
        if (USE_LOWPRIORITY != 1)
INT_ENTRY_L
            retfie
        endif
    endif        
ENDASM        

;-----------------------------------------------------------------------------
Asm
asm = 0
ASM = 0
pbp = 1
PBP = 1
YES = 1
yes = 1
NO = 0
no = 0
H equ 'H'  ; High Priority
L equ 'L'  ; Low Priority

;  nolist
  
;-----------------------------------------------------------------------------
SaveFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    FSR#v(F)L, fsave#v(F)Pr
            movff    FSR#v(F)H, fsave#v(F)Pr + 1
          nolist
        else
            ERROR "SaveFSR - Invalid Priority"
        endif
    else
        ERROR "SaveFSR - Invalid FSR number"
    endif
    list
  endm
ENDASM

;-----------------------------------------------------------------------------
Asm
RestFSR  macro  F, Pr
  list
    if (F >= 0) && (F <= 2)
        if (Pr == H) || (Pr == L)
            movff    fsave#v(F)Pr , FSR#v(F)L
            movff    fsave#v(F)Pr + 1 , FSR#v(F)H 
          nolist
        else
            ERROR "RestFSR - Invalid Priority"
        endif
    else
        ERROR "RestFSR - Invalid FSR number"
    endif
    list
  endm
ENDASM

;---[Stay compatible with the 14-bit version]---------------------------------
Asm
INT_FINISH_H   macro
  endm
EndAsm

;---[Create the High Priority Interrupt Processor]----------------------------
ASM
INT_CREATE_H  macro
  local OverCREATE
    goto OverCREATE
Priority = H    
INT_ENTRY_H  
    MOVE?BB  PCLATH, psaveH
    SaveFSR  0, H
    SaveFSR  1, H
    SaveFSR  2, H
    bsf      _InHPint, 0
List_Start_H
    bcf      _Serviced_H, 0         ; Clear Serviced flag
    clrf  BSR
PREV_BANK = 0
    ifdef INT_LIST_H
        INT_LIST_H                  ; Expand the users list of HP INT handlers
    else
        ifdef INT_LIST
            INT_LIST                ; Expand the 16F Compatible List
        else
            error "INT_CREATE_H - INT_LIST or INT_LIST_H not found"
        endif
    endif
    btfsc    _Serviced_H,0          ; if anything was serviced
    goto     List_Start_H           ; go around, and check again

    ifdef ReEnterHPused             ; was ReEnterPBP-18.bas included
        GetAddress  INT_EXIT_H, RetAddrH
        L?GOTO   _RestorePBP_H      ; Restore PBP system Vars
    endif

INT_EXIT_H
PREV_BANK = 0
    bcf      _InHPint, 0
    RestFSR  0, H                   ; Restore FSR0, if it was saved?
    RestFSR  1, H                   ; Restore FSR1, if it was saved?
    RestFSR  2, H                   ; Restore FSR2, if it was saved?
    MOVE?BB  psaveH, PCLATH
    retfie    FAST                  ; Return from Interrupt
OverCREATE
    bsf   INTCON,GIE, 0             ; Enable High Priority Interrupts
    bsf   INTCON,PEIE, 0            ; Enable Peripheral Interrupts
  endm

;---[Stay compatible with the 14-bit version]---------------------------------
INT_CREATE  macro
    INT_CREATE_H
  endm
ENDASM

;---[Create the Low Priority Interrupt Processor]-----------------------------
ASM
INT_CREATE_L  macro
  local OverCREATE
    goto OverCREATE
    ifdef USE_LOWPRIORITY
        if (USE_LOWPRIORITY != 1)
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
        endif
    else
       error "'DEFINE USE_LOWPRIORITY 1' required for Low Priority Interrupts"
    endif
Priority = L
INT_ENTRY_L  
    movff   WREG, wsave             ;  Wreg
    movff   STATUS, ssave           ;  STATUS
    movff   BSR, bsave              ;  BSR
    movff   PCLATH, psaveL
    SaveFSR  0, L                   ;  FSR0
    SaveFSR  1, L                   ;  FSR1
    SaveFSR  2, L                   ;  FSR2
    bcf      _InHPint, 0    
List_Start_L
  clrf  BSR
PREV_BANK = 0
    bcf      _Serviced_L, 0
    ifdef INT_LIST_L
        INT_LIST_L                  ; Expand the users list of HP INT handlers
    else
        error "INT_CREATE_L - INT_LIST_L not defined, can not create"
    endif
    btfsc    _Serviced_L, 0         ; if anything was serviced
    goto     List_Start_L           ; go around, and check again

    ifdef ReEnterLPused             ; was ReEnterPBP-18LP.bas included
        GetAddress  INT_EXIT_L, RetAddrL
        L?GOTO   _RestorePBP_L      ; Restore PBP system Vars
    endif

INT_EXIT_L
PREV_BANK = 0
    RestFSR  0, L                   ; Restore saved vars
    RestFSR  1, L
    RestFSR  2, L                
    MOVE?BB  psaveL, PCLATH
    movff   bsave, BSR              ;  BSR
    movff   wsave, WREG             ;  WREG
    movff   ssave, STATUS           ;  STATUS
    retfie                          ;  Return from Interrupt
OverCREATE
    bsf   RCON,IPEN, 0              ; Enable Interrupt Priorities
    bsf   INTCON,GIEL, 0            ; Enable Low Priority Interrupts
  endm
ENDASM

ASM
;---[Returns the Address of a Label as a Word]-------------------------------
GetAddress macro Label, Wout
    CHK?RP Wout
    movlw low Label          ; get low byte
    movwf Wout
    movlw High Label         ; get high byte
    movwf Wout + 1
    endm

;---[find correct bank for a BIT variable]-----------------------------------
CHKRP?T  macro reg, bit
        CHK?RP  reg
    endm
    


;---[find Assigned Priority for specified INT Source]------------------------
INT_Count = 0

FindIntPriority  macro IntFlagReg, IntFlagBit
  local LoopCount
    nolist
Pfound = 0
LoopCount = 1
      while LoopCount <= INT_Count
          if  (IntFlagReg == PrList#v(LoopCount)R)
             if (IntFlagBit == PrList#v(LoopCount)B)
  list
Priority =  PrList#v(LoopCount)Priority
Pfound = 1
             endif
          endif
LoopCount += 1
      endw
  endm  
ENDASM

ASM

;---[Add an Interrupt Source to the user's list of INT Handlers]--------------
INT_Handler  macro  IntFlagReg, IntFlagBit, Label, Type, Reset
  list
    local AfterSave, AfterUser, NoInt
INT_Count += 1
PrList#v(INT_Count)R = IntFlagReg
PrList#v(INT_Count)B = IntFlagBit
PrList#v(INT_Count)Priority = Priority
        GetIntInfo   IntFlagReg, IntFlagBit
        if (Found == YES)
            btfss    INT_Enable_Reg, INT_Enable_Bit, 0  ; if INT is enabled
            goto   NoInt
            btfss    INT_Flag_Reg, INT_Flag_Bit, 0      ; and the Flag set?
            goto     NoInt
            if (Priority == H)
                bsf      _Serviced_H, 0
            else
                bsf      _Serviced_L, 0
            endif
            ifdef NO_CLRWDT
                if  (NO_CLRWDT != 1)
                    CLRWDT
                endif
            else
                CLRWDT
            endif
                
            if (Type == PBP)                         ; If INT handler is PBP
              if (Priority == H)
                ifdef ReEnterHPused
                    GetAddress  AfterSave, RetAddrH  
                    L?GOTO  _SavePBP_H        ; Save PBP system Vars in HP INT
                else
    error "ReEnterPBP-18 must be INCLUDEd to use High Priority PBP interrupts"
                endif
              else ; Priority = L
                ifdef ReEnterLPused
                    GetAddress  AfterSave, RetAddrL  
                    L?GOTO  _SavePBP_L        ; Save PBP system Vars in LP INT
                else
   error "ReEnterPBP-18LP must be INCLUDEd to use Low Priority PBP interrupts"
                endif
              endif
            endif
AfterSave
PREV_BANK = 0
            if (Priority == H)
                  GetAddress  AfterUser, RetAddrH  
            else ; Priority = L
                  GetAddress  AfterUser, RetAddrL
            endif  
            L?GOTO   Label                        ; goto the users INT handler
                    
AfterUser
PREV_BANK = 0
            if (Reset == YES)                      ; reset flag (if specified)
                bcf      INT_Flag_Reg, INT_Flag_Bit, 0 
            endif
        else
            error Interrupt Source (IntFlagReg,IntFlagBit) not found
        endif
NoInt
    clrf  BSR
PREV_BANK = 0
    endm
ENDASM

asm
;---[Returns from a "goto" subroutine]---------(RetAddr? must be set first)---
INT_RETURN  macro
  local Ret2LP, Ret2HP
      btfsc   _InHPint, 0
      goto    Ret2HP
Ret2LP
      movf    RetAddrL + 1, W, 0 ; Set PCLATH with top byte of return address
      movwf   PCLATH, 0
      movf    RetAddrL, W, 0     ; Go back to where we were
    clrf  BSR
PREV_BANK = 0
      movwf   PCL, 0
      
Ret2HP       
      movf    RetAddrH + 1, W, 0 ; Set PCLATH with top byte of return address
      movwf   PCLATH, 0
      movf    RetAddrH, W, 0      ; Go back to where we were
    clrf  BSR
PREV_BANK = 0
      movwf   PCL, 0
    endm    
    
;---[Enable an interrupt source]----------------------------------------------
INT_ENABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          FindIntPriority  IntFlagReg, IntFlagBit
          if (Pfound == 1)
              if (INT_Priority_Reg != -1)
                  if (Priority == H)
                      bsf  INT_Priority_Reg, INT_Priority_Bit, 0
                  else
                      if (Priority == L)
                          bcf  INT_Priority_Reg, INT_Priority_Bit, 0
                      else
                          error "INT_ENABLE - Invalid Priority Specified"
                      endif
                  endif
              else
                  if (Priority == L)
                      error "INT0_INT can NOT be assigned to Low Priority"
                  endif
              endif
          else
              error "INT_ENABLE - Priority State Not Found"
          endif
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0        ; clear the flag first 
          bsf     INT_Enable_Reg, INT_Enable_Bit, 0    ; enable the INT source  
      else
          error  "INT_ENABLE - Interrupt Source not found!"
      endif
    endm    

;---[Disable an interrupt source]---------------------------------------------
INT_DISABLE  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Enable_Reg, INT_Enable_Bit, 0   ; disable the INT source  
      else
          error "INT_DISABLE - Interrupt Source not found!"
      endif
    endm    

;---[Clear an interrupt Flag]-------------------------------------------------
INT_CLEAR  macro  IntFlagReg, IntFlagBit
      GetIntInfo   IntFlagReg, IntFlagBit
      if (Found == YES)
          bcf     INT_Flag_Reg, INT_Flag_Bit, 0       ; clear the INT flag
      else
          error "INT_CLEAR -  Interrupt Source not found!"
      endif
    endm

ENDASM

; ---[See if we need to save TBLPTR]------------------------------------------
ASM
Save_TBLPTR = 0

    ifdef SIN_USED
Save_TBLPTR = 1
    endif
    ifdef DTMFOUT_USED
Save_TBLPTR = 1
    endif
    ifdef SERDELAY_USED
Save_TBLPTR = 1
    endif
    ifdef CONVBIT_USED
Save_TBLPTR = 1
    endif
    ifdef ERASECODE_USED
Save_TBLPTR = 1
    endif
    ifdef READCODE_USED
Save_TBLPTR = 1
    endif
    ifdef WRITECODE_USED
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKDOWN?WCLW
Save_TBLPTR = 1
    endif
    ifdef LOOK2_USED 
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?BCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?CCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?TCLW
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLB
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLT
Save_TBLPTR = 1
    endif
    ifdef LOOKUP?WCLW
Save_TBLPTR = 1
    endif
endasm

OVER_DT_INTS_18:
