
    '
    '    KeyPad routine
    '    ==============
    '
    '    File name  : KeyPad.bas
    '    Company    : Mister E 
    '    Programmer : Steve Monfette
    '    Date       : 06/02/2006

    '     ***************************************************************************************************
    '    ********************************* Must use MPASM to compile *****************************************
    '     ***************************************************************************************************

    '    This 'INCLUDE' routine is use to read a matrix keypad.
    '    Allow to use various keypad format
    '    Allow to place the keypad ROW and COL on different PORT.
    '    The routine set TRIS register for you

    '    How to use it
    '    =============
    '    1. Include the file
    '           write
    '               INCLUDE "KeyPad.bas" 
    '           somewhere in your code.. after TRIS setting and before MAIN loop
    '
    '    2. Call the Keypad routine by one or the other method bellow
    '           1. By calling the macro
    '                  @ READKEYPAD _YourVar
    '              result store in 'YourVar' wich must be defined as a BYTE sized variable
    '
    '           2. By using GOSUB
    '                  GOSUB KeypadScan
    '              result is store in 'Key' Variable
    
    '    Specific DEFINE
    '    ===============
    '    The defaults setings are
    '        1. Keypad ROW are connected to PORTB<3:0>
    '        2. Keypad COL are connected to PORTB<7:4>
    '        3. Debounce delay = 200 mSec
    '        4. No auto-repeat
    '        5. Keypad type 4X4
    '        6. Scan untill a key is pressed
    '
    '    If you decide to change default settings, here's the DEFINEs list
    '        DEFINE KEYPAD_ROW        4        ' 4 ROW keypad       
    '        DEFINE KEYPAD_ROW_PORT   PORTB    ' ROW port = PORTB
    '        DEFINE KEYPAD_ROW_BIT    4        ' ROW0 = PORTB.4
    '        DEFINE KEYPAD_COL        4        ' 4 COL keypad
    '        DEFINE KEYPAD_COL_PORT   PORTB    ' COL port = PORTB
    '        DEFINE KEYPAD_COL_BIT    0        ' COL0 = PORTB.0
    '        DEFINE KEYPAD_DEBOUNCEMS 200      ' debounce delay = 200 mSec
    '        DEFINE KEYPAD_AUTOREPEAT 1        ' use auto-repeat feature 
    '        DEFINE SCAN_ONCE         0        ' Read keypad untill a key is pressed
    ' 
    '    When using the auto-repeat feature, the delay is the debounce delay (DEBOUNCEMS)
    
    '    Hardware Connection
    '    ===================
    '    1. Column bits must have Pull-up resistor attach to VCC
    '    2. ROW bits must be connected in serie with resistor.
    
    '    Results
    '    =======
    '    Results are always set the same way, even with different keypad type
    '
    '            3X4
    '            ---
    '                       Col0 Col1 Col2 Col3
    '                       ---- ---- ---- ----
    '                         1    2    3    4  Row0
    '                         5    6    7    8  Row1
    '                         9   10   11   12  Row2   
    '
    '            6X5
    '            ---
    '                       Col0 Col1 Col2 Col3 Col4
    '                       ---- ---- ---- ---- ----
    '                         1    2    3    4    5  Row0
    '                         6    7    8    9   10  Row1
    '                        11   12   13   14   15  Row2
    '                        16   17   18   19   20  Row3
    '                        21   22   23   24   25  Row4
    '                        26   27   28   29   30  Row5
    '                        
    
    asm
        errorlevel 0,-207                                  ; Disable 'found opcode after...' warning

    ;
    ;    Macro Definition
    ;    ================
    READKEYPAD macro KeyVar
               L?CALL _KeypadScan
               MOVE?BB _Key,KeyVar
               endm

    ;
    ;    Default settings
    ;    ================
    KB_ROW        = 4                                      ; 4 ROW keypad
    KB_ROW_PORT   = PORTB                                  ; Keypad ROW on PORTB
    KB_ROW_BIT    = 0                                      ; ROW0 = PORTB.0
    KB_COL        = 4                                      ; 4 COL keypad
    KB_COL_PORT   = PORTB                                  ; Keypad Col on PORTB
    KB_COL_BIT    = 4                                      ; COL0 = PORTB.4
    DebounceDelay = d'200'                                 ; debounce delay 200mSec
    SINGLE_SCAN   = 0                                      ; Scan 'till a key is pressed   
    ;
    ;    Software Definition
    ;    ===================
         ;
         ;    Keypad type definition
         ;    ----------------------
    ifdef KEYPAD_ROW
          KB_ROW = KEYPAD_ROW                              ; Assign amount of ROW
          endif
                                   
    ifdef KEYPAD_COL
          KB_COL = KEYPAD_COL                              ; Assign amount of COL
          endif
         
         ;
         ;    ROW pins assignement
         ;    --------------------
    ifdef KEYPAD_ROW_PORT
          KB_ROW_PORT = KEYPAD_ROW_PORT                    ; Assign ROW to user selected PORT
          endif
                                   
    ifdef KEYPAD_ROW_BIT 
          KB_ROW_BIT = KEYPAD_ROW_BIT                      ; Assign ROW0 to user selected BIT
          endif

         ;
         ;    COLUMN pins assignement
         ;    -----------------------
    ifdef KEYPAD_COL_PORT
          KB_COL_PORT = KEYPAD_COL_PORT                    ; Assign COL to user selected PORT
          endif         
          
    ifdef KEYPAD_COL_BIT
          KB_COL_BIT = KEYPAD_COL_BIT                      ; Assign COL0 to user selected BIT
          endif

         ;
         ;    Keypad debounce delay
         ;    ---------------------
    ifdef KEYPAD_DEBOUNCEMS
          DebounceDelay=KEYPAD_DEBOUNCEMS
          endif

         ;
         ;    Single scan or Not
         ;    ------------------
    ifdef SCAN_ONCE
        SINGLE_SCAN = 1
        endif
            
    endasm
    
    '
    '    Variable definition
    '    ===================
    KB_ROW_PORT         VAR BYTE EXT                       ' ROW port
    KB_COL_PORT         VAR BYTE EXT                       ' COL port
    Col                 var byte                           '
    Row                 var byte                           '
    RowBit              var byte                           '
    Key                 var byte                           ' result of scanned key
    KeyTemp             var byte                           '
    
    '
    '    Constant definition
    '    ===================
    SINGLE_SCAN         con      EXT 
    KeyMask             con      EXT                       ' Key mask when reading PORT       
    InitialState        con      EXT                       ' initial ROW PORT value
    KB_ROW              CON      EXT                       ' # row
    KB_COL              CON      EXT                       ' # column
    KB_ROW_BIT          CON      EXT                       ' ROW0 bit
    KB_COL_BIT          CON      EXT                       ' COL0 bit      
    DebounceDelay       CON      EXT                       ' Debounce delay, also Auto-Repeat delay if defined
    asm
        KeyMask = b'11111111' >> (8-KB_COL)                ; use to keep only COL bits
        InitialState=b'00001111' << KB_ROW_BIT             ; Initial state of ROW column bits
    endasm

    '
    '    ////////////////////////////////|\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\        
    '
    '                             Program Start Here                               
    '
    '    ////////////////////////////////|\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\        
    '    
    goto JumpOverKeyScan        

KeypadScan:
    '
    '    Set according TRIS registers
    '    ============================ 
    asm
        variable BitSelect
    
        TRIS_COL = (TRISA + (KB_COL_PORT - PORTA))         ; Find COL TRIS register => input
             CHK?RP TRIS_COL                               ; Move to correct bank
             BitSelect = 0                                 ;
             while BitSelect<KB_COL                        ; Set according TRIS
                   bsf TRIS_COL, KB_COL_BIT+BitSelect      ;     register bits 
                   BitSelect +=1                           ;     to input
                   endw   
            
        TRIS_ROW = (TRISA + (KB_ROW_PORT - PORTA))         ; Find ROW TRIS register => output
             CHK?RP TRIS_ROW                               ; Move to correct bank
             BitSelect = 0                                 ;
             while BitSelect<KB_ROW                        ; Set according TRIS
                   bcf TRIS_ROW, KB_ROW_BIT + BitSelect    ;     register bits
                   BitSelect +=1                           ;     to output 
                   endw
        endasm
    '
    '    Scan the Keypad
    '    ===============
ScanKeypad:
        key=0                                              ' no key is press
        row=0                                              ' begin scan @ ROW0
        col=0                                              '              COL0
        kb_row_PORT=kb_row_PORT | InitialState             ' set all ROW bits to 1
        repeat                                             

            ROWBIT=ROW+KB_ROW_BIT                          ' point to a ROW bit
            kb_row_PORT.0[RowBit]=0                        ' clear actual ROW bit

            Gosub readcol                                  ' Read  column
            if KeyTemp != KeyMask then                     ' Any column to 0?
               REPEAT                                      '    YES
                  IF KeyTemp.0=0 THEN                      '       IF the actual column=0
                      key=row*KB_COL                       '          Calculate 
                      key=key+col                          '              the
                      key=key+1                            '                  Value
                      row=KB_ROW                           '       Set maximum ROW to getout of here
                      @ ifndef KEYPAD_AUTOREPEAT           '       If AutoRepeat is not DEFINE
                               repeat                                    
                                   Gosub readcol           '           Wait until 
                                   until KeyTemp=keymask   '               Key is released
                               @ endif                     
                      PAUSE DebounceDelay                  '        Debounce delay
                      ENDIF                                
                  keytemp=keytemp>>1                       ' shift to next column bit
                  Col=col+1                                ' go to next column    
                  UNTIL COL=KB_COL                         ' COL scan Finished?
               endif                                       

            kb_row_PORT.0[Rowbit]=1                        ' set actual ROW bit
            row=row+1                                      ' point to next row
            until row>(KB_ROW-1)                           
        if (single_scan=0) AND (KEY=0) then ScanKeypad     ' Row scan finished?
    RETURN                                                 ' any key pressed?
        
ReadCol:
    KeyTemp=kb_col_PORT>>kb_col_Bit                        ' Read Column state
    KeyTemp=KeyTemp & kEYMASK                              ' Keep only wanted bits
    return

JumpOverKeyScan:
