;=------------------------------=
;- coder: Alexandros Zahariadis -
;-        Thessaloniki- Greece  -
;- email: bitmaniac@yahoo.com   -
;=------------------------------=
;PIC61F648A (20Mhz crystal) - 4Mhz is ok,too
'NOKIA 3310 LCD MODULE PINOUT
'as viewed from the back (left -> right)
'1 vcc   
'2 sclk  portb.7
'3 sda   portb.6
'4 d/!c  portb.5
'5 !cs   portb.4
'6 gnd
'7 Vout  
'8 !rst  portb.3
INCLUDE "modedefs.bas" 

defINE OSC 20   
CMCON = %00000111 ' Make PortA digital
TRISA = %00000000 
TRISB = %00000000

Lcd_DC      var Portb.5 
Lcd_CS      var Portb.4
Lcd_SDA     var Portb.6
Lcd_RST     var Portb.3
Lcd_CLK     var Portb.7

i           var Byte
j           var Word
k           var Byte
b0          var byte
PosX        var Byte
PosY        var Byte
FontCache   var Byte [6]
LcdStr      var Byte [26]
Lcd_Data    var Byte

Low Lcd_CS 'Chip selected

Gosub Lcd_INIT
Gosub Lcd_Clear

'set contrast
Low Lcd_DC
SHiftOUT Lcd_SDA , Lcd_CLK , MSBFIRST, [ $21,$a7,$20 ]

start:
PosX=0:PosY=0:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["NOKIA LCD TEST"],j
lcdstr(i)=j
next i
Gosub Lcd_SentString
PosX=0:PosY=1:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["{} {} {} {} {}"],j
lcdstr(i)=j
next i
Gosub Lcd_SentString
PosX=0:PosY=2:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["{} GRAPHICS {}"],j
lcdstr(i)=j
next i
Gosub Lcd_SentString
PosX=0:PosY=3:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["{} {} {} {} {}"],j 'cars icons!
lcdstr(i)=j
next i
Gosub Lcd_SentString
PosX=0:PosY=4:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["84 X 48 PIXELS"],j
lcdstr(i)=j
next i
Gosub Lcd_SentString
PosX=0:PosY=5:Gosub Lcd_GotoXY
for i=0 to 13
lookup i,["ALEX BITMANIAC"],j
lcdstr(i)=j
next i
Gosub Lcd_SentString

PAUSE 1000

start2:
'invert screen mode
Low Lcd_DC
Lcd_Data= %00001101:Gosub Lcd_SentByte  ;invert
;Lcd_Data= %00001000:Gosub Lcd_SentByte    ;blank
pause 500

'normal screen mode
Low Lcd_DC
Lcd_Data= %00001100:Gosub Lcd_SentByte
pause 3000
;gosub lcd_clear
goto start2

end

'LCD ROUTINE
Lcd_Init:
'RESET LCD
Low Lcd_RST
pause 20
High Lcd_RST

  Low Lcd_CS : Low Lcd_DC
  Lcd_Data= $21: Gosub Lcd_SentByte		'LCD EXTENDED COMMANDS
  Lcd_Data= $c8: Gosub Lcd_SentByte		'SET LCD Vop (CONTRAST)
  Lcd_Data= $06: Gosub Lcd_SentByte		'SET TEMP COEFFICENT
  Lcd_Data= $10: Gosub Lcd_SentByte		'LCD BIAS MODE 1:48
  Lcd_Data= $20: Gosub Lcd_SentByte		'LCD STANDARD COMMANDS
  Lcd_Data= $0c: Gosub Lcd_SentByte		'LCD IN NORMAL MODE
Return

Lcd_SentByte:
SHiftOUT Lcd_SDA , Lcd_CLK , MSBFIRST, [ Lcd_Data ]
Return

Lcd_SentChar:
sELECT CASE lcd_data
  CASE 48     '0
    j = 156   
  CASE 49     '1
    j = 162
  CASE 50     '2
    j = 168
  CASE 51     '3
    j = 174
  CASE 52     '4
    j = 180
  CASE 53     '5
    j = 186
  CASE 54     '6
    j = 192
  CASE 55     '7
    j = 198    
  CASE 56     '8
    j = 204
  CASE 57     '9
    j = 210
  CASE 32     'space
    j = 216
  CASE 43     '+
    j = 222 
  CASE 45     '-
    j = 228 
  CASE 46     '.
    j = 234 
  CASE 42     '*
    j = 240 
  CASE 58     ':
    j = 246
  CASE 124    'character '|' -> graphic!
for i=0 to 5
LOOKUP2 i,[$7e,$95,$a1,$a1,$95,$7e],b0
fontcache(i)=b0:Next i:goto jump
  CASE 123   'character '{' -> car half left
for i=0 to 5
LOOKUP2 i,[$18,$5c,$ac,$5e,$1d,$1d],b0
fontcache(i)=b0:Next i:goto jump
  CASE 125
for i=0 to 5 'character '}' -> car half right
LOOKUP2 i,[$1d,$1d,$5f,$ac,$5c,$18],b0
fontcache(i)=b0:Next i:goto jump

case else    'letters A-Z -capitals
j=(Lcd_Data-65) * 6
end SELECT
For i=0 to 5
READ j+i,fontcache(i)
Next i
jump:
High Lcd_DC
SHiftOUT Lcd_SDA , Lcd_CLK , MSBFIRST, [ FontCache(0),FontCache(1),FontCache(2),FontCache(3),FontCache(4),FontCache(5) ]
Return

Lcd_SentString:
For k=0 to 13	  ' step -1
Lcd_Data=LcdStr(k)
;If Lcd_Data=0 Then return
pause 80
Gosub Lcd_SentChar
next k
Return

Lcd_Contrast:
Low Lcd_DC
Lcd_Data=$C8:Gosub Lcd_SentByte	'write data
Return

Lcd_Clear:
Gosub Lcd_Home
High Lcd_DC
For i=1 to 252
Lcd_Data=0:Gosub Lcd_SentByte	'write data
Lcd_Data=0:Gosub Lcd_SentByte	'write data
Next i
Return

Lcd_Home:
PosX=0:PosY=0:Gosub Lcd_GotoXY
Return

Lcd_GotoXY:
Low Lcd_DC
Lcd_Data=%01000000 | PosY :Gosub Lcd_SentByte	'Y
Lcd_Data=%10000000 | PosX :Gosub Lcd_SentByte	'X
Return

' Font DATA table

Data $7E,$11,$11,$11,$7E,$00		'65 - A - 41
Data $7F,$49,$49,$49,$36,$00		'66 - B - 42
Data $3E,$41,$41,$41,$22,$00		'67 - C - 43
Data $7F,$41,$41,$22,$1C,$00		'68 - D - 44
Data $7F,$49,$49,$49,$41,$00		'69 - E - 45
Data $7F,$09,$09,$09,$01,$00		'70 - F - 46
Data $3E,$41,$49,$49,$7A,$00		'71 - G - 47
Data $7F,$08,$08,$08,$7F,$00		'72 - H - 48
Data $00,$41,$7F,$41,$00,$00		'73 - I - 49
Data $20,$40,$41,$3F,$01,$00		'74 - J - 4A
Data $7F,$08,$14,$22,$41,$00		'75 - K - 4B
Data $7F,$40,$40,$40,$40,$00		'76 - L - 4C
Data $7F,$02,$0C,$02,$7F,$00		'77 - M - 4D
Data $7F,$04,$08,$10,$7F,$00		'78 - N - 4E
Data $3E,$41,$41,$41,$3E,$00		'79 - O - 4F
Data $7F,$09,$09,$09,$06,$00		'80 - P - 50
Data $3E,$41,$51,$21,$5E,$00		'81 - Q - 51
Data $7F,$09,$19,$29,$46,$00		'82 - R - 52
Data $46,$49,$49,$49,$31,$00		'83 - S - 53
Data $01,$01,$7F,$01,$01,$00		'84 - T - 54
Data $3F,$40,$40,$40,$3F,$00		'85 - U - 55
Data $1F,$20,$40,$20,$1F,$00		'86 - V - 56
Data $3F,$40,$38,$40,$3F,$00		'87 - W - 57
Data $63,$14,$08,$14,$63,$00		'88 - X - 58
Data $07,$08,$70,$08,$07,$00		'89 - Y - 59
Data $61,$51,$49,$45,$43,$00		'90 - Z - 5A
Data $3E,$51,$49,$45,$3E,$00		'48 - 0 - 30
Data $00,$42,$7F,$40,$00,$00		'49 - 1 - 31
Data $42,$61,$51,$49,$46,$00		'50 - 2 - 32
Data $21,$41,$45,$4B,$31,$00		'51 - 3 - 33
Data $18,$14,$12,$7F,$10,$00		'52 - 4 - 34
Data $27,$45,$45,$45,$39,$00		'53 - 5 - 35
Data $3C,$4A,$49,$49,$30,$00		'54 - 6 - 36
Data $01,$71,$09,$05,$03,$00		'55 - 7 - 37
Data $36,$49,$49,$49,$36,$00		'56 - 8 - 38
Data $06,$49,$49,$49,$3E,$00		'57 - 9 - 39
Data $00,$00,$00,$00,$00,$00		'32 -   - 20 
Data $08,$08,$3E,$08,$08,$00		'43 - + - 2B
Data $08,$08,$08,$08,$08,$00		'45 - - - 2D
Data $00,$60,$60,$00,$00,$00		'46 - . - 2E
Data $14,$08,$3E,$08,$14,$00		'42 - * - 2A
Data $00,$36,$36,$00,$00,$00		'58 - : - 3A



       
